/**********************************************************************
 			SYST SOCKET
 **********************************************************************
 Copyright (c) SMARTWARE, 1999, 2000 All Rights Reserved.
 **********************************************************************
 11/03/2004 - Marc LEGOUX - V2R08 : Add syst__SocketConnClosed
 17/12/2003 - Marc LEGOUX - V2R07 : Add syst_SocketTypeUSB
 04/12/2003 - Marc LEGOUX - V2R06 : Add detailled error codes
 30/12/2002 - Marc LEGOUX - V2R01 : Change socket handles from uint to refs
 16/12/2002 - ML - Update prototypes with new syst_SocketInfoType
 11/09/2002 - SD - v1r17 Add TCP prototypes (only DLL target) 
 05/10/2001 - SD - Add syst_SocketOpenX
 14/05/1999 - SD - socket_Option (Rx Tx TimeOut)
 26/05/1999 - SD - Creation
 **********************************************************************/
#ifndef _socket_h
#define _socket_h

#include <err.h>
#include <syst.h>

#ifdef __cplusplus
extern "C" {
#endif

#if config_MLOS32
#define htonl(a) (a)
#define htons(a) (a)
#endif

/*-----------------------ERRORS-----------------------------------------*/
extern err_Type syst__SocketErr;
#define syst__SocketType          (syst__SocketErr + 1)  /* Invalid socket type */
#define syst__SocketAlreadyExist  (syst__SocketErr + 2)  /* Socket exist already */
#define syst__SocketInvalid       (syst__SocketErr + 3)  /* invalid socket reference */
#define syst__SocketNotAvailable  (syst__SocketErr + 4)  /* */
#define syst__SocketEmpty         (syst__SocketErr + 5)  /* Socket is empty */
#define syst__SocketArg           (syst__SocketErr + 6)  /* Bad function argument */
#define syst__SocketPort          (syst__SocketErr + 7)  /* No registered port for with socket */
#define syst__SocketSignal        (syst__SocketErr + 8)  /* Socket is signaled */
#define syst__SocketIO            (syst__SocketErr + 9)  /* Socket I/O troubles */
#define syst__SocketClosed        (syst__SocketErr + 10) /* Socket is closed */
#define syst__SocketNoFunc        (syst__SocketErr + 11) // Function not defined
#define syst__SocketConnClosed    (syst__SocketErr + 12) // Connection is closed

#define syst__SocketErr2          (syst__SocketErr + 20) // Function not defined

// Detailed codes that replace syst_SocketIO
#define syst__Socket2BIG            (syst__SocketErr2 +1)  // argument list too long 
#define syst__SocketACCES           (syst__SocketErr2 +2)  // permission denied 
#define syst__SocketADDRINUSE       (syst__SocketErr2 +3)  // address already in use 
#define syst__SocketADDRNOTAVAIL    (syst__SocketErr2 +4)  // address not available from this host 
#define syst__SocketAFNOSUPPORT     (syst__SocketErr2 +5)  // address family not supported 
#define syst__SocketAGAIN           (syst__SocketErr2 +6)  // resource temporarily unavailable 
#define syst__SocketALREADY         (syst__SocketErr2 +7)  // operation already in progress 
#define syst__SocketAUTH            (syst__SocketErr2 +8)  // authentication error 
#define syst__SocketBADF            (syst__SocketErr2 +9)  // bad descriptor 
#define syst__SocketBUSY            (syst__SocketErr2 +10) // resource busy 
#define syst__SocketCHILD           (syst__SocketErr2 +11) // no child process 
#define syst__SocketCONNABORTED     (syst__SocketErr2 +12) // connection aborted by user 
#define syst__SocketCONNREFUSED     (syst__SocketErr2 +13) // connection refused 
#define syst__SocketCONNRESET       (syst__SocketErr2 +14) // connection reseted by peer 
#define syst__SocketDEADLK          (syst__SocketErr2 +15) // resource deadlock avoided 
#define syst__SocketDESTADDRREQ     (syst__SocketErr2 +16) // destination address required 
#define syst__SocketDOM             (syst__SocketErr2 +17) // value out of range 
#define syst__SocketEXIST           (syst__SocketErr2 +18) // file exists 
#define syst__SocketFAULT           (syst__SocketErr2 +19) // bad address 
#define syst__SocketFBIG            (syst__SocketErr2 +20) // file too big 
#define syst__SocketHOSTDOWN        (syst__SocketErr2 +21) // host down 
#define syst__SocketHOSTUNREACH     (syst__SocketErr2 +22) // host unreachable 
#define syst__SocketIDRM            (syst__SocketErr2 +23) // identifier removed 
#define syst__SocketINPROGRESS      (syst__SocketErr2 +24) // operation now in progress 
#define syst__SocketINTR            (syst__SocketErr2 +25) // interrupted function call 
#define syst__SocketINVAL           (syst__SocketErr2 +26) // invalid argument 
#define syst__SocketIOX             (syst__SocketErr2 +27) // input/output error 
#define syst__SocketISCONN          (syst__SocketErr2 +28) // already connected 
#define syst__SocketISDIR           (syst__SocketErr2 +29) // is a directory 
#define syst__SocketLOOP            (syst__SocketErr2 +30) // too many levels of symbolic links 
#define syst__SocketMFILE           (syst__SocketErr2 +31) // out of descriptors 
#define syst__SocketMLINK           (syst__SocketErr2 +32) // too many links 
#define syst__SocketMSGSIZE         (syst__SocketErr2 +33) // message too big 
#define syst__SocketNEEDAUTH        (syst__SocketErr2 +34) // need authenticator 
#define syst__SocketNETDOWN         (syst__SocketErr2 +35) // network down 
#define syst__SocketNETRESET        (syst__SocketErr2 +36) // network dropped connection on reset 
#define syst__SocketNETUNREACH      (syst__SocketErr2 +37) // network unreachable 
#define syst__SocketNFILE           (syst__SocketErr2 +38) // too many open files in system 
#define syst__SocketNOBUFS          (syst__SocketErr2 +39) // out of resources 
#define syst__SocketNODEV           (syst__SocketErr2 +40) // device not found 
#define syst__SocketNOENT           (syst__SocketErr2 +41) // no such file or directory 
#define syst__SocketNOEXEC          (syst__SocketErr2 +42) // exec format error 
#define syst__SocketNOLCK           (syst__SocketErr2 +43) // no locks available 
#define syst__SocketNOMEM           (syst__SocketErr2 +44) // cannot allocate memory 
#define syst__SocketNOMSG           (syst__SocketErr2 +45) // no message of desired type 
#define syst__SocketNOPROTOOPT      (syst__SocketErr2 +46) // not a valid protocol option 
#define syst__SocketNOSPC           (syst__SocketErr2 +47) // not enougth space to create object 
#define syst__SocketNOSYS           (syst__SocketErr2 +48) // function not implemented 
#define syst__SocketNOTBLK          (syst__SocketErr2 +49) // block device required 
#define syst__SocketNOTCONN         (syst__SocketErr2 +50) // socket not connected 
#define syst__SocketNOTDIR          (syst__SocketErr2 +51) // not a directory 
#define syst__SocketNOTEMPTY        (syst__SocketErr2 +52) // directory not empty 
#define syst__SocketNOTSOCK         (syst__SocketErr2 +53) // not a socket descriptor 
#define syst__SocketNOTTY           (syst__SocketErr2 +54) // not a tty 
#define syst__SocketNXIO            (syst__SocketErr2 +55) // device not configured 
#define syst__SocketOPNOTSUPP       (syst__SocketErr2 +56) // operation not supported 
#define syst__SocketPERM            (syst__SocketErr2 +57) // operation not permitted 
#define syst__SocketPFNOSUPPORT     (syst__SocketErr2 +58) // protocol family not supported 
#define syst__SocketPIPE            (syst__SocketErr2 +59) // pipe broken 
#define syst__SocketPROTONOSUPPORT  (syst__SocketErr2 +60) // protocol not supported 
#define syst__SocketPROTOTYPE       (syst__SocketErr2 +61) // wrong protocol type 
#define syst__SocketRANGE           (syst__SocketErr2 +62) // result too large 
#define syst__SocketROFS            (syst__SocketErr2 +63) // read-only file system 
#define syst__SocketSHUTDOWN        (syst__SocketErr2 +64) // can't send after shutdown 
#define syst__SocketSOCKTNOSUPPORT  (syst__SocketErr2 +65) // socket type not supported 
#define syst__SocketSPIPE           (syst__SocketErr2 +66) // illegal seek 
#define syst__SocketSRCH            (syst__SocketErr2 +67) // no such process 
#define syst__SocketTIMEDOUT        (syst__SocketErr2 +68) // connection timed out 
#define syst__SocketTOOMANYREFS     (syst__SocketErr2 +69) // too many references 
#define syst__SocketWOULDBLOCK      syst__SocketAGAIN      // operation would block 
#define syst__SocketXDEV            (syst__SocketErr2 +70) // cross-device link 
#define syst__SocketNAMETOOLONG     (syst__SocketErr2 +71) // component of the path name too long 
/*-----------------------TYPES------------------------------------------*/
// Protocol Types
#define syst_SocketTypeIP		0
#define syst_SocketTypeUSB		syst_SocketTypeNew('U','S','B',0)

// Protocol Sub Types
#define syst_SocketTypeSubMask		0xFF	// Sub type mask
#define syst_SocketTypeDatagram		((uint)'D')
#define syst_SocketTypeStream		((uint)'S')

/*----------------------------------------------------------------------*
			Build a Socket type
 Parameters: 3 letters or digits for the type and one for the sub type or 0.
 Type     : "abc"
 Sub type : 's' or 0
 *----------------------------------------------------------------------*/
#define syst_SocketTypeNew(a,b,c,s) ((((uint)(a))<<24)+(((uint)(b))<<16)+(((uint)(c))<<8)+((uint)(s)))

#pragma pack(1)               
/*----------------------------------------------------------------------*
			Entity identification
 *----------------------------------------------------------------------*/
#define ipaddr ulong          
typedef struct {              
  ipaddr SrcIp;		// Numeric Ip addr (only if URL == null)
  ulong  SrcPort;	// Port number
  char * URL;		// NULL or URL string, IP string or host name 
  ulong  Mode;		// Mode (default=0)
} syst_SocketInfoType, *syst_SocketInfoRef;

// Old info structure
typedef struct {              
  ipaddr SrcIp;
  uint SrcPort;
} syst_SocketInfo0Type, *syst_SocketInfo0Ref;

/*----------------------------------------------------------------------*
			Socket options
 *----------------------------------------------------------------------*/
typedef struct {
  syst_TType RxTimeOut;
  syst_TType TxTimeOut;
} syst_SocketOptionType, *syst_SocketOptionRef;

/*----------------------------------------------------------------------*
			Socket type
 *----------------------------------------------------------------------*/
#define syst_SocketRef uint

#if config_MLOS32
#pragma pack(0)
#else
#pragma pack()
#endif
/*----------------------------------------------------------------------*
	Create and bind socket
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketOpen(
	syst_SocketRef *pSock,	 	// (OUT): Socket
	uint Port, 			// Port to bind to
	uint Type			// Socket type
        );
/*----------------------------------------------------------------------*
	Create and bind socket
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketOpenX(
	syst_SocketRef *pSock,		// (OUT): Socket 
	uint Type,			// Socket type
	syst_SocketInfoType * Info	// Entity to bind to
	);
/*----------------------------------------------------------------------*
  	Close socket
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketClose(
	syst_SocketRef Socket
	);
/*----------------------------------------------------------------------*
	Receive Message
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketRecvFrom(
	syst_SocketRef Socket,
	uchar *pData,
	uint *pRespl,
	syst_SocketInfoType * Info	// OUT : Calling Entity
	);
/*----------------------------------------------------------------------*
	Send Message
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketSendTo(
	syst_SocketRef Socket,
	uchar *pData,
	uint Lg,
	syst_SocketInfoType * Info	// Destination entity
	);
/*----------------------------------------------------------------------*
	Set options
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketOptionSet(
	syst_SocketRef Socket,
	syst_SocketOptionRef pOption
	);
/*----------------------------------------------------------------------*
	Get options
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketOptionGet(
	syst_SocketRef Socket,
	syst_SocketOptionRef pOption	// OUT: Socket options
	);

/*----------------------------------------------------------------------*
  	Signal a socket
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketSignal(
	syst_SocketRef Socket
	);
/*----------------------------------------------------------------------*
	Stream send
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketSend(
	syst_SocketRef Socket, 
	uchar *pData, 	// (IN) : Data buffer
	uint Lg		// Data length
	);

/*----------------------------------------------------------------------*
	Stream receive
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketRecv(
	syst_SocketRef Socket, 
	uchar *pData, 	// OUT : Data buffer
	uint *pRespl	// IN: Max data length, OUT: received data length
	);
/*----------------------------------------------------------------------*
  	Shutdown
 *----------------------------------------------------------------------*/
#define syst_SocketShutdownModeR	1	// Receive
#define syst_SocketShutdownModeT	2	// Transmit
#define syst_SocketShutdownModeRT	3	// both
extern
err_Type syst_SocketShutdown(
	syst_SocketRef Socket,
	uint Mode
	);
/*----------------------------------------------------------------------*
	Listen
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketListen(
	syst_SocketRef Socket,
	uint backlog	 // Max queue length for pending connection 
	);
/*----------------------------------------------------------------------*
	Connect
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketConnect(
	syst_SocketRef Socket,
	syst_SocketInfoType * Info	// Destination entity
	);
/*----------------------------------------------------------------------*
  	Accept a connection
 *----------------------------------------------------------------------*/
extern
err_Type syst_SocketAccept(
	syst_SocketRef Socket,
	syst_SocketRef *pSocket,	// OUT : New socket to handle the connection
	syst_SocketInfoType *pInfo	// OUT : Calling entity
	);
/*----------------------------------------------------------------------*
                Set Ip Infos
                for Current Class
 *----------------------------------------------------------------------*/
typedef
  struct {
    ulong	Ip;		// Local Ip address
    ulong	IpBase;		// Base Ip address for Ip = IpBase+Node
    ulong	IpMask;		// Sub-net mask
    ulong	IpGate;
    ulong	RFU1;
    unsigned	IpBoard;	// IN : Select a physical interface
                                // == driver Id or 0 for current (0..0xFFFF)
  } syst_SocketInfoIpType;

/*----------------------------------------------------------------------*
                Get/Set Ip Infos
                for Current Socket Class
 Info->IpBoard : IN to select an interface or 0 for current. 
 0 values are ignored or set to default values according to Mode
 *----------------------------------------------------------------------*/
#define syst_SocketInfoModeGet		1	// else Set
#define syst_SocketInfoModeDefault	2	// Set 0 values to default
extern 
err_Type syst_SocketInfoIpGetSet(
        syst_SocketInfoIpType * Info, 	// IN,OUT (except ->IpBoard)
        unsigned Mode
        );
/*----------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif

#endif
