/************************************************************************
			SEMAPHORES
 ************************************************************************
 Copyright (c) SMARTWARE, 1999, 2002 All Rights Reserved.
 ************************************************************************
 10/12/2002 - Marc LEGOUX - c6r09 : Add syst_SemIncrClear
 10/12/2002 - Marc LEGOUX - c6r08 : Creation
 ************************************************************************/
#ifndef systse_h
#define systse_h

#include <config.h>	/* Configuration */
#include <err.h>	/* Errors */
#include <syst.h>

#if config_WIN
#include <windows.h>	/* For private types with windows representation*/
#include <windowsx.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*-------------------------- ERRORS -----------------------------------*/
#define syst__SemOpen	(syst__Err+24)	// Sem open error
#define syst__SemIncr	(syst__Err+25)	// Too big increment

/*----------------------------------------------------------------------*
			Types
 *----------------------------------------------------------------------*/
#if config_WIN
typedef
  struct {
    HANDLE	hSem;
    int		Mode;
  } syst_SemType;

#else

typedef
  struct {
    void *		Private2;
    void *		Private3;
    syst_EventType	Private1;
    
  } syst_SemType;
#endif
/*----------------------------------------------------------------------*
                Open
 To create [or open] a [named] semaphore
 *----------------------------------------------------------------------*/
extern
err_Type syst_SemOpen(
        syst_SemType * Sem,	// (OUT): Semaphore to init
        ulong Count,		// Initial count <= CountMax
        ulong CountMax,		// Maximum count
        char * Name		// name or NULL 
        );
/*----------------------------------------------------------------------*
                Close
 To delete [or close] a [named] semaphore
 *----------------------------------------------------------------------*/
extern
err_Type syst_SemClose(
        syst_SemType * Sem		// Semaphore
        );
/*----------------------------------------------------------------------*
                Wait
 Waits for the semaphore count is not zero. 
 The count is decremented each time a task passes successfully the function 
 (OK is returned). 
 If the time is exceeded, the function returns syst__Timeout.
 *----------------------------------------------------------------------*/
extern
err_Type syst_SemWait(
        syst_SemType * Sem,		// Semaphore
        syst_TType Timeout		// Max time to wait (ms) 
        );
/*----------------------------------------------------------------------*
                Release
 Increase by Incr the count of the semaphore. 
 Up to Incr waiting tasks are resumed. 
 If Incr increases the semaphore count above the maximum, the count is not 
 changed and an error is returned. 
 *----------------------------------------------------------------------*/
#define syst_SemIncrClear	0x80000000
extern
err_Type syst_SemRelease(
        syst_SemType * Sem,	// (IN): Sem 
        ulong	   Incr,	// Value to add to the semaphore count
                                // syst_SemIncrClear resets the semaphor count
        ulong * pCount		// Null or (OUT) : Previous semaphore count
        );
/*----------------------------------------------------------------------*/


#ifdef __cplusplus
}
#endif
#endif
