/***********************************************************************
                        SYStem parameters
                        Object identifiers
 ***********************************************************************
 Copyright (c) SMARTWARE, 1999 All Rights Reserved.
 ***********************************************************************
 18/03/03- Marc LEGOUX : c6r09 : Add Ids for card interfaces
 12/01/00- Marc LEGOUX : c6r02 : Add sys object
 27/10/99- Marc LEGOUX : Add Des, Ethernet, Bdm
 07/12/97- Marc LEGOUX : Add rdc Ops
 25/11/97- Marc LEGOUX : Bug CdpCfg, CdpPipe
 30/04/97- Marc LEGOUX : Add Etu, PTS
 04/04/97- Marc LEGOUX : Update from own module
 ***********************************************************************/
#ifndef sys_h
#define sys_h
#include "sysapp.h"	/* Application objects */

/*----- SYSTEM and STANDARD OBJECT CODES ------------------------------*/
#define	sys_KrnId	0x00	/* System kernel */
#define	sys_SysId	0x00	/* System kernel */
#define sys_RdcId	0x08	/* Remote Call on a Net */
#define sys_ExecId	0x08	/* Exec from remote call */

#define sys_CdId	0x10	// Secu (normal) card 
#define sys_CdpId	0x18	// Perso card 
#define sys_Cd1Id	0x10	// Contact Card 1
#define sys_Cd2Id	0x18	// Contact Card 2
#define sys_Cd3Id	0x20	// Contact Card 3
#define sys_Cd4Id	0x28	// Contact Card 4

#define sys_NetobId	0x30	// Netob

#define sys_CdP1Id	0x40	// Proximity Card 1
#define sys_CdP2Id	0x48	// Proximity Card 2

#define sys_KeybId	0x18
#define sys_LcdId	0x20
#define sys_KbioId	0x38

#define sys_EthernetId	0x50

#define sys_D9346Id	0x60
#define sys_ClkId	0x68

#define sys_TermId	0x70
#define sys_CfgId	0x78

#define sys_DesId	0xE0
#define sys_BdmId	0xE8

#define sys_HwiId	0xF8	/* Hardware interface */
#define sys_Hwi1Id	0xF0	/* First Hardware interface */
#define sys_Hwi2Id	0xF8	/* 2nd Hardware interface */

#define sys_EoolId	0xFF	/* End of Object List */
#define sys_NullId	0x00	/* Null entry in object list */

/*----- AIA: Application Interface Areas ------------------------------*/
#define sys_aia2	0x8000
#define sys_aia_l	48

/* Magic word */
#define sys_magic_o	0		/* 1 word */
#define sys_magic_0	'M'		/* byte 0 */
#define sys_magic_1	'L'		/* byte 1 */
/* Data (future use) */
#define sys_data_o	2		/* set to 0ffh */
/* Memory config */
#define sys_config_o	3
#define sys_32k_bit	0	/* Memory board of area is 32k(8k) */
/* Buffer */
#define sys_buf_iaddr_o	4		/* <> 0ffh if valid */
#define sys_buf_ilng_o	5
/* Interrupt vectors */
#define sys_it_vect_o	6
#define sys_t0_it_o	6		/* Ljmp instruction */
#define sys_int1_it_o	9		/* Ljmp instruction */

#define sys_waia_b1_o	12		/* Write area : block 1 */
#define sys_t1_it_o	12		/* Ljmp instruction */
#define sys_sio_it_o	15		/* Ljmp instruction */
#define sys_t2_it_o	18		/* Ljmp instruction */
/* Application entries (for future use) */
#define sys_entry1_o	21		/* Ljmp instruction */
#define sys_entry2_o	24		/* Ljmp instruction */

/* Application driver list */
#define sys_waia_b2_o	27		/* Write area : block 2 */
#define sys_aia_dl_o	27		/* <driver id><driver descriptor addr> */

#define sys_aia_drv_num ((sys_aia_l - sys_aia_dl_o)/3) /* Max driver num */

#define sys_ljmp_opcode	02
#define sys_reti_opcode	0x32
#define sys_ret_opcode	0x22

/* Loadable Memory limits 32K (8Bits) */
#define hwi_xdata_fadd	0x0000	/* Runable from 0x8000 only */
#define hwi_xdata_ladd	0xFEFF

/* Loadable Memory limits (32Bits) */
#define hwi_FlAddr	0x00800000	/* From hwi.h */
#define hwi_LlAddr	0x00FFFFFF

/*----- OBJECT OPERATION CODES ----------------------------------------*/
#define sys_KrnInit  sys_KrnId+1	/* Init Kernel */

/* exec */
#define sys_ExecOps	sys_ExecId+2 /* Exec sub-Ops */
#define sys_Exec_xdrv	sys_ExecId+3 /* addh, addl, op_num, [args ...] */
#define sys_Exec_waia2	sys_ExecId+4 /* addh, addl, lng */
#define sys_Exec_rxdata	sys_ExecId+5 /* addh, addl, lng */
#define sys_Exec_wxdata	sys_ExecId+6 /* addh, addl, lng, data... */
#define sys_Exec_ridata	sys_ExecId+7 /* add, [lng=32] */

/* Rdc */
#define sys_RdcSelect	sys_RdcId+7	/* Select the current rdc */
#define sys_RdcOps	sys_RdcId+6	/* Sub-Ops */
/* All ops concerning a data value return the value when no arg,
   otherwise set the value with the args */
/* Common sub-codes: */
#define sys_RdcProtOp		0	/* <prot name (max 10, \0)> */
#define sys_RdcOpenCloseOp	1	/* <open=1/close=0> Line open : Start communication */
/* Protocol Specific sub-codes: */
#define sys_RdcPortOp		0x80	/* <port (2)> */
#define sys_RdcBaudRateOp	0x81	/* <baud rate (4)> */
#define sys_RdcModemNumOp	0x82	/* <modem num (max 20, \0)> */
#define sys_RdcModemInitOp	0x83	/* <modem init string (max 80, \0)> */

/* CARD : see sysc.h */

/* CLK */
#define sys_ClkSet	(sys_ClkId+2)
#define sys_ClkRead	(sys_ClkId+3)

/* TERM */
#define sys_TermPutl	sys_TermId+3

/* HWI */
// Same codes as sys_MOps (SYSX.H) (For compatibility with facet)
#define sys_HwiMOps	sys_Hwi1Id+2	/* Set of sub-operations (c obj)*/
#define sys_HwiMOpInfo		0
#define sys_HwiMOpPStart	1
#define sys_HwiMOpPEnd		2
#define sys_HwiMOpRead		0xF5
#define sys_HwiMOpWrite		0xF6

#define sys_HwiOps	sys_Hwi1Id+4	/* Set of sub-operations (c obj)*/
#define sys_HwiXOps	sys_Hwi2Id+5	/* Special set of sub-ops */
#define sys_HwiXOpsVGet	0		/* Get voltage (Special sub-op) */
#define sys_HwiXOpsIGet	1		/* Get Icc (Special sub-op) */
#define sys_HwiXOpsOS	2		/* Open short (Special sub-op) */

/* Standard timeout (2s) */
#define std_timeout 2000

#endif
