/***********************************************************************
                HWI
                HardWare Interface
                For all Stations
 ***********************************************************************
 17/03/2006 - Marc LEGOUX - V2r23 : Add hwi_WaitU()
 15/06/2005 - Marc LEGOUX - V2r22 : Add hwi_InfoGet()
 04/04/2005 - Marc LEGOUX - V2r21 : Extract from HWI_ V2R09
 ***********************************************************************/
#ifndef hwimisc_h
#define hwimisc_h

#include <err.h>
/************************************************************************
			Configuration
 ************************************************************************/
/*----------------------------------------------------------------------*
                        Cfg flags
 b0       : Start in safe mode (system Backup)
 b1       : Do not start packages
 b2..b8   : 0
 b9..12   : Serial lines (1,2) configuration
 b13..b15 : 0
 *----------------------------------------------------------------------*/
#define hwi_CfgFlagSafeMode	0x0001
#define hwi_CfgFlagNoPackage	0x0002
#define hwi_CfgFlagL1Mode	0x0200	// RS232  else default
#define hwi_CfgFlagL1Baud	0x0400	// 115200 else default
#define hwi_CfgFlagL2Mode	0x0800	// RS232  else default
#define hwi_CfgFlagL2Baud	0x1000	// 115200 else default

extern
err_Type hwi_CfgFlagGet(unsigned * pFlag);
/*---------------------------------------------------------------------*
                        Local Node Get
 0 = Not defined, 1..127 = Defined
 *---------------------------------------------------------------------*/
extern
err_Type hwi_NodeGet(uchar * pnode);

/*---------------------------------------------------------------------*
                        Info Get
 *---------------------------------------------------------------------*/
extern
err_Type hwi_InfoGet(
        char * McuVersion,	// OUT : 32 max
        char * HwVersion,	// OUT : 32 max
        char * SN,		// OUT : 32 max
        char * RFU
        );
/************************************************************************
			Watch dog
 ************************************************************************
 When On watch dog makes a reset, or calls an irq routine if defined. 
 ************************************************************************/
#define hwi_WDogMaskOn		1	// On (else OFF)
#define hwi_WDogMaskTimeout	2	// Set timeout period
#define hwi_WDogMaskTimeoutMax	4	// Set max timeout period
#define hwi_WDogMaskIrq		8	// Set Irq routine 

#define hwi_WDogModeOn		1	// On (else OFF)

typedef
  struct {
    ulong Mask;
    ulong Mode;
    ulong Timeout;		// ms
    void * Irq;			// 0 to disable Irq or Irq routine
    void * IrqParam;		// 0 or Irq routine param
    
  } hwi_WDogCfgType;
/*----------------------------------------------------------------------*
			Reset WD counter
 *----------------------------------------------------------------------*/
extern
err_Type hwi_WDogService();
/*----------------------------------------------------------------------*
                Config set
 *----------------------------------------------------------------------*/
extern
err_Type hwi_WDogCfgSet(
        hwi_WDogCfgType * Cfg		// 0 or Configuration
        );
/*----------------------------------------------------------------------*
                Config Get
 *----------------------------------------------------------------------*/
extern
err_Type hwi_WDogCfgGet(
        hwi_WDogCfgType * Cfg		// 0 or (OUT) : Configuration
        );
/*----------------------------------------------------------------------*
                Reset MCU
 *----------------------------------------------------------------------*/
extern
err_Type hwi_McuReset();

/*----------------------------------------------------------------------*
		Hardware Wait
 *----------------------------------------------------------------------*/
extern
err_Type hwi_WaitU(
	ulong Timeout, 
	int Unit		//0:ms, -1:0.1ms, 1:10ms 
	);
/***********************************************************************/
#endif
