/**********************************************************************
                US-CMT USER C-INTERFACE
 **********************************************************************
 Copyright (c) SMARTWARE, 2006-2015 All Rights Reserved.
 **********************************************************************
 25/09/2015 - SHM - v2r07e : Add cmt_StateAPup define for cmt_CxSet/Get
 11/12/2013 - SHM - v2r07a : Add cmt_VCxAcqModeFI mode.
                             Add cmt__Internal error code.
 07/12/2011 - SHM - v2r06a : Add cmt__InitDefault.
                             Fix diagnose error with firmware V3R03
 17/03/2011 - SHM - v2r05c : Add cmt__MeasCorrupt error code.
 06/12/2010 - SHM - v2r05a : Add cmt_ICxAcqSet, cmt_ICxAcqGet, cmt_ICxAcqStop,
                             cmt_VCxAcqSet, cmt_VCxAcqGet, cmt_VCxAcqStop,
                             cmt_TemperatureGet,
                             Add cmt__Count, cmt__Period error codes,
                             Rename cmt_IC1Set, cmt_IC1Get to cmt_IccSet, cmt_IccGet,
                             Rename error code cmt__IC1Get, cmt__MeasMode 
                             to cmt__Measuring, cmt__MeasBusy
 28/09/2010 - SHM - v2r04a : Add cmt_CfgIC1IRange, cmt_IC1ModeUnit defines
 15/10/2009 - SHM - v2r03a : Add _TimeOut Set and Get methods
                             Add _Cx Set and Get, _ICxGet and _OpenShortTest methods
                             Add cmt__Busy error code
 23/06/2008 - SHM - v2r02a : Add cmt_Diagnose and associated defines
 13/12/2007 - SHM - v2r01a : Add cmt_VhDefault, cmt_VlDefault defines
 28/04/2007 - SHM - v1r03a : Add cmt__Eeprom Error Code;
                        Add Pull-Up Configuration defines for _CfgSet/Get methods;
                        Add Time Establishment Configuration defines for _CfgSet/Get methods;
 13/10/2006 - SHM - v1r01b : Add FIMV FVMI measurement on C5;
                        Add define for CfgSet
 26/06/2006 - DM - v1r01b : From v1r01a
 22/03/2006 - DM - v1r01a : Creation
 **********************************************************************/
#ifndef cmt_h
#define cmt_h

#include "../MLOS/err.h"
#include "../MLOS/sysobj.h"
#include "../MLOS/syst.h"



#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------*
                CMT Error Code
 *----------------------------------------------------------------------*/
#define cmt__Err		26050		// CMT base Error. DO NOT MODIFY
#define cmt__Type		(cmt__Err + 1)	// Invalid Interface
#define cmt__Arg		(cmt__Err + 2)	// Invalid Argument
#define cmt__Vh			(cmt__Err + 3)	// Invalid High Voltage Value
#define cmt__Vl			(cmt__Err + 4)	// Invalid Low Voltage Value
#define cmt__Voltage		(cmt__Err + 5)	// Invalid Voltage Value
#define cmt__IRange		(cmt__Err + 6)	// Invalid Current Range Value
#define cmt__Cx			(cmt__Err + 7)	// Invalid Contact Value
#define cmt__Current		(cmt__Err + 8)	// Invalid Current Value
#define cmt__Calib		(cmt__Err + 9)	// Invalid Calibration
#define cmt__Measuring		(cmt__Err + 10)	// Measure is not ready. Measurement has not started or is not finished
#define cmt__IC1Get		cmt__Measuring	// Current Consumption Measurement not Ready
#define cmt__HwSkillLvl		(cmt__Err + 11)	// Insufficient Hardware
#define cmt__Param		(cmt__Err + 12)	// Invalid Configuration Parameter
#define cmt__Value		(cmt__Err + 13)	// Invalid Configuration Value
#define cmt__MeasBusy		(cmt__Err + 14)	// Measurement stage in use. Another measurement or acquisition is already started
#define cmt__MeasMode		cmt__MeasBusy	// Invalid Measurement Mode
#define cmt__Event		(cmt__Err + 15)	// Invalid Event Value
#define cmt__EventOc		(cmt__Err + 16)	// Invalid Event Occurence Value
#define cmt__Delay		(cmt__Err + 17)	// Invalid Delay Value
#define cmt__CardOn		(cmt__Err + 18)	// Card is powered
#define cmt__Eeprom		(cmt__Err + 19)	// Invalid EEPROM Value
#define cmt__Meas		(cmt__Err + 20)	// No Measurement Available
#define cmt__Busy		(cmt__Err + 21)	// Interface is busy
#define cmt__State		(cmt__Err + 22)	// Invalid contact state
#define cmt__Count		(cmt__Err + 23)	// Invalid Count value
#define cmt__Period		(cmt__Err + 24)	// Invalid Period value
#define cmt__MeasOvf		(cmt__Err + 25)	// Measurement buffer overflow
#define cmt__MeasCorrupt	(cmt__Err + 26)	// Measurement buffer corrupted
#define cmt__Internal		(cmt__Err + 30)	// Internal error (Out of range value)


/*----------------------------------------------------------------------*
                CMT Configuration's Parameters and Values
 *----------------------------------------------------------------------*/
#define cmt_ModeNull		0x00


/************************************************************************
                        PUBLIC CMT TYPE
 ************************************************************************/
#define cmt_Type  void



/************************************************************************
 ************************************************************************
	CMT DRIVER INITIALIZATION AND CONFIGURATION METHODS :
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  cmt_New : Create a Handle to US-CMT Driver and link it to an interface
 *----------------------------------------------------------------------*/
extern
err_Type cmt_New(
        cmt_Type ** pObj,	// (Out) Handle to CMT Driver
        void *Card		// (In) Contact Card Interface initialized for communications
        );

/*----------------------------------------------------------------------*
  cmt_Del : Delete Handle to US-CMT Driver and set it to NULL
 *----------------------------------------------------------------------*/
extern
err_Type cmt_Del(
        cmt_Type ** pObj	// (In,Out) Handle to CMT Driver
        );

/*----------------------------------------------------------------------*
  cmt_ObjTimeoutSet : Set CMT methods timeout value for remote applications
 *----------------------------------------------------------------------*/
err_Type cmt_ObjTimeoutSet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Timeout		// (In) Timeout value in ms
        );

/*----------------------------------------------------------------------*
  cmt_ObjTimeoutGet : Get CMT methods timeout value for remote applications
 *----------------------------------------------------------------------*/
err_Type cmt_ObjTimeoutGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong *pTimeout		// (Out) Timeout value in ms
        );



/************************************************************************
 ************************************************************************
	CMT DRIVER METHODS
 ************************************************************************
 ************************************************************************/

// OBN Class cmt BEGIN IdNum=26050 Version=V2r07a Author=SHM


/*----------------------------------------------------------------------*
  cmt_CxVoltageSet : Set Vh and Vl voltage on contacts 
 *----------------------------------------------------------------------*/
#define cmt_CxVoltageC1		0x01
#define cmt_CxVoltageC2		0x02
#define cmt_CxVoltageC3		0x04
#define cmt_CxVoltageC4		0x08
#define cmt_CxVoltageC6		0x10
#define cmt_CxVoltageC7		0x20
#define cmt_CxVoltageC8		0x40
#define cmt_CxVoltageCAll	0x7F

#define cmt_VohDefault		5000
#define cmt_VolDefault		0

extern
err_Type cmt_CxVoltageSet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Setting Mode
        ulong CxMask,		// OBN IN : (In) Contacts Mask Selection
        ulong Voh,		// OBN IN : (In) Output Voltage High in mV
        ulong Vol		// OBN IN : (In) Output Voltage Low in mV
        );

/*----------------------------------------------------------------------*
  cmt_CxVoltageGet : Get Vh and Vl voltage on a selected contact
 *----------------------------------------------------------------------*/
extern
err_Type cmt_CxVoltageGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong *pMode,		// OBN IN,OUT,Length=1: (In) Getting Mode, (Out) Current Setting Mode
        ulong CxMask,		// OBN IN : (In) Contact Selection
        ulong *Voh,		// OBN OUT,Length=1: : (Out) Output Voltage High in mV
        ulong *Vol		// OBN OUT,Length=1: (Out) Output Voltage Low in mV
        );

/*----------------------------------------------------------------------*
  cmt_C7LevelMonitorSet : Enable/Disable C7 Level Monitoring
 *----------------------------------------------------------------------*/
#define cmt_C7LvlMonitorModeDisable	0	// Disable C7 level monitoring
#define cmt_C7LvlMonitorModeEnable	1	// Enable C7 level monitoring

extern
err_Type cmt_C7LevelMonitorSet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode Enable / Disable
        ulong Vih,		// OBN IN : (In) High Voltage threshold in mV
        ulong Vil		// OBN IN : (In) Low Voltage threshold in mV
        );

/*----------------------------------------------------------------------*
  cmt_C7LevelMonitorGet : Get C7 Level Monitoring Status
 *----------------------------------------------------------------------*/
#define cmt_C7LvlMonitorGetOK		0	// C7 Level Monitoring has no error
#define cmt_C7LvlMonitorGetVih		1	// C7 Level Monitoring has errors on Vih
#define cmt_C7LvlMonitorGetVil		2	// C7 Level Monitoring has no errors on Vil
#define cmt_C7LvlMonitorGetVihVil	3	// C7 Level Monitoring has errors on both Vih and Vil

extern
err_Type cmt_C7LevelMonitorGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong *pMode,		// OBN IN,OUT,Length=1: (In) Getting Mode, (Out) Current Setting Mode
        ulong *pStatus		// OBN OUT,Length=1 : (Out) Monitoring Status
        );

/*----------------------------------------------------------------------*
  cmt_FVMI : Force Voltage and Measure Current
 *----------------------------------------------------------------------*/
#define cmt_IRangeAuto		0
#define cmt_IRange1		1
#define cmt_IRange2		2
#define cmt_IRange3		3
#define cmt_IRange4		4
#define cmt_IRange5		5
#define cmt_IRange6		6

#define cmt_C1			1
#define cmt_C2			2
#define cmt_C3			3
#define cmt_C4			4
#define cmt_C5			5
#define cmt_C6			6
#define cmt_C7			7
#define cmt_C8			8

#define cmt_C1ToGnd		1
#define cmt_C2ToGnd		2
#define cmt_C3ToGnd		3
#define cmt_C4ToGnd		4
#define cmt_C5ToGnd		5
#define cmt_C6ToGnd		6
#define cmt_C7ToGnd		7
#define cmt_C8ToGnd		8
#define cmt_CxToGndDef		5

extern
err_Type cmt_FVMI(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Voltage,		// OBN IN : (In) Forced Voltage in mV
        long *pCurrent,		// OBN OUT,Length=1 : (Out) Current Value in nA
        ulong IRange,		// OBN IN : (In) Current Range
        ulong CxSel,		// OBN IN : (In) Selected Contact to apply Voltage
        ulong CxToGnd,		// OBN IN : (In) Selected Contact to Gnd
        ulong Mode		// OBN IN : (In) Mode
        );

/*----------------------------------------------------------------------*
  cmt_FIMV : Force Current and Measure Voltage
 *----------------------------------------------------------------------*/
extern
err_Type cmt_FIMV(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong *pVoltage,	// OBN OUT,Length=1 : (Out) Voltage Value in mV
        long Current,		// OBN IN : (In) Forced Current in nA
        ulong IRange,		// OBN IN : (In) Current Range
        ulong CxSel,		// OBN IN : (In) Selected Contact to apply Current
        ulong CxToGnd,		// OBN IN : (In) Selected Contact to Gnd
        ulong Mode		// OBN IN : (In) Mode
        );

/*----------------------------------------------------------------------*
  cmt_IccSet : Start/Stop Dynamic Current Consumption Measurement
 *----------------------------------------------------------------------*/
#define cmt_IccModeConfig		0	// Configure Dynamic Current Consumption Measurement 
#define cmt_IccModeEnable		1	// Enable Dynamic Current Consumption Measurement 
#define cmt_IccModeDisable		2	// Disable Dynamic Current Consumption Measurement 

#define cmt_EventNone			0
#define cmt_EventTxStart		1
#define cmt_EventTxEnd			2
#define cmt_EventRxStart		3
#define cmt_EventReset			4
#define cmt_EventExtInput		10

extern
err_Type cmt_IccSet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode
        ulong Event,		// OBN IN : (In) Event
        ulong EventOc,		// OBN IN : (In) Event Occurence
        ulong Delay		// OBN IN : (In) Delay computed after "Event Occurence", in clk cycles
        );

/*----------------------------------------------------------------------*
  cmt_IccGet : Get Dynamic Current Consumption Measurement
 *----------------------------------------------------------------------*/
#define cmt_IccModeUnitMicro		0x000	// Get measured current in uA
#define cmt_IccModeUnitNano		0x100	// Get measured current in nA

extern
err_Type cmt_IccGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong *pMode,		// OBN IN,OUT,Length=1: (In) Getting Mode, (Out) Current Setting Mode
        ulong *pIcc		// OBN OUT,Length=1 : (Out) Current Measured in uA
        );

/*----------------------------------------------------------------------*
  cmt_Diagnose : Diagnose the board
 *----------------------------------------------------------------------*/
#define cmt_DiagnoseMeasurement	1
#define cmt_DiagnoseContacts	2

#define cmt_DiagnoseAll		0xFFFFFFFF
#define cmt_DiagnoseMV		0x00000001
#define cmt_DiagnoseFV		0x00000010
#define cmt_DiagnoseMI		0x00003F00
#define cmt_DiagnoseFI		0x003F0000
#define cmt_DiagnoseCx		0x000000EF
#define cmt_DiagnoseCxPullUp	0x0000EE00
#define cmt_DiagnoseCxRead	0x00EF0000

#define cmt_DiagnoseOk		0x00000000
#define cmt_DiagnoseMI1		0x00000100
#define cmt_DiagnoseMI2		0x00000200
#define cmt_DiagnoseMI3		0x00000400
#define cmt_DiagnoseMI4		0x00000800
#define cmt_DiagnoseMI5		0x00001000
#define cmt_DiagnoseMI6		0x00002000
#define cmt_DiagnoseFI1		0x00010000
#define cmt_DiagnoseFI2		0x00020000
#define cmt_DiagnoseFI3		0x00040000
#define cmt_DiagnoseFI4		0x00080000
#define cmt_DiagnoseFI5		0x00100000
#define cmt_DiagnoseFI6		0x00200000

#define cmt_DiagnoseC1		0x00000001
#define cmt_DiagnoseC2		0x00000002
#define cmt_DiagnoseC3		0x00000004
#define cmt_DiagnoseC4		0x00000008
#define cmt_DiagnoseC6		0x00000020
#define cmt_DiagnoseC7		0x00000040
#define cmt_DiagnoseC8		0x00000080
#define cmt_DiagnoseC2PullUp	0x00000200
#define cmt_DiagnoseC3PullUp	0x00000400
#define cmt_DiagnoseC4PullUp	0x00000800
#define cmt_DiagnoseC6PullUp	0x00002000
#define cmt_DiagnoseC7PullUp	0x00004000
#define cmt_DiagnoseC8PullUp	0x00008000
#define cmt_DiagnoseC1Read	0x00010000
#define cmt_DiagnoseC2Read	0x00020000
#define cmt_DiagnoseC3Read	0x00040000
#define cmt_DiagnoseC4Read	0x00080000
#define cmt_DiagnoseC6Read	0x00200000
#define cmt_DiagnoseC7Read	0x00400000
#define cmt_DiagnoseC8Read	0x00800000

extern
err_Type cmt_Diagnose(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode
        ulong Type,		// OBN IN : (In) Type
        ulong Param,		// OBN IN : (In) Parameter
        ulong *pStatus		// OBN OUT,Length=1 : (Out) diagnosis value
        );

/*----------------------------------------------------------------------*
  cmt_SysInfoGet : Return Ecomp System information - String Size = 128 bytes
 *----------------------------------------------------------------------*/
extern
err_Type cmt_SysInfoGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        char *StrInfo		// OBN OUT,Length=128:(Out) Information string
        );

/*----------------------------------------------------------------------*
                CMT Configuration's Parameters and Values
 *----------------------------------------------------------------------*/
#define cmt_CfgMeasMode		0x01		// Set de measurement mode
#define cmt_IC1MeasEnable	0x01		// Enable Currant Consumption
#define cmt_IC1MeasDisable	0x00		// Disable Currant Consumption

#define cmt_CfgCalibration	0x02		// Get hardware calibration report 
#define cmt_CalibMV		0x00000001L	// Measure Voltage
#define cmt_CalibFV		0x00000010L	// Force Voltage
#define cmt_CalibMI1		0x00000100L	// Measure Current on Range 1
#define cmt_CalibMI2		0x00000200L	// Measure Current on Range 2
#define cmt_CalibMI3		0x00000400L	// Measure Current on Range 3
#define cmt_CalibMI4		0x00000800L	// Measure Current on Range 4
#define cmt_CalibMI5		0x00001000L	// Measure Current on Range 5
#define cmt_CalibMI6		0x00002000L	// Measure Current on Range 6
#define cmt_CalibFI1		0x00010000L	// Force Current on Range 1
#define cmt_CalibFI2		0x00020000L	// Force Current on Range 2
#define cmt_CalibFI3		0x00040000L	// Force Current on Range 3
#define cmt_CalibFI4		0x00080000L	// Force Current on Range 4
#define cmt_CalibFI5		0x00100000L	// Force Current on Range 5
#define cmt_CalibFI6		0x00200000L	// Force Current on Range 6
#define cmt_CalibC1		0x01000000L	// Voltage on C1
#define cmt_CalibC2		0x02000000L	// Voltage on C2
#define cmt_CalibC3		0x04000000L	// Voltage on C3
#define cmt_CalibC4		0x08000000L	// Voltage on C4
#define cmt_CalibC5		0x10000000L	// Voltage on C5
#define cmt_CalibC6		0x20000000L	// Voltage on C6
#define cmt_CalibC7		0x40000000L	// Voltage on C7
#define cmt_CalibC8		0x80000000L	// Voltage on C8 
#define cmt_CalibMI		0x00003F00L	// Measure Current on all Range
#define cmt_CalibFI		0x003F0000L	// Force Current on all Range
#define cmt_CalibCx		0xFF000000L	// Voltage on all contact

#define cmt_CfgIRange		0x03		// Set/Get the IRange of IC1 measurement
#define cmt_IccIRangeDefault	cmt_IRange5

#define cmt_CfgPmuForceWait	0x04		// PMU Waiting time before a measurement
#define cmt_PmuForceWaitDefault	20000		// Default Value of PMU Force Wait

#define cmt_CfgPmuMeasNb	0x05		// PMU Number of measurement
#define cmt_PmuMeasNbDefault	0		// Default internal number of measurement

#define cmt_CfgPullUp		0x06		// Set/Get pull-up mask activation
#define cmt_PullUpC2		0x02		// C2 Pull-Up
#define cmt_PullUpC3		0x04		// C3 Pull-Up
#define cmt_PullUpC4		0x08		// C4 Pull-Up
#define cmt_PullUpC6		0x20		// C6 Pull-Up
#define cmt_PullUpC7		0x40		// C7 Pull-Up
#define cmt_PullUpC8		0x80		// C8 Pull-Up
#define cmt_PullUpDisable	0x00		// All Pull-Up Disabled
#define cmt_PullUpDefault	0x40		// Default Pull-Up Configuration

#define cmt_CfgPullUpValueC7	0x07		// Set/Get C7 pull-up resistor value;
#define cmt_PullUp22k		0x01		// 22k ohms Pull-up resistor 
#define cmt_PullUp10k		0x02		// 10k ohms Pull-up resistor 
#define cmt_PullUp6k9		0x03		// 6k9 ohms Pull-up resistor 
#define cmt_PullUp2k2		0x04		// 2k2 ohms Pull-up resistor 
#define cmt_PullUp2k		0x05		// 2k ohms Pull-up resistor 
#define cmt_PullUp1k8		0x06		// 1k8 ohms Pull-up resistor 
#define cmt_PullUp1k7		0x07		// 1k7 ohms Pull-up resistor 
#define cmt_PullUpDefaultValue	0x02		// Default Pull-Up resistor value

/*----------------------------------------------------------------------*
  cmt_CfgSet : Set a configuration parameter
 *----------------------------------------------------------------------*/
extern
err_Type cmt_CfgSet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Param,		// OBN IN : (In) Parameter
        ulong Value		// OBN IN : (In) Parameter's Value
        );

/*----------------------------------------------------------------------*
  cmt_CfgGet : Get a configuration parameter
 *----------------------------------------------------------------------*/
extern
err_Type cmt_CfgGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Param,		// OBN IN : (In) Parameter
        ulong *pValue		// OBN OUT,Length=1 : (Out) Parameter's Value
        );

/*----------------------------------------------------------------------*
  cmt_CxVoltageSet : Set contacts state
 *----------------------------------------------------------------------*/
#define cmt_CxMaskC1		0x00000001
#define cmt_CxMaskC2		0x00000002
#define cmt_CxMaskC3		0x00000004
#define cmt_CxMaskC4		0x00000008
#define cmt_CxMaskC5		0x00000010
#define cmt_CxMaskC6		0x00000020
#define cmt_CxMaskC7		0x00000040
#define cmt_CxMaskC8		0x00000080
#define cmt_CxMaskCAll		0x000000FF

#define cmt_StateHiz		1
#define cmt_StateLow		2
#define cmt_StateHigh		3
#define cmt_StateAPup		4

#define cmt_StateFMin		800
#define cmt_StateFMax		30000

extern
err_Type cmt_CxSet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode
        ulong CxMask,		// OBN IN : (In) Contacts Mask Selection
        ulong State		// OBN IN : (In) Contacts State
        );

/*----------------------------------------------------------------------*
  cmt_CxGet : Get contact state
 *----------------------------------------------------------------------*/
extern
err_Type cmt_CxGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong *pMode,		// OBN IN,OUT,Length=1: (In) Getting Mode, (Out) Current Setting Mode
        ulong CxMask,		// OBN IN : (In) Contact Selection
        ulong *pState		// OBN OUT,Length=1: (Out) Contact State
        );

/*----------------------------------------------------------------------*
  cmt_OSType : Open/Short Test Structure 
 *----------------------------------------------------------------------*/
typedef struct {
        ulong CxA;		// (In) First contact
        ulong CxB;		// (In) Second contact
        long  Current;		// (In) Forced Current in nA
        long  Vthl;		// (In) Low threshold voltage in mV below which the contact is Short
        long  Vthh;		// (In) High threshold voltage in mV above which the contact is open
        long  Voltage;		// (Out) Measured Voltage Value in mV
        ulong Status;		// (Out) Test status
} cmt_OSType, *cmt_OSRef;

#define cmt_OSTestOK	0
#define cmt_OSTestOpen	1
#define cmt_OSTestShort	2

/*----------------------------------------------------------------------*
  cmt_OpenShortTest : Perform Open Short test
 *----------------------------------------------------------------------*/
extern
err_Type cmt_OpenShortTest(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode
        ulong OSTypeSize,	// OBN IN : (In) Size of cmt_OSType in bytes
        cmt_OSType *OSList,	// OBN IN,OUT,Length=pListLg: (In/Out) List of Open/Short test
        ulong *pListLg		// OBN IN,OUT,Length=1: (In/Out) Number of elements in OSList
        );

/*----------------------------------------------------------------------*
  cmt_ICxGet : Get Static Current Consumption Measurement
 *----------------------------------------------------------------------*/
#define cmt_ModeIRangeForce	0x00010000

extern
err_Type cmt_ICxGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN: (In) Mode
        ulong Cx,		// OBN IN: (In) Contact selection
        long *pIcc		// OBN OUT,Length=1 : (Out) Current Measurement in uA
        );

/*----------------------------------------------------------------------*
  cmt_ICxAcqSet : Configure contact current measurement acquisition
 *----------------------------------------------------------------------*/
extern
err_Type cmt_ICxAcqSet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode
        ulong Cx,		// OBN IN : (In) Contact Selection
        ulong IRange,		// OBN IN : (In) Current Range
        ulong Event,		// OBN IN : (In) Event
        ulong EventOc,		// OBN IN : (In) Event Occurence
        ulong Delay,		// OBN IN : (In) Delay computed after "Event Occurence", in clk cycles
        ulong Count,		// OBN IN : (In) Sample count
        ulong Period		// OBN IN : (In) Sample Period
        );

/*----------------------------------------------------------------------*
  cmt_ICxAcqGet : Get Dynamic Current Consumption Measurement
 *----------------------------------------------------------------------*/
extern
err_Type cmt_ICxAcqGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode
        ulong *pCount,		// OBN IN,OUT,Length=1: (In) Maximum array length, (Out) returned length
        long *pValue		// OBN OUT,Length=pCount : (Out) Measurement array
        );

/*----------------------------------------------------------------------*
  cmt_ICxAcqStop : Disable the contact current measurement acquisition
 *----------------------------------------------------------------------*/
extern
err_Type cmt_ICxAcqStop(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode		// OBN IN : (In) Mode
        );

/*----------------------------------------------------------------------*
  cmt_VCxAcqSet : Configure contact voltage measurement acquisition
 *----------------------------------------------------------------------*/
#define cmt_VCxAcqModeFI	0x01000000

extern
err_Type cmt_VCxAcqSet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode
        ulong Cx,		// OBN IN : (In) Contact Selection
        ulong Event,		// OBN IN : (In) Event
        ulong EventOc,		// OBN IN : (In) Event Occurence
        ulong Delay,		// OBN IN : (In) Delay computed after "Event Occurence", in clk cycles
        ulong Count,		// OBN IN : (In) Sample count
        ulong Period		// OBN IN : (In) Sample Period
        );

/*----------------------------------------------------------------------*
  cmt_VCxAcqGet : Get dynamic voltage consumption measurement
 *----------------------------------------------------------------------*/
extern
err_Type cmt_VCxAcqGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode,		// OBN IN : (In) Mode
        ulong *pCount,		// OBN IN,OUT,Length=1: (In) Maximum array length, (Out) returned length
        long *pValue		// OBN OUT,Length=pCount : (Out) Measurement array
        );

/*----------------------------------------------------------------------*
  cmt_VCxAcqStop : Disable the contact voltage measurement acquisition
 *----------------------------------------------------------------------*/
extern
err_Type cmt_VCxAcqStop(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode		// OBN IN : (In) Mode
        );

/*----------------------------------------------------------------------*
  cmt_TemperatureGet : Get temperature value from both sensors
 *----------------------------------------------------------------------*/
extern
err_Type cmt_TemperatureGet(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong *pTC1,		// OBN OUT,Length=1 : (Out) : Sensor 1 Temperature value in 1/100 Deg.
        ulong *pTC2		// OBN OUT,Length=1 : (Out) : Sensor 2 Temperature value in 1/100 Deg.
        );

/*----------------------------------------------------------------------*
  cmt_CfgNSet : Set N Configuration Parameter Values
 *----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
  cmt_CfgNGet : Get N Configuration Parameter Values
 *----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
  cmt_InitDefault : Init configuration parameters to default value
 *----------------------------------------------------------------------*/
extern
err_Type cmt_InitDefault(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong Mode		// OBN IN : (In) Mode
        );

/*----------------------------------------------------------------------*
  cmt_SW : Smartware Private Method
 *----------------------------------------------------------------------*/
extern
err_Type cmt_SW(
        cmt_Type * Obj,		// (In) Handle to CMT Driver
        ulong LgIn,		// OBN IN : (In) Buffer length
        uchar *BufIn,		// OBN IN,Length=LgIn: (In) Buffer
        ulong *pLgInOut,	// OBN IN,OUT,Length=1: (In) Maximum response length, (Out) returned length
        uchar *BufOut		// OBN OUT,Length=pLgInOut: (Out) buffer
        );

/*----------------------------------------------------------------------*/
// OBN Class cmt END
/*----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*
  Renamed methods, defines and macro
 *----------------------------------------------------------------------*/
#define cmt_VhDefault			cmt_VohDefault
#define cmt_VlDefault			cmt_VolDefault

#define cmt_C7LvlMonitorGetVoh		cmt_C7LvlMonitorGetVih
#define cmt_C7LvlMonitorGetVol		cmt_C7LvlMonitorGetVil
#define cmt_C7LvlMonitorGetVohVol	cmt_C7LvlMonitorGetVihVil

#define cmt_IC1Set			cmt_IccSet
#define cmt_IC1Get			cmt_IccGet

#define cmt_IC1ModeConfig		cmt_IccModeConfig
#define cmt_IC1ModeEnable		cmt_IccModeEnable
#define cmt_IC1ModeDisable		cmt_IccModeDisable
#define cmt_IC1ModeUnitMicro		cmt_IccModeUnitMicro
#define cmt_IC1ModeUnitNano		cmt_IccModeUnitNano

#define cmt_IC1SetEvtNone		cmt_EventNone
#define cmt_IC1SetEvtTxStart		cmt_EventTxStart
#define cmt_IC1SetEvtTxEnd		cmt_EventTxEnd
#define cmt_IC1SetEvtRxStart		cmt_EventRxStart
#define cmt_IC1SetEvtReset		cmt_EventReset
#define cmt_IC1SetEvtExtInput		cmt_EventExtInput

#define cmt_CfgIC1IRange		cmt_CfgIRange
#define cmt_IC1IRangeDefault		cmt_IccIRangeDefault


#ifdef __cplusplus
}
#endif

#endif
