/************************************************************************
	CONTACT AND CONTACTLESS CARDS C-INTERFACE
 ************************************************************************
 Copyright (c) SMARTWARE, 1997 - 2014 All Rights Reserved.
 ************************************************************************
 04/06/2014 - DM v2r20k : From v2r20g
 07/12/2012 - DM v2r20g : Add card_PFrame_FSDNegoAuto define
 19/06/2012 - DM v2r20e : Add card_RSTModeC4On define
 19/07/2011 - DM v2r20a : Format ICC & PICC models. Add ApduWT in card_CfgXType;
		Add card_CxCfgSet, card_CxCfgGet, card_IOSet and card_IOGet
 15/02/2011 - SHM v2r16a : Add Mifare Plus Models
 19/07/2010 - DM v2r15b : Add error codes
 27/10/2009 - DM v2r14a : Add card_CtMeasTest method
 17/06/2009 - DM v2r13a : Add card_TransceiveX and card_AntennaDetect methods;
		Add parity error settings for card_ParitySet
 20/08/2007 - DM v2r12a : card_PipeX takes ulong arguments; Add defines for card contacts
                management methods; Add card_ParitySet and card_ParityGet
 12/01/2007 - DM v2r11a : Add card_ModelCUsb model; Add BitFrame field in card_PCfgType;
                Add card_CnGet
 29/11/2005 - DM v2r10c : Add card_AntennaSwitchSet
 21/10/2005 - DM v2r10a : Add Paypass Models; Add fields in card_PCfgType and card_CfgXType;
                Update timeout Process to 6s;
 20/06/2005 - DM v2r09a : Update Card Models; Add fieds in card_PCfgType; Add card_Select method;
                Add card contacts management methods, card_IC1Get, card_OSTest, card_AttribInfSet, 
                card_AttribInfGet, card_ModelSet, card_ModelGet and card_BaudRateSet methods;
 22/02/2005 - DM v2r08c : Add define card_RSTModeAtrGet
 21/10/2004 - DM v2r08a : Add card_IdGet, card_REQA, card_WUPA, card_Anticol, card_RATS,
                card_REQB, card_WUPB, card_Attrib, card_HaltB, card_Deselect, card_SysInfoGet;
                Remove obsolete defines; Add card__Open and card_Type errors;
 28/07/2004 - DM v2r07b : Add missing extern storage class;
 28/06/2004 - DM v2r07a: Add card_DetectSet, card_DetectGet;
                Add _PFrame_NAD and _PFrame_CID FrameFlag Masks;
                Change card_TuneSetCmd to card_TuneCmdSet; Add card_TuneCmdGet method; 
                Change names for Mifare Keys define; Add card__NA and card_TimeoutOp defines;
                Add CardFlag and pHwi fields and reduce Info size in card_Type;
                RSTWT unit in card_CfgXtype is now in microseconds; 
                Add card_RSTModeStayOn and card_FreqXSet methods; card_FreqXDef takes "ulong" parameter.
 26/04/2004 - RA v2r07a : Add card_TuneAuto, Add card_TuneGet, Defines pCfgstructsize 
 22/03/2004 - DM v2r06a: Add card_Transceive, card_CardCfgX;card_Apdu; card_HwiCfg;
                Add Model card_ModelIsoEh; Add card_FreqXGet, card_CardDetect
 11/02/2004 - DM v2r05r : Modify card_PipeX Comments
 04/02/2004 - RA v2r05q : Add card_AuthenticateMutualX , add defines
 20/10/2003 - RA v2r05l : Add card_PPSX define,PICC FRAME FLAGS.
 02/09/2003 - RA v2r05k : Add models TypeA prime, 15693, ICode ,Modify card_PCfgType struct
 07/07/2003 - ML v2r05i : Update card models
 27/06/2003 - RA v2r05g : Add card_TuneModeSet card_TuneModeGet and define for card_Tune Mode
 23/06/2003 - RA v2r05f : Add define Key Mode For Mifare,Rename card_Authenticate to card_AuthenticateMutual
 19/06/2003 - RA v2r05e : Add define card_ModeResetRfonOnly
 03/06/2003 - RA v2r05c : Add card_Tune, card_TuneSet, card_PowerGet, card_PowerSet,card_CardPCfg
 03/02/2003 - SD v2r02n : Add card_Key card_Authenticate generic functions
 02/05/2002 - ML v2r02j : Add card_ResetWarm
 15/02/2002 - ML v2r02i : Add card_LType, _NOType for WIN32 compatibility
 07/06/2001 - SD v2r02e : Add TSWT for RESET operation in card_CfgType
 13/03/2001 - SD v2r02c : Add BGT in compliance witg EMV
 28/12/2000 - SD v2r01  : Add card_ETUResetDef
 27/06/2000 - ML v1r17a : Suppress util.h
 15/06/2000 - SD v1r17a : Add card_VppIdleDef, card_Close
 21/04/2000 - Marc LEGOUX v1r16f: Add FIDI functions + housekeeping
 18/04/2000 - SD          v1r16f: Change card_LastErrorGet prototype
 30/07/1997 - Marc LEGOUX C2.3 : Add Etu, PTS
 27/05/1997 - Marc LEGOUX V1R1 : Rebuild
 25/04/1997 - SM          V1r0 : Creation
 ************************************************************************/
#ifndef card_h
#define card_h

#ifdef __cplusplus
extern "C" {
#endif

#include "../MLOS/sysobj.h"
#include "../MLOS/syst.h"
#include "sysc.h"


/*----------------------------------------------------------------------*
                CARD Error Codes
 *----------------------------------------------------------------------*/
#define card__Ok		0x00

#define card__err		16
#define card__no_card		card__err 	// No card
#define card__card_gone		card__err+1	// Card pulled out
#define card__card_off		card__err+2	// Card is not powered
#define card__timeout		card__err+3	// Card mute
#define card__reemit		card__err+4	// Too many parity errors
#define card__comm		card__err+5	// Communication error
#define card__lng		card__err+6	// header LNG != exchanged lng
#define card__sw12		card__err+7	// sw1-sw2 != 90H-00H
#define card__NA		card__err+8	// Card Operation Not Available
#define card__Type 		card__err+9	// Invalid interface or model selected
#define card__Open		card__err+10	// Interface not opened

#define card__DrvClassName	card__err+14	// Invalid driver class name
#define card__ObjIdFree		card__err+15	// Unavailable free objects Id

#define card__Coupler		sys__noobj	// Bad Coupler Number
#define card__NullPtr		sys__arg	// NullPtr
#define card__Ko		card__comm	// General Error


/*----------------------------------------------------------------------*
                Card Models
  ICC Models : [0x01 : 0x0F]
 *----------------------------------------------------------------------*/

// ICC models
#define card_ModelC7816_3	0x03	// ISO 7816-3 
#define card_ModelC7816_12	0x05	// ISO 7816-12 USB Cards

// PICC models
#define card_ModelPMifare	0x18	// NXP Mifare Classic (Modem External)
#define card_ModelPMifareP_RC	0x1A	// NXP Mifare Plus (Modem External)
#define card_ModelPMifareP	0x1B	// NXP Mifare Plus (Modem Smartware)
#define card_ModelP14443A_RC	0x28	// ISO 14443-A (Modem External)
#define card_ModelP14443A  	0x58	// ISO 14443-A (Modem Smartware)
#define card_ModelP14443B_RC	0x88	// ISO 14443-B (Modem External)
#define card_ModelP14443B  	0x38	// ISO 14443-B (Modem Smartware)
#define card_ModelPFeliCa_RC	0x4A	// Sony FeliCa (Modem External)
#define card_ModelPFeliCa	0x48	// Sony FeliCa (Modem Smartware)
#define card_ModelP15693	0x68	// ISO 15693 (Modem External)
#define card_ModelPIcode	0x78	// NXP I.Code1 (Modem External)
#define card_ModelPPayPassA_RC	0x29	// PAYPASS-A (Modem External)
#define card_ModelPPayPassA	0x59	// PAYPASS-A (Modem Smartware)
#define card_ModelPPayPassB_RC	0x89	// PAYPASS-B (Modem External)
#define card_ModelPPayPassB	0x39	// PAYPASS-B (Modem Smartware)

// Old defines
#define card_ModelCAsync	0x02
#define card_ModelCRaw		0x0F
#define card_ModelCIsoEh	card_ModelC7816_3
#define card_ModelCUsb		card_ModelC7816_12
#define card_ModelAsynchronus	card_ModelCAsync
#define card_ModelIsoEh		card_ModelCIsoEh
#define card_ModelRaw		card_ModelCRaw
#define card_ModelPTypeA     	card_ModelP14443A_RC
#define card_ModelPTypeAp   	card_ModelP14443A
#define card_ModelPTypeB     	card_ModelP14443B
#define card_ModelPTypeC     	card_ModelPFeliCa

// Model check macros for a reference of a CARD object (card_Ref)
#define card_ModelIccIs(obj)  ((!((obj)->Model & 0xF0)) ? (1) : (0))
#define card_ModelPiccIs(obj) (((obj)->Model & 0xF0) ? (1) : (0))


/*----------------------------------------------------------------------*
                Card Object
 *----------------------------------------------------------------------*/

#if config_WIN32
#define card_LType 	ushort
#define card_NOType	ushort
#else
#define card_LType 	sysobj_LType
#define card_NOType	sysobj_NOType
#endif


// ICC Checksum type (T=1)
#define card_T1CheckLRC    0
#define card_T1CheckCRC    1

// card Object buffers sizes
#define card_ATRMaxL	40	// Max length of ATR
#define card_BufMaxL	255	// Max length of card data
#define card_InfoMaxL	56	// Max length of info

// Default card methods timeout
#define card_TimeoutOp	6000	// 6 seconds

// Card object structure
typedef struct {
  ushort Size;		// sizeof card_Type
  card_NOType NObj;	// Node/Obj number

  uchar  Model;		// Card communication model
  uchar  ATR[card_ATRMaxL];	// Last Answer To Reset
  uchar  ATRLg;		// Length of ATR
  uchar  SW1;		// Last card procedure byte SW1
  uchar  SW2;		// Last card procedure byte SW2
  err_Type CplStatus;	// Last card method error
  syst_TType timeout;	// Current card methods timeout (ms)

  uchar  Pcb;		/* Obsolete */
  uchar  PcbChain;
  uchar  fPcbChain;
  uchar  Check;

  uchar  Buf[card_BufMaxL+16];	// Com buffer
  uchar  Info[card_InfoMaxL];   // Local data
  ulong  CardFlag;	// Card Object Flag
  void  *pHwi;		// Reference on Hardware Interface
} card_Type, * card_Ref;

#define card_NullRef	((card_Type *)0)

#define card_ModeNull	0


/************************************************************************
 ************************************************************************
	FUNCTIONS USED FOR ICC AND PICC
 ************************************************************************
 ************************************************************************/
 
/*----------------------------------------------------------------------*
  card_Open : Initialize a card object and link it to a reader's interface
 *----------------------------------------------------------------------*/
extern
err_Type card_Open(
        card_Ref Obj, 
        uchar Model, 		// (In) Model of Communication
        card_NOType NObj	// (In) Physical Interface
        );

/*----------------------------------------------------------------------*
  card_Close : Close card object
 *----------------------------------------------------------------------*/
extern
err_Type card_Close(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_Reset : Power On and Reset the card
 *----------------------------------------------------------------------*/
extern
err_Type card_Reset(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_Off : Power Off the PICC
 *----------------------------------------------------------------------*/
extern
err_Type card_Off(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_FreqXSet : Set new frequency
 *----------------------------------------------------------------------*/
#define card_FreqXSet card_FreqXDef

extern
err_Type card_FreqXDef(
        card_Ref Obj,
        ulong Freq	// (In) Frequency in kHz
        );

/*----------------------------------------------------------------------*
  card_FreqXGet : Get current frequency
 *----------------------------------------------------------------------*/
extern
err_Type card_FreqXGet(
        card_Ref Obj,
        ulong *Freq	// (Out) Current frequency in kHz
        );

/*----------------------------------------------------------------------*
  card_PipeX : Send a command and exchange data 
 *----------------------------------------------------------------------*/
extern
err_Type card_PipeX(
        card_Ref Obj,
        uchar *BufIn,	// (In) Data buffer to send
        ulong LngIn,	// (In) Data length to send
        uchar *pBufOut,	// (Out) Received data buffer
        ulong *pLngOut	// (In) Maximum output data buffer length, (Out) returned length
        );

/*----------------------------------------------------------------------*
  card_PPSX : Send an ISO Protocol and Parameter Selection command
 *----------------------------------------------------------------------*/
#define card_PPSX card_PTSX

extern
err_Type card_PTSX(
        card_Ref Obj,
        uchar * Buf,		// (In/Out) PPS command and answer
        card_LType LngIn,	// (In) Command length
        card_LType *pLngOut	// (In) Max. response length, (Out) returned length
        );

/*----------------------------------------------------------------------*
 card_LastErrorGet : Get a detailed error code when card__comm error occurs
 *----------------------------------------------------------------------*/
extern
err_Type card_LastErrorGet(
        card_Ref Obj,
        err_Type *pResult	// (Out) Error number
        );

/*----------------------------------------------------------------------*
  card_SysInfoGet : Return the versions of CARD package and Firmware Interface
       String is maximum 64 bytes
 *----------------------------------------------------------------------*/
extern
err_Type card_SysInfoGet(
        card_Ref Obj,
        char *StrInfo		// (Out) 64 bytes Information string
        );

/*----------------------------------------------------------------------*
  card_IOSet : Set additionnal IO output state
 *----------------------------------------------------------------------*/
#define card_IO0    0x01    // IO selection
#define card_IO1    0x02
#define card_IO2    0x04
#define card_IO3    0x08

#define card_IO_Low	1   // IO state to Vl
#define card_IO_High	2   // IO state to Vh
#define card_IO_HIZ	3   // IO set in HIZ

extern
err_Type card_IOSet(
        card_Ref Obj,
        ulong Mode,	// (In) Mode
        ulong IO,	// (In) IO selection
        ulong State	// (In) IO output state
        );

/*----------------------------------------------------------------------*
  card_IOGet : Get additionnal IO output state
 *----------------------------------------------------------------------*/
extern
err_Type card_IOGet(
        card_Ref Obj,
        ulong Mode,	// (In) Mode
        ulong IO,	// (In) IO selection
        ulong *State	// (Out) IO input state
        );


/************************************************************************
 ************************************************************************
	FUNCTIONS USED FOR ICC ONLY
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_ResetWarm : warm reset the ICC
 *----------------------------------------------------------------------*/
extern
err_Type card_ResetWarm(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_VccDef : Set current Vcc voltage. Default is 5000mV
 *----------------------------------------------------------------------*/
extern
err_Type card_VccDef(
        card_Ref Obj,
        ushort Vcc		// (In) Vcc in mV
        );

/*----------------------------------------------------------------------*
  card_InX: ISO IN command
 *----------------------------------------------------------------------*/
extern
err_Type card_InX(
        card_Ref Obj,
        uchar * Buf	// (In) Header and Data Buffer
        );

/*----------------------------------------------------------------------*
  card_InXH : ISO IN command with detailed header
 *----------------------------------------------------------------------*/
extern
err_Type card_InXH(
        card_Ref Obj,
        uchar Cla,	// (In) Class
        uchar Ins,	// (In) Instruction
        uchar P1,	// (In) P1 parameter
        uchar P2,	// (In) P2 parameter
        uchar P3,	// (In) P3 parameter
        uchar * Buf	// (In) Data buffer
        );

/*----------------------------------------------------------------------*
  card_OutX : ISO OUT command
 *----------------------------------------------------------------------*/
extern
err_Type card_OutX(
        card_Ref Obj,
        uchar * Hd,		// (In) Command Header
        uchar * pBuf,		// (Out) output data buffer
        card_LType * pLng	// (Out) output data length
        );

/*----------------------------------------------------------------------*
  card_OutXH : ISO OUT command with detailed header
 *----------------------------------------------------------------------*/
extern
err_Type card_OutXH(
        card_Ref Obj,
        uchar Cla,		// (In) Class
        uchar Ins,		// (In) Instruction
        uchar P1,		// (In) P1 parameter
        uchar P2,		// (In) P2 parameter
        uchar P3,		// (In) P3 parameter
        uchar * pBuf,		// (Out) output data buffer
        card_LType * pLng	// (Out) output data length
        );

/*----------------------------------------------------------------------*
  card_Apdu : ISO IN and/or OUT APDU command (case 1 to 4)
 *----------------------------------------------------------------------*/
extern
err_Type card_Apdu(
        card_Ref Obj,
        uchar * BufIn,		// (In) Header (and Data) to send
        card_LType LngIn,	// (In) Data Length to send
        uchar * pBufOut,	// (Out) Received Data
        card_LType * pLngOut	// (Out) Received length of data
        );

/*----------------------------------------------------------------------*
  card_Transceive : Transparent In/Out Command
 *----------------------------------------------------------------------*/
extern
err_Type card_Transceive(
        card_Ref Obj,
        uchar * BufIn,		// (In) Data Buffer to send
        card_LType LngIn,	// (In) Data Length to send
        uchar * pBufOut,	// (Out) Received Data Buffer
        card_LType * pLngOut	// (In) Max. response length, (Out) returned length
        );

/*----------------------------------------------------------------------*
  card_TransceiveX : Extended Transparent In/Out Command
 *----------------------------------------------------------------------*/
#define card_T0			0x00
#define card_T1			0x01
#define card_T1_RxLgDisable	0x10

extern
err_Type card_TransceiveX(
        card_Ref Obj,
        ulong Mode,		// (In) Mode
        uchar * BufIn,		// (In) Data buffer to send
        ulong LngIn,		// (In) Data length to send
        uchar * pBufOut,	// (Out) Received data buffer
        ulong * pLngOut		// (In) Expected or Max. response length, (Out) returned length
        );

/*----------------------------------------------------------------------*
  card_EtuX : Set new ETU value, which defines the bit duration in communication
 *----------------------------------------------------------------------*/
extern
err_Type card_EtuX(
        card_Ref Obj, 
        ushort Etu	// (In) New ETU value
        );

/*----------------------------------------------------------------------*
  card_ETUResetDef : Set the ETU and WI values used only for the Reset sequence.
     ETU defines the bit duration for the ATR reception. WI defines the Work Waiting Time
     which is the maximum duration between the reception of 2 consecutive characters.
 *----------------------------------------------------------------------*/
extern
err_Type card_ETUResetDef(
        card_Ref Obj,
        ushort ETU,	// (In) New ETU value
        uchar WI	// (In) New WI value
        );

/*----------------------------------------------------------------------*
  card_FIDIDef : Set new FI/DI couple, which defines a new ETU value in communication 
    (FI and DI values are defined in ISO7816-3 standard).
 *----------------------------------------------------------------------*/
extern
err_Type card_FIDIDef(
        card_Ref Obj,
        uchar FI,	// (In) New FI value
        uchar DI	// (In) New DI value
        );

/*----------------------------------------------------------------------*
  card_FIDIResetDef : Set the FI/DI couple, which defines an ETU value, only for the
    Reset sequence.
 *----------------------------------------------------------------------*/
extern
err_Type card_FIDIResetDef(
        card_Ref Obj,
        uchar FI,	// (In) New FI value
        uchar DI	// (In) New DI value
        );

/*----------------------------------------------------------------------*
 card_CfgXType : Card Extended Configuration Structure
 *----------------------------------------------------------------------*/
#define card_CfgxFD		0x00000001
#define card_CfgxFI		0x00000002
#define card_CfgxDI		0x00000004
#define card_CfgxN 		0x00000008
#define card_CfgxCD		0x00000010
#define card_CfgxCDU		0x00000020
#define card_CfgxWI		0x00000040
#define card_CfgxWWT		0x00000080
#define card_CfgxODMT		0x00000100
#define card_CfgxODTU		0x00000200
#define card_CfgxCWI		0x00000400
#define card_CfgxCWT		0x00000800
#define card_CfgxBWI		0x00001000
#define card_CfgxBWT		0x00002000
#define card_CfgxBGT		0x00004000
#define card_CfgxNAD		0x00008000
#define card_CfgxIFSD		0x00010000
#define card_CfgxIFSC		0x00020000
#define card_CfgxTSWT		0x00040000
#define card_CfgxTSWWT		0x00080000
#define card_CfgxRSTWT		0x00100000
#define card_CfgxRSTMode	0x00200000
#define card_CfgxT1ErrReemit	0x00400000
#define card_CfgxPPSGT		0x00800000
#define card_CfgxApduWT		0x01000000
#define card_CfgxAll		0x01FFFFFF

#define cCfgStructSize1  96
#define cCfgStructSize2  100
#define cCfgStructSize3  104
#define cCfgStructSize4  108


// RSTMode Flag
#define card_RSTModeStayOn  0x01
#define card_RSTModeAtrGet  0x02
#define card_RSTModeC4On    0x04

typedef struct {
  ulong StructSize;	// Structure Size
  ulong Mask; 	// Selection Mask. If null, get the current configuration
  ulong FD;	// Ratio F/D to fix the ETU value
  ulong FI;	// Clock rate conversion Factor
  ulong DI;	// Baudrate adjustment factor
  ulong N;	// Extraguard time between 2 characters transmitted, in Etu counts
  ulong CD;	// Character Duration in Transmission (length between 2 consecutive Start-Bits)
  ulong CDU;	// Character Duration Unit (ETU pulses or Clock Cycles)
  ulong WI;	// Wait Integer: parameter used to compute WWT
  ulong WWT;	// Work Waiting Time
  ulong ODMT;	// Opposite Direction Minimum Time (between the last Start-bit in Rx and the 1st one in Tx)
  ulong ODTU;	// Opposite Direction Time Unit (ETU pulses or Clock Cycles)
  ulong CWI;	// Character Waiting time Integer
  ulong CWT;	// Character Waiting Time
  ulong BWI;	// Block Waiting time Integer
  ulong BWT;	// Block Waiting Time
  ulong BGT;	// Block GuardTime
  ulong NAD;	// Node Address Byte
  ulong IFSD;	// IFS for the Reader
  ulong IFSC;	// IFS for the Card (Read Only)
  ulong TSWT;	// Guardtime Time in Clock Cycles before waiting ATR TS byte
  ulong TSWWT;	// TS Work Waiting Time in Clock Cycles
  ulong RSTWT;	// Waiting Time after Reset in microseconds
  ulong RSTMode; // Reset Mode
  ulong T1ErrReemit; // Number of Reemission when Errors in T=1
  ulong PPSGT;	// PPS Guard Time
  ulong ApduWT; // APDU Waiting Time in ms

} card_CfgXType, *card_CfgXRef;

/*----------------------------------------------------------------------*
  card_CardCfgX : Set or Get protocol configuration structure

  Remarks:
   - pCfg->Structsize must be initialised
   - if pCfg->Mask = 0, the reader returns the current config parameters
 *----------------------------------------------------------------------*/
extern
err_Type card_CardCfgX(
        card_Ref Obj, 
        card_CfgXRef pCfg   // (In/Out) Extended configuration structure
        );

/*----------------------------------------------------------------------*
  card_ParitySet : Set parity bit working mode
 *----------------------------------------------------------------------*/
#define card_ParityBitOdd       0x0000  // Parity Bit settings
#define card_ParityBitEven	0x0001
#define card_ParityBitHigh	0x0003
#define card_ParityBitLow	0x0004
#define card_ParityErrEnable	0x0000
#define card_ParityErrDisable	0x0100

extern
err_Type card_ParitySet(
        card_Ref Obj, 
        ulong Pbit,	// (In) Parity Bit setting
        ulong Mode	// (In) Mode
        );

/*----------------------------------------------------------------------*
  card_ParityGet : Get current parity bit working mode
 *----------------------------------------------------------------------*/
extern
err_Type card_ParityGet(
        card_Ref Obj, 
        ulong *Pbit,	// (Out) Parity Bit current setting
        ulong Mode	// (In) Mode
        );

/*----------------------------------------------------------------------*
  card_CardDetect : Enable/disable card detection in the coupling device, 
    or get the current configuration.
 *----------------------------------------------------------------------*/
#define card_CdDetectGet	0
#define card_CdDetectSet	1

extern
err_Type card_CardDetect(
        card_Ref Obj,
        ulong *Value,	// (In/Out) Value
        ulong Mode	// (In) Mode or Code
        );

/*----------------------------------------------------------------------*
  card_DetectSet : Enable/disable card detection
 *----------------------------------------------------------------------*/
extern
err_Type card_DetectSet(
        card_Ref Obj,
        ulong Value	// (In) Value
        );

/*----------------------------------------------------------------------*
  card_DetectGet : Get card detection
 *----------------------------------------------------------------------*/
extern
err_Type card_DetectGet(
        card_Ref Obj, 
        ulong *Value	// (Out) Value
        );

/*----------------------------------------------------------------------*
  card_C1 : Switch On/Off C1 contact
 *----------------------------------------------------------------------*/
#define card_C1Off	0
#define card_C1On	1

extern
err_Type card_C1(
        card_Ref Obj,
        ulong Mode		// (In) C1 state
        );

/*----------------------------------------------------------------------*
  card_C2 : Switch On/Off C2 contact
 *----------------------------------------------------------------------*/
#define card_C2Off	0
#define card_C2On	1

extern
err_Type card_C2(
        card_Ref Obj,
        ulong Mode		// (In) C2 state
        );

/*----------------------------------------------------------------------*
  card_C3 : Switch On/Off C3 contact and with a Frequency value
 *----------------------------------------------------------------------*/
#define card_C3Off	0
#define card_C3High	1

extern
err_Type card_C3(
        card_Ref Obj,
        ulong Freq		// (In) Frequency in kHz (800 to 15000)
        );

/*----------------------------------------------------------------------*
  card_C3Pulse : Generate Pulses on C3 contact
 *----------------------------------------------------------------------*/
err_Type card_C3Pulse(
        card_Ref Obj,
        ulong Duration,	// (In) Pulse duration in us
        ulong Nb		// (In) Number of clock cycles
        );

/*----------------------------------------------------------------------*
  card_C4 : Switch On/Off C4 contact
 *----------------------------------------------------------------------*/
#define card_C4Off	0
#define card_C4On	1

extern
err_Type card_C4(
        card_Ref Obj,
        ulong Mode		// (In) C4 state
        );

/*----------------------------------------------------------------------*
  card_C6 : Switch On/Off C6 contact and apply Idle or Programming Voltage
 *----------------------------------------------------------------------*/
#define card_C6Off	0
#define card_C6IdleOn	1
#define card_C6ProgOn	2

extern
err_Type card_C6(
        card_Ref Obj,
        ulong Mode		// (In) C6 state
        );

/*----------------------------------------------------------------------*
  card_C7 : Switch On/Off C7 contact
 *----------------------------------------------------------------------*/
#define card_C7Off	0
#define card_C7On	1

extern
err_Type card_C7(
        card_Ref Obj,
        ulong Mode		// (In) C7 state
        );

/*----------------------------------------------------------------------*
  card_C7Get : Read C7 contact
 *----------------------------------------------------------------------*/
#define card_C7Low	0
#define card_C7High	1

extern
err_Type card_C7Get(
        card_Ref Obj,
        ulong *Value		// (Out) C7 current state
        );

/*----------------------------------------------------------------------*
  card_C8 : Switch On/Off C8 contact
 *----------------------------------------------------------------------*/
#define card_C8Off	0
#define card_C8On	1

extern
err_Type card_C8(
        card_Ref Obj,
        ulong Mode		// (In) C8 state
        );

/*----------------------------------------------------------------------*
  card_CnGet : Get All contacts state
 *----------------------------------------------------------------------*/

// Contact Cx set to 1 Mask
#define card_C1To1        0x01
#define card_C2To1        0x02
#define card_C3To1        0x04
#define card_C4To1        0x08
#define card_C6To1        0x10
#define card_C7To1        0x20
#define card_C8To1        0x40

extern
err_Type card_CnGet(
        card_Ref Obj,
        ulong *Cx	// (Out) Cx current state
        );

/*----------------------------------------------------------------------*
  card_CnOff : Switch all contacts to low or high impedance
 *----------------------------------------------------------------------*/
#define card_CnLow	0
#define card_CnHiz	1

extern
err_Type card_CnOff(
        card_Ref Obj,
        ulong Mode	// (In) Cx state
        );

/*----------------------------------------------------------------------*
  card_CxCfgSet : Set a contact working configuration 
 *----------------------------------------------------------------------*/
#define card_CxCfgPullUpC7	1      // C7 Pull-up configuration
  #define card_CxPullUpDef	0      // Pull-up to default
  #define card_CxPullUp4k7	4700   // Pull-up to 4,7 kOhm
  #define card_CxPullUp10k	10000  // Pull-up to 10 kOhm

extern
err_Type card_CxCfgSet(
        card_Ref Obj,
        ulong Param,	// (In) Configuration parameter
        ulong Value	// (In) Parameter's value
        );

/*----------------------------------------------------------------------*
  card_CxCfgGet : Get a current contact working configuration 
 *----------------------------------------------------------------------*/
extern
err_Type card_CxCfgGet(
        card_Ref Obj,
        ulong Param,	// (In) Configuration parameter
        ulong *Value	// (Out) Parameter's value
        );

/*----------------------------------------------------------------------*
  card_IC1Get : Get average consumption current of an ICC
 *----------------------------------------------------------------------*/
#define card_IC1ScaleAuto	0
#define card_IC1ScaleHigh	1  // Range 5mA to 100mA with 100uA step
#define card_IC1ScaleLow	2  // Range 20uA to 5mA with 5uA step

extern
err_Type card_IC1Get(
        card_Ref Obj,
        ulong Mode,		// (In) Measurement mode
        ulong *pIcc		// (Out) Measurement in uA
        );

/*----------------------------------------------------------------------*
  card_OSTest : Perform Open/Short Tests on card contacts
 *----------------------------------------------------------------------*/

// Mask on Contacts to test
#define card_OSC1         0x01
#define card_OSC2         0x02
#define card_OSC3         0x04
#define card_OSC4         0x08
#define card_OSC6         0x20
#define card_OSC7         0x40
#define card_OSC8         0x80
#define card_OSCx         0xEF

// Fork Voltage to default configuration
#define card_OSVlDef      0
#define card_OSVhDef      0

extern
err_Type card_OSTest(
        card_Ref Obj,
        ulong Cmask,		// (In) Contacts selection
        ulong Vl,		// (In) Low threshold voltage
        ulong Vh,		// (In) High threshold voltage
        ulong *pOpen,		// (Out) Contacts in Open state
        ulong *pShort		// (Out) Contacts in Short state
        );

/*----------------------------------------------------------------------*
 card_CtCxType : Continuity test contact structure
 *----------------------------------------------------------------------*/

// Contact Identifier
#define card_CtC1	1
#define card_CtC2	2
#define card_CtC3	3
#define card_CtC4	4
#define card_CtC6	6
#define card_CtC7	7
#define card_CtC8	8

// Contact Status
#define card_CtCxOk		0x00000000   // Contact measurement OK
#define card_CtCxNC		0x00000001   // Contact not connected
#define card_CtCxImpOvr		0x00000002   // Impedance overrange
#define card_CtCxImpErr		0x00000004   // Impedance measurement error
#define card_CtCxImpVmeas	0x00000008   // Impedance to high to measure the clamp diode


typedef struct {
  ulong Cx;		// Contact Identifier
  ulong R;		// Impedance value in Ohm
  ulong Vth;		// ICC clamp diode threshold voltage in mV
  ulong Status;		// Contact status
} card_CtCxType, *card_CtCxRef;

/*----------------------------------------------------------------------*
  card_CtMeasTest : Perform Continuity Test on card contacts
 *----------------------------------------------------------------------*/
extern
err_Type card_CtMeasTest(
        card_Ref Obj,
        ulong Mode,		// (In) Mode
        ulong CtCxTypeSize,	// (In) Size of card_CtCxType in bytes
        card_CtCxType CxList[],	// (In/Out) List of tested contacts
        ulong *pListLg		// (In/Out) Number of elements in CxList
        );


/************************************************************************
 ************************************************************************
	FUNCTIONS USED FOR PICC ONLY
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_ModelSet : Set new model of communication
 *----------------------------------------------------------------------*/
extern
err_Type card_ModelSet(
        card_Ref Obj,
        ulong Model	// (In) New Model
        );

/*----------------------------------------------------------------------*
  card_ModelGet : Get current model of communication
 *----------------------------------------------------------------------*/
extern
err_Type card_ModelGet(
        card_Ref Obj,
        ulong *Model	// (Out) Curent Model
        );

/*----------------------------------------------------------------------*
  card_On : Switch Rf On
 *----------------------------------------------------------------------*/
extern
err_Type card_On(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_REQA : Send Request A command
              Cards model Mifare and ISO 14443 TypeA only
 *----------------------------------------------------------------------*/
extern
err_Type card_REQA(
        card_Ref Obj,
        ulong *ATQA	// (Out) ATQA answer
        );

/*----------------------------------------------------------------------*
  card_WUPA : Send Wake Up A command
              Cards model Mifare and ISO 14443 TypeA only
 *----------------------------------------------------------------------*/
extern
err_Type card_WUPA(
        card_Ref Obj,
        ulong *ATQA	// (Out) ATQA answer
        );

/*----------------------------------------------------------------------*
  card_Anticol : Perform full anticollision process
                 Cards model Mifare and ISO 14443 TypeA only
 *----------------------------------------------------------------------*/
extern
err_Type card_Anticol(
        card_Ref Obj,
        uchar *UID,	// (Out) UID data buffer
        ulong *UIDLg,	// (Out) UID length
        uchar *SAK,	// (Out) SAK answer
        uchar *Status	// (Out) Status byte of Anticol process
        );

/*----------------------------------------------------------------------*
  card_Select : Select PICC according to UID
                Cards model Mifare and ISO 14443 TypeA only
 *----------------------------------------------------------------------*/
extern
err_Type card_Select(
        card_Ref Obj,
        uchar *UID,	// (In) UID data buffer
        ulong UIDLg,	// (In) UID length
        uchar *SAK	// (Out) SAK answer
        );

/*----------------------------------------------------------------------*
  card_HaltA : Send Halt A Command
               Cards model Mifare and ISO 14443 TypeA only
 *----------------------------------------------------------------------*/
extern
err_Type card_HaltA(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_RATS : Send Request ATS - Cards model ISO 14443 TypeA only
 *----------------------------------------------------------------------*/
extern
err_Type card_RATS(
        card_Ref Obj,
        uchar *ATS,	// (Out) ATS Buffer answer
        ulong *ATSLg	// (Out) ATS Length
        );

/*----------------------------------------------------------------------*
  card_REQB : Send Request B command - Cards model ISO 14443 TypeB only
 *----------------------------------------------------------------------*/
extern
err_Type card_REQB(
        card_Ref Obj,
        uchar *ATQB,	// (Out) ATQB Buffer answer
        ulong *ATQBLg	// (Out) ATQB Length
        );

/*----------------------------------------------------------------------*
  card_WUPB : Send Wake Up B command - Cards model ISO 14443 TypeB only
 *----------------------------------------------------------------------*/
extern
err_Type card_WUPB(
        card_Ref Obj,
        uchar *ATQB,	// (Out) ATQB Buffer answer
        ulong *ATQBLg	// (Out) ATQB Length
        );

/*----------------------------------------------------------------------*
  card_Attrib : Send ATTRIB command - Cards model ISO 14443 TypeB only
 *----------------------------------------------------------------------*/
extern
err_Type card_Attrib(
        card_Ref Obj,
        uchar *pBufOut,	// (Out) Received Data Buffer
        ulong *LgOut	// (Out) Answer length
        );

/*----------------------------------------------------------------------*
  card_AttribInfSet : Set INF field added in ATTRIB frame - 
                      Cards model ISO 14443 TypeB only
 *----------------------------------------------------------------------*/
extern
err_Type card_AttribInfSet(
        card_Ref Obj,
        uchar *pBufIn,	// (In) Higher Layer INF buffer
        ulong LgIn	// (In) Higher Layer INF length
        );

/*----------------------------------------------------------------------*
  card_AttribInfGet : Get INF field added in ATTRIB frame - 
                      Cards model ISO 14443 TypeB only
 *----------------------------------------------------------------------*/
extern
err_Type card_AttribInfGet(
        card_Ref Obj,
        uchar *pBufOut,	// (Out) Higher Layer INF buffer
        ulong *LgOut	// (Out) Higher Layer INF buffer length - Max lg = 245
        );

/*----------------------------------------------------------------------*
  card_HaltB : Send Halt B Command - Cards model ISO 14443 TypeB only
 *----------------------------------------------------------------------*/
extern
err_Type card_HaltB(
        card_Ref Obj,
        uchar * pBufOut,	// (Out)Received Data Buffer
        ulong *LgOut		// (Out)Answer length
        );

/*----------------------------------------------------------------------*
  card_BaudRateSet : Set reaser and PICC communication baudrate - ISO14443 only
 *----------------------------------------------------------------------*/
#define card_Bdr106     106
#define card_Bdr212     212
#define card_Bdr424     424
#define card_Bdr847     847

extern
err_Type card_BaudRateSet(
        card_Ref Obj,
        ulong BdrTx,	// (In) Reader Baudrate in transmission
        ulong BdrRx	// (In) Reader Baudrate in reception
        );

/*----------------------------------------------------------------------*
  card_Deselect : Send S(DESELECT) Command
                  Cards model ISO14443 Type A & B level 4 only
 *----------------------------------------------------------------------*/
extern
err_Type card_Deselect(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_IdGet : Get the Card UID or Serial Number
 *----------------------------------------------------------------------*/
extern
err_Type card_IdGet(
        card_Ref Obj,
        uchar *pIdBuf,	// (Out) ID Value Buffer
        ulong *IdLg	// (Out) ID Length
        );

/*----------------------------------------------------------------------*
  card_AuthenticateMutual : MIFARE Mutual Authentification
 *----------------------------------------------------------------------*/
/* Key Modes for Mifare */
#define card_ModeKeyA     cdmifare_ModeKeyA
#define card_ModeKeyB     cdmifare_ModeKeyB
#define cdmifare_ModeKeyA    0x00
#define cdmifare_ModeKeyB    0x01

extern
err_Type card_AuthenticateMutual(
        card_Ref Obj,
        uchar *Data,		// (In) Data for authentication
        ulong DataL,		// (In) Data length
        ulong Mode		// (In) Key Mode
        );

/*----------------------------------------------------------------------*
  card_AuthenticateMutualX : Extended Mutual Authentification
 *----------------------------------------------------------------------*/
/* Key Modes for Mifare Plus */
#define card_ModeFirst		0x00
#define card_ModeFollow		0x01

extern
err_Type card_AuthenticateMutualX(
        card_Ref Obj,
        uchar *Data,		// (In) Data for authentication
        ulong DataL,		// (In) Data length
        ulong Mode,		// (In) Mode (RFU)
        uchar *Info,		// (Out) Information returned : IDtc
        ulong *InfoL		// (Out) Information length
        );

/*----------------------------------------------------------------------*
  card_Key : Generic key management function
 *----------------------------------------------------------------------*/
extern
err_Type card_Key(
        card_Ref Obj,
        uchar *Key,	// (In) Key
        ulong KeyL	// (In) Key length
        );

/*----------------------------------------------------------------------*
  card_TuneAuto : Auto Tune the reader according to the card present in the field
 *----------------------------------------------------------------------*/
#define card_TuneAuto   card_Tune

extern
err_Type card_Tune(
        card_Ref Obj,
        ulong *pTune	// (Out) Tune value
        );

/*----------------------------------------------------------------------*
  card_TuneModeSet : Set tuning communication mode
 *----------------------------------------------------------------------*/
#define card_PTuneNoVerify   	0x00  // Command answer not checked
#define card_PTuneVerify       	0x01  // Check command answer
#define card_PTuneCRCCheck	0x02  // Check CRC of command answer
#define card_PTuneAddCRC    	0x04  // Reader adds CRC in the command
#define card_PTuneShortFrame	0x08  // Command use Short Frame format (TypeA and MIFARE only)

extern
err_Type card_TuneModeSet(
        card_Ref Obj,
        ulong Mode	// (In) Tune Mode
        );

/*----------------------------------------------------------------------*
  card_TuneModeGet : Get tuning communication mode
 *----------------------------------------------------------------------*/
extern
err_Type card_TuneModeGet(
        card_Ref Obj,
        ulong * pMode	// (Out) Current Tune mode
        );

/*----------------------------------------------------------------------*
  card_TuneSet : Set tuning value
 *----------------------------------------------------------------------*/
extern
err_Type card_TuneSet(
        card_Ref Obj,
        ulong Tune	// (In) New Tune value
        );

/*----------------------------------------------------------------------*
  card_TuneGet : Get tuning value
 *----------------------------------------------------------------------*/
extern
err_Type card_TuneGet(
        card_Ref Obj,
        ulong *pTune	// (Out) Current Tune value 
        );

/*----------------------------------------------------------------------*
  card_TuneCmdSet : Set the command sent during the tuning process
 *----------------------------------------------------------------------*/
extern
err_Type card_TuneCmdSet(
        card_Ref Obj,
        uchar *Cmd,	// (In) Command
        ulong CmdL	// (In) Command length
        );

#define card_TuneSetCmd card_TuneCmdSet

/*----------------------------------------------------------------------*
  card_TuneCmdGet : Get the command sent during the tuning process
 *----------------------------------------------------------------------*/
extern
err_Type card_TuneCmdGet(
        card_Ref Obj,
        uchar *Cmd,	// (Out) Command
        ulong *CmdL	// (Out) Command length
        );

/*----------------------------------------------------------------------*
  card_PowerSet : Set power value (0 to 16)
 *----------------------------------------------------------------------*/
extern
err_Type card_PowerSet(
        card_Ref Obj,
        ulong Power	// (In) Power value
        );

/*----------------------------------------------------------------------*
  card_PowerGet : Get power value
 *----------------------------------------------------------------------*/
extern
err_Type card_PowerGet(
        card_Ref Obj,
        ulong *pPower	// (Out) Power value
        );

/*----------------------------------------------------------------------*
  card_PCfgType : Proximity Card Configuration Structure
 *----------------------------------------------------------------------*/
#define card_PCfgFSDI		0x00000001
#define card_PCfgFWI		0x00000002
#define card_PCfgFWT		0x00000004
#define card_PCfgDRI		0x00000008
#define card_PCfgDSI		0x00000010
#define card_PCfgDS		0x00000020
#define card_PCfgDR		0x00000040
#define card_PCfgSOF		0x00000080
#define card_PCfgEOF		0x00000100
#define card_PCfgEGT		0x00000200
#define card_PCfgFRAME_FLAG	0x00000400
#define card_PCfgSYSTEM_CODE	0x00000800
#define card_PCfgNAD		0x00001000
#define card_PCfgCID		0x00002000
#define card_PCfgFSCI		0x00004000
#define card_PCfgRFONWAIT 	0x00008000
#define card_PCfgRFOFFWAIT	0x00010000
#define card_PCfgAFDT		0x00020000
#define card_PCfgERRREEMIT	0x00040000
#define card_PCfgSFGI		0x00080000
#define card_PCfgSFGT		0x00100000
#define card_PCfgAFI		0x00200000
#define card_PCfgSLOTNB		0x00400000
#define card_PCfgTR0TR1		0x00800000
#define card_PCfgAFWT		0x01000000
#define card_PCfgASFGT		0x02000000
#define card_PCfgBITFRAME 	0x04000000
#define card_PCfgAll		0x07FFFFFF

// FRAME_FLAG defines
#define card_PFrame_CRCreturned	0x00000001  // CRC is automatically added in the Reponse Frame from PICC to PCD 
#define card_PFrame_CRCauto	0x00000002  // the CRC is automatically computed , 0: the CRC is supplied by the user
#define card_PFrame_CRCcheck	0x00000004  // The PICC CRC is checked by the PCD, 0: Not Checked
#define card_PFrame_paritybit	0x00000008  // Frame A only: parity bit is included after each byte of Tx and Rx Frames.
#define card_PFrame_standardframe 0x00000010  // Type A only: Standard  Frame, 0: Short Frame
#define card_PFrame_fastmode	0x00000020  // ICode & 15693 only: fast mode else standard Mode
#define card_PFrame_SOFRecv	0x00000040  // Type B only: SOF is included in PICC frames; 0 = PICC Frames dont have SOF
#define card_PFrame_EOFRecv	0x00000080  // Type B only: EOF is included in PICC frames; 0 = PICC Frames dont have EOF
#define card_PFrame_SendOnly	0x00000100  // Send data to the card only (does not wait for any response)
#define card_PFrame_RecvOnly	0x00000200  // Receive Data from the card without Sending.
#define card_PFrame_Level4 	0x00000400  // Types A & B only : Set to Level 4 protocol (ie ISO 14443 - 4)
#define card_PFrame_Crypt   	0x00000800  // Mifare and FeliCa cards only: enable ciphered exchanges, else disable
#define card_PFrame_RxCodingBPSK 0x00001000  // Type A Read only : use BPSK coding in Rx, else Manchester coding
#define card_PFrame_NAD     	0x00002000  // Types A & B Only : Level 4 Frames include NAD byte in Prologue Field
#define card_PFrame_CID      	0x00004000  // Types A & B Only : Level 4 Frames include CID byte in Prologue Field
#define card_PFrame_CollisionDisable 0x00008000  // Mifare & Type A Only : Collision Error on Reception Disabled
#define card_PFrame_FSDNegoAuto 0x00010000  // ISO14443B only : FSD auto negociation above 256 bytes

#define   pConfigStructSize1  56
#define   pConfigStructSize2  76
#define   pConfigStructSize3  104
#define   pConfigStructSize4  112
#define   pConfigStructSize5  116

typedef struct {
  ulong StructSize;   // Structure size
  ulong Mask;	      // Field Selection Mask. If 0 get the current configuration
  ulong Fsdi;	      // Reader Frame Size Integer
  ulong Fwi;	      // Frame Waiting Time Integer
  ulong Fwt;	      // Frame Waiting Time, in us
  ulong Dri;	      // Divisor Received Integer (reader transmission bit rate)
  ulong Dsi;	      // Divisor Send Integer (reader reception bit rate)
  ulong Ds;	      // PICC transmission bit rate capability - Read only
  ulong Dr;	      // PICC reception bit rate capability - Read only
  ulong Sof;	      // Start Of Frame
  ulong Eof;	      // End Of Frame
  ulong Egt;	      // Extra Guard Time in transmission
  ulong Frame_Flag;   // Specific Reader's Communication Configuration Settings
  ulong System_Code;  // FeliCa Cards Only - Parameter of the Polling Command
  ulong Nad;	      // Node Address
  ulong Cid;	      // Card Identifier
  ulong Fsci;	      // Card Frame Size Integer - Read Only
  ulong RfOnWait;     // Waiting Time after RF is switched on, in us
  ulong RfOffWait;    // Waiting Time after RF is switched off, in us
  ulong Afdt;	      // Additional Frame Delay Time, in us
  ulong ErrReemit;    // Maximum reemission value on Level 4 APDU errors
  ulong Sfgi;	      // Start-up Frame Guard time Integer - Read only
  ulong Sfgt;	      // Start-up Frame Guard Time - Read only
  ulong Afi;	      // Application Family Identifier targeted by PCD
  ulong SlotNb;	      // REQB/WUPB slots number
  ulong Tr0Tr1;	      // Minimum TR0 & TR1 value supported by PCD
  ulong Afwt;	      // Additional Frame Waiting Time, in us
  ulong Asfgt;	      // Additional Start-up Frame Guard Time, in us
  ulong BitFrame;     // Tx and Rx bit oriented frame adjustement

} card_PCfgType, *card_PCfgRef;

/*----------------------------------------------------------------------*
  card_CardPCfg : Set and Get contactless card configuration structure
 *----------------------------------------------------------------------*/
extern
err_Type card_CardPCfg(
        card_Ref Obj,
        card_PCfgRef pCfg	// (In/Out) Configuration structure
        );

/*----------------------------------------------------------------------*
  card_CryptOn : Enable crypto
 *----------------------------------------------------------------------*/
extern
err_Type card_CryptOn(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_CryptOff : Disable crypto
 *----------------------------------------------------------------------*/
extern
err_Type card_CryptOff(
        card_Ref Obj
        );

/*----------------------------------------------------------------------*
  card_AntennaSwitchSet : Select Antenna 1 or 2 (DI-CORE / EPCCore)
 *----------------------------------------------------------------------*/
#define card_Antenna1	1
#define card_Antenna2	2

#define card_AntennaTop		1
#define card_AntennaBottom	2

extern
err_Type card_AntennaSwitchSet(
        card_Ref Obj,
        ulong Val	// (In) Antenna selection
        );

/*----------------------------------------------------------------------*
  card_AntennaDetect : Detect document on Antenna (DI-CORE / EPCCore)
 *----------------------------------------------------------------------*/
extern
err_Type card_AntennaDetect(
        card_Ref Obj,
        ulong Mode,	// (In) Mode 
        ulong *pStatus	// (Ou) Detection result
        );



/************************************************************************
 ************************************************************************
	OBSOLETE FUNCTIONS
 ************************************************************************
 ************************************************************************/

/*----------------------------------------------------------------------*
  card_VppDef : Set Vpp voltage in Programming State. Default is 5000mV
 *----------------------------------------------------------------------*/
extern
err_Type card_VppDef(
        card_Ref Obj, 
        ushort Vpp		// (In) Vpp in mV
        );

/*----------------------------------------------------------------------*
  card_VppIdleDef : Set Vpp voltage in Pause State. Default is 5000mV
 Default Vpp = Vcc
 *----------------------------------------------------------------------*/
#define card_VppIdleVcc 0xC000
#define card_VppIdleVpp 0x8000

extern
err_Type card_VppIdleDef(
        card_Ref Obj,
        ushort VppIdle	// (In) Vpp in mV or define
        );

/*----------------------------------------------------------------------*
 card_HwiCfgType : Contact interface hardware configuration structure
 *----------------------------------------------------------------------*/
#define card_HwiCfgVcc		0x0001
#define card_HwiCfgVpp		0x0002
#define card_HwiCfgFreq		0x0004
#define card_HwiCfgSwitch	0x0008
#define card_HwiCfgOn		0x0010
#define card_HwiCfgAll		0x001F

typedef struct {
  ulong StructSize;	// Structure Size
  ulong Mask;   // Selection Mask. If null get the current configuration
  ulong Vcc;
  ulong Vpp;
  ulong Freq;
  ulong Switch; // Detect Card In Coupler
  ulong On;	// Card Powered or Not
} card_HwiCfgType, *card_HwiCfgRef;

/*----------------------------------------------------------------------*
  card_HwiCfg : Set or get the contact interface hardware configuration
 *----------------------------------------------------------------------*/
extern
err_Type card_HwiCfg(
        card_Ref Obj,
        card_HwiCfgType *pCfg   // (In,Out) Hardware configuration structure
        );

/*----------------------------------------------------------------------*
  card_CardCfg : Set protocol configuration (Use card_CardCgfX instead)
    REMARKS : if Mask field = 0, the reader returns the current config parameters
 *----------------------------------------------------------------------*/
#define card_CfgN     0x0001
#define card_CfgFI    0x0002
#define card_CfgDI    0x0004
#define card_CfgWI    0x0008
#define card_CfgCWI   0x0010
#define card_CfgBWI   0x0020
#define card_CfgFD    0x0040
#define card_CfgBGT   0x0080
#define card_CfgTSWT  0x0100
#define card_CfgAll   0x01FF

typedef struct {
  ushort Mask; /* Mask : if 0 get the current configuration */
  ushort N;    /* N    : Extraguard time between 2 characters transmitted, in Etu counts */
  ushort FD;   /* FD   : Ratio F/D to fix the ETU value*/
  ushort FI;   /* FI   : Clock rate conversion Factor */
  ushort DI;   /* DI   : Baudrate adjustment factor */
  ushort WI;   /* WI   : Wait Integer: parameter used to compute the WWT (Work Waiting Time) */
  ushort CWI;  /* CWI  : Character Waiting time Integer */
  ushort BWI;  /* BWI  : Block Waiting time Integer */
  ushort BGT;  /* BGT  : Block GuardTime  */
  ushort TSWT; /* Guardtime Time before waiting ATR TS byte (in pulse clock unit) */
} card_CfgType, *card_CfgRef;

extern
err_Type card_CardCfg(
        card_Ref Obj, 
        card_CfgRef pConfig	// (In/Out) Configuration structure
        );

/*----------------------------------------------------------------------*
  card_FreqDef : Set frequency value (Use card_FreXDef instead)
 *----------------------------------------------------------------------*/
#define card_F0	 	0	// Continous level 0 Volt
#define card_F1	 	1	// Continous level Vcc
#define card_F357	2	// 3.57 MHz
#define card_F491	3	// 4.91 MHz
#define card_FXp3	3	// FreqX/3
#define card_F715	4	// 7.15 MHz
#define card_F983	5	// 9.83 MHz
#define card_FX2p3 	5	// FreqX*2/3
#define card_F1431 	6	// 14.31 MHz
#define card_F102	7	// 1.02 MHz

extern
err_Type card_FreqDef(
        card_Ref Obj,
        uchar Freq	// (In) Frequency configuration
        );

/*----------------------------------------------------------------------*
  card_Etu : Set new ETU configuration  (Use card_EtuX instead)

    Default configuration = 48
 48 : 9600  3.57MHz
 24 : 19200  3.57MHz
 16 : 28800  3.57MHz
 12 : 38400  3.57MHz
 8  : 57600  3.57MHz
 6  : 76800  3.57MHz
 4  : 115200  3.57MHz
 3  : 153600  3.57MHz
 2  : 230400  3.57MHz (rel : 230400 bauds)

 35 : 9600  4.91MHz
 17 : 19200  4.91MHz
 12 : 28800  4.91MHz
 9  : 38400  4.91MHz (rel : 52800 bauds)
 3  : 115200  4.91MHz (rel : 158500 bauds)

 Card Freq : 5.33MHz = FreqX/3 with 16MHz oscillator
 32 : 9600  5.33MHz
 16 : 19200  5.33MHz
 11 : 28800  5.33MHz
 8  : 38400  5.33MHz
 4  : 76800  5.33MHz (rel : 114700 bauds)
 2  : 153600  5.33MHz (rel : 230000 bauds)

 24 : 9600  7.15MHz
 12 : 19200  7.15MHz
 8  : 28800  7.15MHz
 6  : 38400  7.15MHz
 3  : 76800  7.15MHz (rel : 153900 bauds)
 2  : 115200  7.15MHz (rel : 230900 bauds)
 *----------------------------------------------------------------------*/

extern
err_Type card_Etu(
        card_Ref Obj, 
        uchar Etu	// (In) ETU configuration
        ); 

/*----------------------------------------------------------------------*
  card_In: ISO IN command (Use card_InX instead)
 *----------------------------------------------------------------------*/
extern
err_Type card_In(
        card_Ref Obj,
        uchar * Buf	// (In) Header and Data Buffer
        );

/*----------------------------------------------------------------------*
  card_InH : ISO IN command with detailed header (Use card_InXH instead)
 *----------------------------------------------------------------------*/
extern
err_Type card_InH(
        card_Ref Obj,
        uchar Cla,	// (In) Class
        uchar Ins,	// (In) Instruction
        uchar P1,	// (In) P1 parameter
        uchar P2,	// (In) P2 parameter
        uchar P3,	// (In) Data length up to 250 bytes max
        uchar * Buf	// (In) Data buffer
        );

/*----------------------------------------------------------------------*
  card_Out : ISO OUT command (Use card_OutX instead)
 *----------------------------------------------------------------------*/
extern
err_Type card_Out(
        card_Ref Obj,
        uchar * Hd,	// (In) Command Header
        uchar * pBuf,	// (Out) output data buffer
        uchar * pLng	// (Out) output data length
        );

/*----------------------------------------------------------------------*
  card_OutH : ISO OUT command with detailed header (Use card_OutXH instead)
 *----------------------------------------------------------------------*/
extern
err_Type card_OutH(
        card_Ref Obj,
        uchar Cla,	// (In) Class
        uchar Ins,	// (In) Instruction
        uchar P1,	// (In) P1 parameter
        uchar P2,	// (In) P2 parameter
        uchar P3,	// (In) P3 parameter
        uchar * pBuf,	// (Out) output data buffer
        uchar * pLng	// (Out) output data length
        );

/*----------------------------------------------------------------------*
  card_PTS : Send an ISO Protocol and Parameter Selection command (Use card_PPSX instead)
 *----------------------------------------------------------------------*/
extern
err_Type card_PTS(
        card_Ref Obj,
        uchar * Buf,	// (In) PTS block
        uchar Lng	// (In) Block length
        );

/*----------------------------------------------------------------------*
  card_Pipe : Send a ISO7816 T=1 formatted command (Use card_PipeX instead))
 *----------------------------------------------------------------------*/
extern
err_Type card_Pipe(
        card_Ref Obj,
        uchar * BufIn,		// (In) Data to send
        uchar LngIn,		// (In) Data length to send
        uchar * pBufOut,	// (Out) data received
        uchar * pLngOut		// (Out) returned length
        );


/*----------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif
#endif
