/*
 * Copyright 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SAM (AV4 and future SAM's) Specific implementation for RC663 Reader configuration of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_SAM_RC663_CONFIG_H
#define PHHALHW_SAM_RC663_CONFIG_H

#include <ph_Status.h>
#include <phhalHw.h>

/** \addtogroup phhalHw_Sam_Utils_RC663
 * @{
 */

/** \defgroup phhalHw_Sam_Rc663_Config Rc663 User Configuration
* \brief Custom Configuration of hardware related settings.
* @{
*/

/** \name RxThreshold values
*/
/** @{ */
#define PHHAL_HW_SAM_RC663_RXTHRESHOLD_I14443A_106      0x32U   /**< RxThreshold for ISO14443A @ 106kbit/s. */
#define PHHAL_HW_SAM_RC663_RXTHRESHOLD_I14443A_212      0x32U   /**< RxThreshold for ISO14443A @ 212kbit/s. */
#define PHHAL_HW_SAM_RC663_RXTHRESHOLD_I14443A_424      0x32U   /**< RxThreshold for ISO14443A @ 424kbit/s. */
#define PHHAL_HW_SAM_RC663_RXTHRESHOLD_I14443A_848      0x32U   /**< RxThreshold for ISO14443A @ 848kbit/s. */
/** @} */

/**
* end of group phhalHw_Sam_Rc663_Config
* @}
*/

/**
 * end of group phhalHw_Sam_Utils_RC663
 * @}
 */

#endif /* PHHALHW_SAM_RC663_CONFIG_H */
