/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ISO3 specific Constants HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_ISO3_CONSTANTS_H
#define PHHALHW_ISO3_CONSTANTS_H

/* ------- */
/* Defines */
/* ------- */
#define PHHAL_HW_ISO3_BUILD_CMD(cmd, operand)   (cmd << 28) | (PHHAL_HW_ISO3_FPGA_OPERAND_MASK & operand)
#define PHHAL_HW_ISO3_WRITE_REGISTER            (PHHAL_HW_ISO3_BUILD_CMD(PHHAL_HW_ISO3_FPGA_CMD_MOV_DST_IMM, 1))
#define PHHAL_HW_ISO3_READ_REGISTER             (PHHAL_HW_ISO3_BUILD_CMD(PHHAL_HW_ISO3_FPGA_CMD_WAIT_FOR_OUTBUF, 1))
#define PHHAL_HW_ISO3_WRITE_WORDS(count)        (PHHAL_HW_ISO3_BUILD_CMD(PHHAL_HW_ISO3_FPGA_CMD_MOV_DST_IMM, count))

/* ---------------- */
/* FPGA Address Map */
/* ---------------- */
/* --------------- */
/* Write Addresses */
/* --------------- */
#define PHHAL_HW_ISO3_FMC150_CLK_CTRL			0 /**< SPI data register Clockgenerator (CDCE72010) (b31:b0 used) */
#define PHHAL_HW_ISO3_FMC150_MON_CTRL			1 /**< SPI data register Voltage/Temp. Monitor (AMC7823) (b31:b0 used) */
#define PHHAL_HW_ISO3_FMC150_DAC_CTRL			2 /**< SPI data register DAC (DAC3283) (b15:0 used) */
#define PHHAL_HW_ISO3_FMC150_ADC_CTRL			3 /**< SPI data register ADC (ADS62P49) (b15:0 used) */
#define PHHAL_HW_ISO3_STEP_ATTEN_CTRL			4 /**< Step attenuator (b7=write to #2, b6=write to #1, b5:b0= data) */
#define PHHAL_HW_ISO3_SEVEN_SEG_DISP			5 /**< Seven-Segment-Display (not yet connected !) */
#define PHHAL_HW_ISO3_MISC_CTRL					6 /**< FMC150 control (b5=ADC-reset, b4=TX-enable, b3=Monitor-reset, b2=Clockgen-reset, b1=Clockgen-powerdown, b0=Clockgen-Ref-eneble) */

#define PHHAL_HW_ISO3_TX_CTRL					7 /**< TODO */
#define PHHAL_HW_ISO3_TX_DATA					0x400 /**< Transmit Data Ping Buffer (512*32) */
#define PHHAL_HW_ISO3_TX_DATA_1					0x600 /**< Transmit Data Pong Buffer (512*32) */
#define PHHAL_HW_ISO3_WAVESHAPE					0x800 /**< Waveshape Data Buffer (1024*32) */

/* -------------- */
/* Read Addresses */
/* -------------- */
#define PHHAL_HW_ISO3_FMC150_RB					0 /**< SPI data register readback (last value written to addr 0-3) */
#define PHHAL_HW_ISO3_FMC150_RD_SPI				1 /**< SPI read data register (Data read from previously written FMC150-SPI) */
#define PHHAL_HW_ISO3_SPI_STAT					2 /**< SPI/Step attenuator status (b2=Step-attenuator busy, b1=FMC150-SPI busy, b0=FMC150-SPI read buffer full) */
#define PHHAL_HW_ISO3_CAL_REF					3 /**< TODO */
#define PHHAL_HW_ISO3_STEP_ATTEN_RB				4 /**< Step attenuator readback (last value wriiten to addr 4) */
#define PHHAL_HW_ISO3_SEVEN_SEG_RB				5 /**< Seven-segment readback (last value written to addr 5) */
#define PHHAL_HW_ISO3_STAT						6 /**< TODO */
#define PHHAL_HW_ISO3_FDT_STAT					7 /**< TODO */

#define PHHAL_HW_ISO3_RX_DATA					0x400 /**< Data from receiver */
#define PHHAL_HW_ISO3_FDT_DATA					0x800 /**< Frame delay time measurement data (last bit of sent data, first bit of received data) */

/* ------------- */
/* FPGA Commands */
/* ------------- */
#define PHHAL_HW_ISO3_FPGA_OPERAND_MASK			0x0FFFFFFF

#define PHHAL_HW_ISO3_FPGA_CMD_LOOP				0x2 /**< Marks the beginning of a loop block and sets loop counter to a value of 1 */
#define PHHAL_HW_ISO3_FPGA_CMD_WAIT_FOR_CODE	0x4 /**< Suspend program execution until at least n items of program code are already commited to the code buffer */
#define PHHAL_HW_ISO3_FPGA_CMD_WAIT_FOR_OUTBUF	0x6 /**< copies n data items from following address to the output buffer */
#define PHHAL_HW_ISO3_FPGA_CMD_OUT_IMM			0x8 /**< copies n following words to the output buffer */
#define PHHAL_HW_ISO3_FPGA_CMD_MOV_DST_IMM		0xA /**< Copies n words to the memory map starting at following address */

#endif /* PHHALHW_ISO3_CONSTANTS_H */
