/*
 * Copyright 2017, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardare Thermostream ATS545 Component Application of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLTHSTRM_ATS545_INT_H
#define PHDLTHSTRM_ATS545_INT_H

#include <ph_Status.h>
#include <phdlThstrm.h>

phStatus_t phdlThstrm_ATS545_Int_SetSetPointTemp(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    int16_t Temperature
    );

phStatus_t phdlThstrm_ATS545_Int_GetSetPointTemp(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    int16_t * wTemperature
    );

phStatus_t phdlThstrm_ATS545_Int_CheckCmdExec(
    phdlThstrm_ATS545_DataParams_t * pDataParams
    );


phStatus_t phdlThstrm_ATS545_Int_SetHead(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t bDirection
    );
phStatus_t phdlThstrm_ATS545_Int_GetHead(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * pbDirection
    );

phStatus_t phdlThstrm_ATS545_Int_SetFlow(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t bFlow
    );
phStatus_t phdlThstrm_ATS545_Int_GetFlow(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * bFlow
    );

phStatus_t phdlThstrm_ATS545_Int_SetFlowRate(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t bFlowRate
    );

phStatus_t phdlThstrm_ATS545_Int_GetFlowRate(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * bFlowRate
    );

phStatus_t phdlThstrm_ATS545_Int_SetSetPointSoakTime(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint16_t SoakTime
    );

phStatus_t phdlThstrm_ATS545_Int_GetSetPointSoakTime(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint16_t * wSoakTime
    );

phStatus_t phdlThstrm_ATS545_Int_SetSelectedSetPoint(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t SetPoint
    );

phStatus_t phdlThstrm_ATS545_Int_GetSelectedSetPoint(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * bSetPoint
    );

phStatus_t phdlThstrm_ATS545_Int_SetSetPointWindow(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t TempWindow
    );

phStatus_t phdlThstrm_ATS545_Int_GetSetPointWindow(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * bTempWindow
    );

phStatus_t phdlThstrm_ATS545_Int_ConfigureThermostream(
    phdlThstrm_ATS545_DataParams_t * pDataParams
    );

phStatus_t phdlThstrm_ATS545_Int_GetCurrentTemp(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    int16_t * Temperature
    );

phStatus_t phdlThstrm_ATS545_Int_GetSetPointTempReached(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * TempReached
    );

phStatus_t phdlThstrm_ATS545_Int_SetComprState(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t bCompr
    );

phStatus_t phdlThstrm_ATS545_Int_GetComprState(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * pbComprState
    );

phStatus_t phdlThstrm_ATS545_Int_Send(
                                       phdlThstrm_ATS545_DataParams_t * pDataParams,
                                       uint8_t * pTxBuffer,
                                       uint16_t wTxLength
                                       );

phStatus_t phdlThstrm_ATS545_Int_SendWait(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * pTxBuffer,
    uint16_t wTxLength,
    uint16_t wWaittime
    );

phStatus_t phdlThstrm_ATS545_Int_SetHeadLockedState(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t bState
    );
phStatus_t phdlThstrm_ATS545_Int_GetHeadLockedState(
    phdlThstrm_ATS545_DataParams_t * pDataParams,
    uint8_t * bState
    );

#endif /* PHDLTHSTRM_ATS545_INT_H */
