/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hardware Steppper V1 Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_V1_H
#define PHDLSTEPPER_V1_H

#include <ph_Status.h>
#include <phdlStepper.h>

phStatus_t  phdlStepper_V1_Initialize(
                                      phdlStepper_V1_DataParams_t * pDataParams
                                      );

phStatus_t phdlStepper_V1_MoveSteps(
                                    phdlStepper_V1_DataParams_t * pDataParams,
                                    uint16_t wSpeed,
                                    uint8_t bDirection,
                                    uint32_t dwSteps,
                                    uint8_t bBlocking
                                    );

phStatus_t phdlStepper_V1_MoveDistance(
                                       phdlStepper_V1_DataParams_t * pDataParams,
                                       uint16_t wSpeed,
                                       uint8_t bDirection,
                                       uint32_t dwDistance,
                                       uint8_t bBlocking
                                       );

phStatus_t phdlStepper_V1_GoToPosition(
                                       phdlStepper_V1_DataParams_t * pDataParams,
                                       uint16_t wSpeed,
                                       uint32_t dwPosition,
                                       uint8_t bBlocking
                                       );

phStatus_t phdlStepper_V1_SetConfig(
                                    phdlStepper_V1_DataParams_t * pDataParams,
                                    uint16_t wConfig,
                                    uint16_t wValue
                                    );

phStatus_t phdlStepper_V1_SetConfig32(
                                      phdlStepper_V1_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint32_t dwValue
                                      );

phStatus_t phdlStepper_V1_GetConfig(
                                    phdlStepper_V1_DataParams_t * pDataParams,
                                    uint16_t wConfig,
                                    uint16_t * pValue
                                    );

phStatus_t phdlStepper_V1_GetConfig32(
                                      phdlStepper_V1_DataParams_t * pDataParams,
                                      uint16_t wConfig,
                                      uint32_t * pValue
                                      );

/* postion counter value for limits */
#define	PHDL_STEPPER_V1_LIMIT_UPPER				0xAAU
#define	PHDL_STEPPER_V1_LIMIT_LOWER				0xBBU

/* maximum values for config */
#define PHDL_STEPPER_V1_MAX_MAX_SPEED			0xFE7EU
#define PHDL_STEPPER_V1_MAX_START_SPEED			0xF424U

#endif /* PHDLSTEPPER_V1_H */
