/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Stepper Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_ROBOT_INT_H
#define PHDLSTEPPER_ROBOT_INT_H

#include <ph_Status.h>

phStatus_t phdlStepper_Robot_Int_ConvertToStep(
                                        phdlStepper_Robot_DataParams_t * pDataParams,
                                        int32_t dwPos,
                                        int32_t * dwStepPos
                                        );

phStatus_t phdlStepper_Robot_Int_ConvertFromStep(
                                        phdlStepper_Robot_DataParams_t * pDataParams,
                                        int32_t dwStepPos,
                                        int32_t * dwPos
                                        );

phStatus_t phdlStepper_Robot_Int_Reset(
                                        phdlStepper_Robot_DataParams_t * pDataParams
                                        );

phStatus_t phdlStepper_Robot_Approval(
                                        phdlStepper_Robot_DataParams_t * pDataParams
                                        );

phStatus_t phdlStepper_Robot_Int_GetStep(
                                        phdlStepper_Robot_DataParams_t * pDataParams,
                                        int32_t * dwStep
                                        );

phStatus_t phdlStepper_Robot_Int_WaitMoveFinished(
                                        phdlStepper_Robot_DataParams_t * pDataParams,
                                        int32_t dwTargetStep,
                                        uint16_t bDolerance
                                        );

phStatus_t phdlStepper_Robot_Int_SetTarget(
                                        phdlStepper_Robot_DataParams_t * pDataParams,
                                        int32_t dwTarget);

phStatus_t phdlStepper_Robot_Int_Start(
                                        phdlStepper_Robot_DataParams_t * pDataParams
                                        );

phStatus_t phdlStepper_Robot_Int_SetMode(
                                        phdlStepper_Robot_DataParams_t * pDataParams,
                                        uint8_t mode
                                        );

phStatus_t phdlStepper_Robot_Int_SetMaxUpm(
                                        phdlStepper_Robot_DataParams_t * pDataParams,
                                        uint16_t wUpm
                                        );

phStatus_t phdlStepper_Robot_Int_GoToStep(
                                       phdlStepper_Robot_DataParams_t * pDataParams,
                                       uint16_t wSpeed,
                                       int32_t dwStep,
                                       uint8_t bBlocking
                                       );

/* Commands for the stepper */
#define PHDL_STEPPER_ROBOT_INT_SND_RESET                      (uint8_t *)"RESET!\r"
#define PHDL_STEPPER_ROBOT_INT_SND_REFERENCE                  (uint8_t *)"REFGO!\r"
#define PHDL_STEPPER_ROBOT_INT_SND_SET_TARGET                 (uint8_t *)"SPX:01:%08X\r"
#define PHDL_STEPPER_ROBOT_INT_SND_START                      (uint8_t *)"SPSTART:01\r"
#define PHDL_STEPPER_ROBOT_INT_SND_SET_POSITION               (uint8_t *)"SPSETX:%08X\r"
#define PHDL_STEPPER_ROBOT_INT_SND_GET_POSITION               (uint8_t *)"SPXIST?\r"
#define PHDL_STEPPER_ROBOT_INT_SND_STEP                       (uint8_t *)"SPX:01:%08X\r"
#define PHDL_STEPPER_ROBOT_INT_SND_SET_MAX_UPM                (uint8_t *)"SPVMAX:01:%04X\r"
#define PHDL_STEPPER_ROBOT_INT_SND_SET_POS_MODE               (uint8_t *)"SPMODE:01:%04X\r"
#define PHDL_STEPPER_ROBOT_INT_SND_APPROVAL                   (uint8_t *)"SRF+\r"

#endif /* PHDLSTEPPER_ROBOT_INT_H */
