/*
 * Copyright 2017 - 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Stepper Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSTEPPER_MICROBOT_INT_H
#define PHDLSTEPPER_MICROBOT_INT_H

#include <ph_Status.h>

#if _MSC_VER <= 1600
#define DOUBLE
#else
#define DOUBLE	(double)
#endif

phStatus_t phdlStepper_Microbot_Int_ConvertToStep(
                                        phdlStepper_Microbot_DataParams_t * pDataParams,
                                        int32_t dwDistance,
                                        int32_t * dwSteps
                                        );

phStatus_t phdlStepper_Microbot_Int_ConvertFromStep(
                                        phdlStepper_Microbot_DataParams_t * pDataParams,
                                        int32_t dwSteps,
                                        int32_t * dwDistance
                                        );

phStatus_t phdlStepper_Microbot_Int_GetStatus(
                                        phdlStepper_Microbot_DataParams_t * pDataParams,
                                        uint32_t * wStatus
                                        );

phStatus_t phdlStepper_Microbot_Int_GoTo(phdlStepper_Microbot_DataParams_t * pDataParams,
                                        uint8_t bBlocking);

phStatus_t phdlStepper_Microbot_Int_GoToParameter(
                                        phdlStepper_Microbot_DataParams_t * pDataParams,
                                        int32_t x, int32_t y, int32_t z, int16_t angle,
                                        uint8_t bBlocking
                                        );

phStatus_t phdlStepper_Microbot_Int_GetPosition(
                                        phdlStepper_Microbot_DataParams_t * pDataParams,
                                        int32_t *x, int32_t *y, int32_t *z, int16_t *angle
                                        );

phStatus_t phdlStepper_Microbot_Int_SetAsZero(phdlStepper_Microbot_DataParams_t * pDataParams);

phStatus_t phdlStepper_Microbot_Int_ManualMode(phdlStepper_Microbot_DataParams_t * pDataParams);

phStatus_t phdlStepper_Microbot_Int_WaitMoveFinished(phdlStepper_Microbot_DataParams_t * pDataParams);

/* Commands for the Microbot */
#define PHDL_STEPPER_MICROBOT_INT_SND_REQUEST_POSITION           (uint8_t *)"MRRP\r\n"
#define PHDL_STEPPER_MICROBOT_INT_SND_STATUS                     (uint8_t *)"MRST\r\n"
#define PHDL_STEPPER_MICROBOT_INT_SND_RESET_POSITION             (uint8_t *)"RSTH\r\n"
#define PHDL_STEPPER_MICROBOT_INT_SND_MANUAL_MODE                (uint8_t *)"MERD\r\n"
#define PHDL_STEPPER_MICROBOT_INT_SND_GOTO                       (uint8_t *)"MRGT %d %d %d %f\r\n"

/* postion counter value for limits */
#define	PHDL_STEPPER_MICROBOT_LIMIT_X				    300000  /* +/- 15 cm */
#define	PHDL_STEPPER_MICROBOT_LIMIT_Y				    300000  /* +/- 15 cm */
#define	PHDL_STEPPER_MICROBOT_LIMIT_Z				    1000000  /* +/- 50 cm */

#define	PHDL_STEPPER_MICROBOT_TOLERANCE_LIMIT_X				    500  /* 0.5mm */
#define	PHDL_STEPPER_MICROBOT_TOLERANCE_LIMIT_Y				    500  /* 0.5mm */
#define	PHDL_STEPPER_MICROBOT_TOLERANCE_LIMIT_Z				    500  /* 0.5mm */

#endif /* PHDLSTEPPER_MICROBOT_INT_H */
