/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Spectrum Analyzer R&S FSV Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLSPA_FSV_INT_H
#define PHDLSPA_FSV_INT_H

#include <ph_Status.h>
#include <phdlSPA.h>

#define PHDL_SPA_FSV_STR                     (uint8_t *)"FSV-4"
#define PHDL_SPA_FSVR_STR                    (uint8_t *)"FSVR-7"

phStatus_t phdlSPA_FSV_Int_Get_Max_Frequency(
                                              phdlSPA_FSV_DataParams_t * pDataParams,
                                              uint64_t * pqMaxFreq
                                             );

phStatus_t phdlSPA_FSV_Int_Set_Instrument_Parameter(
                                                    phdlSPA_FSV_DataParams_t * pDataParams,
                                                    int8_t * pbIdBuff,
                                                    uint8_t * bseperetorId
                                                   );

phStatus_t phdlSPA_FSV_Int_Set_Active_Probe(
                                            phdlSPA_FSV_DataParams_t * pDataParams,
                                            uint16_t wValue
                                           );

phStatus_t phdlSPA_FSV_Int_Get_Active_Probe_Info(
                                                 phdlSPA_FSV_DataParams_t * pDataParams
                                                );
#endif /* PHDLSPA_FSV_INT_H */
