/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Hardware Powersupply Agilent E3631A Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLPOWERSUPPLY_E3631A_H
#define PHDLPOWERSUPPLY_E3631A_H

#include <ph_Status.h>
#include <phdlPowerSupply.h>

phStatus_t phdlPowerSupply_E3631A_Init(
                                phdlPowerSupply_E3631A_DataParams_t * pDataParams,
                                uint16_t wSizeOfDataParams,
                                phbalReg_Visa_DataParams_t * pBalRegDataParams
                                );

phStatus_t phdlPowerSupply_E3631A_InitPowerSupply(
                                    phdlPowerSupply_E3631A_DataParams_t * pDataParams
                                    );

phStatus_t phdlPowerSupply_E3631A_SetConfig(
                                     phdlPowerSupply_E3631A_DataParams_t * pDataParams,
                                     uint16_t wIdentifier,
                                     uint16_t wValue
                                     );

phStatus_t phdlPowerSupply_E3631A_GetConfig(
                                     phdlPowerSupply_E3631A_DataParams_t * pDataParams,
                                     uint16_t wIdentifier,
                                     uint16_t * pwValue
                                     );

phStatus_t phdlPowerSupply_E3631A_PowerOn(
                                   phdlPowerSupply_E3631A_DataParams_t * pDataParams,
                                   uint8_t  bChannel
                                   );

phStatus_t phdlPowerSupply_E3631A_PowerOff(
                                   phdlPowerSupply_E3631A_DataParams_t * pDataParams,
                                   uint8_t  bChannel
                                   );

#endif /* PHDLPOWERSUPPLY_E3631A_H */
