/*
 * Copyright 2013, 2017 - 2020, 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal Hardware Oscilloscope Waverunner 64Xi Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLOSCI_LW64XI_INT_H
#define PHDLOSCI_LW64XI_INT_H

#include <ph_Status.h>
#include <phdlOsci.h>

#define PH_VALUE_ON                  (const char *)"ON"
#define PH_VALUE_OFF                 (const char *)"OFF"


phStatus_t phdlOsci_LW64Xi_Int_ChkLastCmd(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ChkLastExe(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_WaitExe(
                                       phdlOsci_LW64Xi_DataParams_t * pDataParams
                                       );

phStatus_t phdlOsci_LW64Xi_Int_ChkCmd(
                                      phdlOsci_LW64Xi_DataParams_t * pDataParams
                                      );

phStatus_t phdlOsci_LW64Xi_Int_GetAmpl(
                                       phdlOsci_LW64Xi_DataParams_t * pDataParams,
                                       uint8_t  pbSource[2],
                                       float32_t * pfAmplitude
                                       );

phStatus_t phdlOsci_LW64Xi_Int_GetRMS(
                                       phdlOsci_LW64Xi_DataParams_t * pDataParams,
                                       uint8_t  pbSource[2],
                                       float32_t * pfRMS
                                       );

phStatus_t phdlOsci_LW64Xi_Int_GetPeakPeak(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t  pbSource[2],
    float32_t * pfAmplitude
    );

phStatus_t phdlOsci_LW64Xi_Int_OverUndershoot(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t  bSource[2],
    uint8_t * pBIsOverUnderShoot
    );

phStatus_t phdlOsci_LW64Xi_Int_CorrDiv(
                                       uint32_t  dwOldDiv,
                                       uint32_t * dwNewDiv
                                       );

phStatus_t phdlOsci_LW64Xi_Int_ConvertDivInCmd(
    uint32_t  dwDiv,
    uint8_t  bSource[2],
    uint8_t * pCmdLength,
    uint8_t * pCmd
    );

phStatus_t phdlOsci_LW64Xi_Int_GetDiv(
                                      phdlOsci_LW64Xi_DataParams_t * pDataParams,
                                      uint8_t  bSource[2],
                                      uint32_t * dwDiv
                                      );

phStatus_t phdlOsci_LW64Xi_Int_GetBestDiv(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint32_t dwOldDiv,
    float32_t fPeakPeak,
    uint32_t * dwNewDiv
    );

phStatus_t phdlOsci_LW64Xi_Int_SetCorrRange(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t  bSource[2]
);

phStatus_t phdlOsci_LW64Xi_Int_GetWaveForm(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t  bSource[2],
    uint32_t dwWaveFormBufferSize,
    uint32_t * pdwWaveFormLength,
    uint8_t * pWaveFormBuffer,
    uint8_t * pbHeaderOffset
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigFDT_PCD(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigFDT_PICC_106_L3(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigFDT_PICC_106_L4(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigFDT_PICC_212_L4(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigFDT_PICC_424_L4(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigFDT_PICC_848_L4(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigLive(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigVHD(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigEMD(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigSet(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigGlobal(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_SetTriggerMode(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint16_t wTriggerMode
    );

phStatus_t phdlOsci_LW64Xi_Int_GetTriggerMode(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint16_t * pwTriggerMode
    );

phStatus_t phdlOsci_LW64Xi_Int_ConfigOsci(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t bConfig
    );

phStatus_t phdlOsci_LW64Xi_Int_BalReg_VisaExchangeLarge(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t * pTxBuffer,   /**< [In] data to transmit */
    uint16_t wTxLength,    /**< [In] length of input data */
    uint32_t dwRxBufSize,   /**< [In] size of receive buffer */
    uint8_t * pRxBuffer,   /**< [Out] received data */
    uint32_t * pRxLength   /**< [Out] number of received data bytes */
    );

phStatus_t phdlOsci_LW64Xi_Int_GetChannelConfig(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t bChannel,
    uint8_t *pParam,
    uint8_t *pValue,
    uint16_t wValueSize
    );

phStatus_t phdlOsci_LW64Xi_Int_GetParseChannelValue(
    uint8_t bChannel,
    uint8_t *pBuffer,
    uint8_t *pValue
    );

phStatus_t phdlOsci_LW64Xi_Int_GetNoiseFilterValue(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t *pValue
    );

phStatus_t phdlOsci_LW64Xi_Int_ConvertStringToInt64(
    uint8_t *abBuffer,
    int64_t qwMultiplier,
    int64_t *pqwValue
    );

phStatus_t phdlOsci_LW64Xi_Int_GetParseTriggerSource(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t *pBuffer,
    uint8_t *pValue
    );

phStatus_t phdlOsci_LW64Xi_Int_SetChannelConfig(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t bChannel,
    uint8_t *pParam,
    uint8_t *pValue
    );

phStatus_t phdlOsci_LW64Xi_Int_SetTriggerConfig(
    phdlOsci_LW64Xi_DataParams_t * pDataParams,
    uint8_t *pSource
    );

phStatus_t phdlOsci_LW64Xi_Int_SetMaxSamplesRange(
    phdlOsci_LW64Xi_DataParams_t * pDataParams
    );

phStatus_t phdlOsci_LW64Xi_Int_WaitForStateArmedOrStop(
                                                 phdlOsci_LW64Xi_DataParams_t * pDataParams
                                                 );

phStatus_t phdlOsci_LW64Xi_Int_WaitForStateStop(
                                                 phdlOsci_LW64Xi_DataParams_t * pDataParams
                                                 );
#endif /* PHDLOSCI_LW64XI_INT_H */
