/*
 * Copyright 2019 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ISO3 FPGA soft scope.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLOSCI_ISO3SOFTSCOPE_H
#define PHDLOSCI_ISO3SOFTSCOPE_H

#include <ph_Status.h>
#include <phdlOsci.h>


phStatus_t phdlOsci_ISO3SoftScope_SetConfig         (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint16_t wIdentifier,
                                                     uint16_t wValue
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_GetConfig         (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint16_t wIdentifier,
                                                     uint16_t * pwValue
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_SetConfig64       (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint16_t wIdentifier,
                                                     int64_t qValue
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_GetConfig64       (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint16_t wIdentifier,
                                                     int64_t * pqValue
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_GetFieldStrength  (
                                                    phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                    uint8_t bChannel,
                                                    uint16_t * pdwFieldStrength
                                                    );

phStatus_t phdlOsci_ISO3SoftScope_GetAmpl           (
                                                    phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                    uint8_t  bChannel,
                                                    uint16_t * pwAmplitude
                                                    );

phStatus_t phdlOsci_ISO3SoftScope_GetPeakPeak       (
                                                    phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                    uint8_t  bChannel,
                                                    float64_t * pdfPkPk
                                                    );

phStatus_t phdlOsci_ISO3SoftScope_GetRMS            (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint8_t  bChannel,
                                                     uint16_t * pwRMS
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_GetRMSDouble       (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint8_t  bChannel,
                                                     float64_t * pdfRMS
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_SetCorrRange      (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint8_t  bChannel
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_InitOsci          (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_GetWaveForm       (
                                                     phdlOsci_ISO3SoftScope_DataParams_t * pDataParams,
                                                     uint8_t  bChannel,
                                                     uint32_t dwWaveFormBufferSize,
                                                     uint32_t * pdwWaveFormLength,
                                                     uint8_t * pbWaveFormBuffer,
                                                     uint8_t * pbHeaderOffset
                                                     );

phStatus_t phdlOsci_ISO3SoftScope_Int_FDT_Measurement(phdlOsci_ISO3SoftScope_DataParams_t * pDataParams, uint8_t bEnabled);

#endif /* PHDLOSCI_ISO3SOFTSCOPE_H */
