/*
 * Copyright 2013, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic Master Amplifier Oscilloscope Device Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phdlMstAmpOsc.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHDL_MSTAMPOSC_AR75A250
#include "AR75A250/phdlMstAmpOsc_AR75A250.h"
#endif /* NXPBUILD__PHDL_MSTAMPOSC_AR75A250 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP
#include "ISOSetup/phdlMstAmpOsc_ISOSetup.h"
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_MP300
#include "Mp300/phdlMstAmpOsc_Mp300.h"
#endif /* NXPBUILD__PHDL_MSTAMPOSC_MP300 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISO3
#include "ISO3/phdlMstAmpOsc_ISO3.h"
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISO3 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC

phStatus_t phdlMstAmpOsc_InitMstAmpOsc(
                                       void * pDataParams
                                       )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlMstAmpOsc_InitMstAmpOsc");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_MSTAMPOSC)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_MSTAMPOSC_AR75A250
    case PHDL_MSTAMPOSC_AR75A250_ID:
        status = phdlMstAmpOsc_AR75A250_InitMstAmpOsc((phdlMstAmpOsc_AR75A250_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_AR75A250 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP
    case PHDL_MSTAMPOSC_ISOSETUP_ID:
        status = phdlMstAmpOsc_ISOSetup_InitMstAmpOsc((phdlMstAmpOsc_ISOSetup_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_MP300
    case PHDL_MSTAMPOSC_MP300_ID:
        status = phdlMstAmpOsc_Mp300_InitMstAmpOsc((phdlMstAmpOsc_Mp300_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_MP300 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISO3
    case PHDL_MSTAMPOSC_ISO3_ID:
        status = phdlMstAmpOsc_ISO3_InitMstAmpOsc((phdlMstAmpOsc_ISO3_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISO3 */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phdlMstAmpOsc_SetConfig(
                                   void * pDataParams,
                                   uint16_t wIdentifier,
                                   uint16_t wValue
                                   )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlMstAmpOsc_SetConfig");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wIdentifier);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wValue);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wIdentifier_log, &wIdentifier);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wValue_log, &wValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_MSTAMPOSC)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_MSTAMPOSC_AR75A250
    case PHDL_MSTAMPOSC_AR75A250_ID:
        status = phdlMstAmpOsc_AR75A250_SetConfig((phdlMstAmpOsc_AR75A250_DataParams_t *)pDataParams, wIdentifier, wValue);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_AR75A250 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP
    case PHDL_MSTAMPOSC_ISOSETUP_ID:
        status = phdlMstAmpOsc_ISOSetup_SetConfig((phdlMstAmpOsc_ISOSetup_DataParams_t *)pDataParams, wIdentifier, wValue);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_MP300
    case PHDL_MSTAMPOSC_MP300_ID:
        status = phdlMstAmpOsc_Mp300_SetConfig((phdlMstAmpOsc_Mp300_DataParams_t *)pDataParams, wIdentifier, wValue);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_MP300 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISO3
    case PHDL_MSTAMPOSC_ISO3_ID:
        status = phdlMstAmpOsc_ISO3_SetConfig((phdlMstAmpOsc_ISO3_DataParams_t *)pDataParams, wIdentifier, wValue);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISO3 */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phdlMstAmpOsc_GetConfig(
                                   void * pDataParams,
                                   uint16_t wIdentifier,
                                   uint16_t * pwValue
                                   )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlMstAmpOsc_GetConfig");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wIdentifier);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pwValue);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wIdentifier_log, &wIdentifier);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_MSTAMPOSC)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_MSTAMPOSC_AR75A250
    case PHDL_MSTAMPOSC_AR75A250_ID:
        status = phdlMstAmpOsc_AR75A250_GetConfig((phdlMstAmpOsc_AR75A250_DataParams_t *)pDataParams, wIdentifier, pwValue);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_AR75A250 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP
    case PHDL_MSTAMPOSC_ISOSETUP_ID:
        status = phdlMstAmpOsc_ISOSetup_GetConfig((phdlMstAmpOsc_ISOSetup_DataParams_t *)pDataParams, wIdentifier, pwValue);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_MP300
    case PHDL_MSTAMPOSC_MP300_ID:
        status = phdlMstAmpOsc_Mp300_GetConfig((phdlMstAmpOsc_Mp300_DataParams_t *)pDataParams, wIdentifier, pwValue);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_MP300 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISO3
	case PHDL_MSTAMPOSC_ISO3_ID:
		status = phdlMstAmpOsc_ISO3_GetConfig((phdlMstAmpOsc_ISO3_DataParams_t *)pDataParams, wIdentifier, pwValue);
		break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISO3 */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, pwValue_log, pwValue);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phdlMstAmpOsc_Cal(
                             void * pDataParams
                             )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlMstAmpOsc_Cal");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_MSTAMPOSC)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_MSTAMPOSC_AR75A250
    case PHDL_MSTAMPOSC_AR75A250_ID:
        status = phdlMstAmpOsc_AR75A250_Cal((phdlMstAmpOsc_AR75A250_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_AR75A250 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP
    case PHDL_MSTAMPOSC_ISOSETUP_ID:
        status = phdlMstAmpOsc_ISOSetup_Cal((phdlMstAmpOsc_ISOSetup_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_MP300
    case PHDL_MSTAMPOSC_MP300_ID:
        status = phdlMstAmpOsc_Mp300_Cal((phdlMstAmpOsc_Mp300_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_MP300 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISO3
    case PHDL_MSTAMPOSC_ISO3_ID:
        status = phdlMstAmpOsc_ISO3_Cal((phdlMstAmpOsc_ISO3_DataParams_t *)pDataParams);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISO3 */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phdlMstAmpOsc_SetFieldStrength(
    void * pDataParams,
    uint16_t wFieldStrength
    )
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phdlMstAmpOsc_SetFieldStrength");
    /*PH_LOG_HELPER_ALLOCATE_PARAMNAME(pDataParams);*/
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wFieldStrength);
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, wFieldStrength_log, &wFieldStrength);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);
    PH_ASSERT_NULL (pDataParams);

    if (PH_GET_COMPCODE(pDataParams) != PH_COMP_DL_MSTAMPOSC)
    {
		status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    /* perform operation on active layer */
    switch (PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHDL_MSTAMPOSC_AR75A250
    case PHDL_MSTAMPOSC_AR75A250_ID:
        status = phdlMstAmpOsc_AR75A250_SetFieldStrength((phdlMstAmpOsc_AR75A250_DataParams_t *)pDataParams, wFieldStrength);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_AR75A250 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP
    case PHDL_MSTAMPOSC_ISOSETUP_ID:
        status = phdlMstAmpOsc_ISOSetup_SetFieldStrength((phdlMstAmpOsc_ISOSetup_DataParams_t *)pDataParams, wFieldStrength);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_MP300
    case PHDL_MSTAMPOSC_MP300_ID:
        status = phdlMstAmpOsc_Mp300_SetFieldStrength((phdlMstAmpOsc_Mp300_DataParams_t *)pDataParams, wFieldStrength);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_MP300 */

#ifdef NXPBUILD__PHDL_MSTAMPOSC_ISO3
    case PHDL_MSTAMPOSC_ISO3_ID:
        status = phdlMstAmpOsc_ISO3_SetFieldStrength((phdlMstAmpOsc_ISO3_DataParams_t *)pDataParams, wFieldStrength);
        break;
#endif /* NXPBUILD__PHDL_MSTAMPOSC_ISO3 */

    default:
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_DL_MSTAMPOSC);
        break;
    }
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, status_log, &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

#endif /* NXPBUILD__PHDL_MSTAMPOSC */
