/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software Master Amplifier Oscilloscope Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLMSTAMPOSC_MP300_H
#define PHDLMSTAMPOSC_MP300_H

#include <ph_Status.h>
#include "../../../../intfs/phhalHw.h"

phStatus_t phdlMstAmpOsc_Mp300_InitMstAmpOsc(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams
    );

phStatus_t phdlMstAmpOsc_Mp300_SetConfig(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wIdentifier,
    uint16_t wValue
    );

phStatus_t phdlMstAmpOsc_Mp300_GetConfig(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wIdentifier,
    uint16_t * pwValue
    );

phStatus_t phdlMstAmpOsc_Mp300_Cal(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams
    );

phStatus_t phdlMstAmpOsc_Mp300_SetFieldStrength(
    phdlMstAmpOsc_Mp300_DataParams_t * pDataParams,
    uint16_t wFieldStrength
    );

#endif /* PHDLMSTAMPOSC_MP300_H */
