/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * ISO3 Setup Software Master Amplifier Oscilloscope Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHDLMSTAMPOSC_ISO3_H
#define PHDLMSTAMPOSC_ISO3_H

#include <ph_Status.h>
#include <phdlMstAmpOsc.h>

phStatus_t phdlMstAmpOsc_ISO3_InitMstAmpOsc(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams
    );

phStatus_t phdlMstAmpOsc_ISO3_Cal(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams
    );

phStatus_t phdlMstAmpOsc_ISO3_SetConfig(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams,
    uint16_t wIdentifier,
    uint16_t pwValue
    );

phStatus_t phdlMstAmpOsc_ISO3_GetConfig(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams,
    uint16_t wIdentifier,
    uint16_t * pwValue
    );

phStatus_t phdlMstAmpOsc_ISO3_SetFieldStrength(
    phdlMstAmpOsc_ISO3_DataParams_t * pDataParams,
    uint16_t wFieldStrength
    );

#endif /* PHDLMSTAMPOSC_ISO3_H */
