/*
 * Copyright 2013, 2017, 2019, 2023 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHBAL_REG_STUB
#include "Stub/phbalReg_Stub.h"
#endif /* NXPBUILD__PHBAL_REG_STUB */

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
#include "SerialWin/phbalReg_SerialWin.h"
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
#include "PcscWin/phbalReg_PcscWin.h"
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
#include "Rd70xUsbWin/phbalReg_Rd70xUsbWin.h"
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
#include "Mp300Usb/phbalReg_Mp300Usb.h"
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
#include "PipeLin/phbalReg_PipeLin.h"
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
#include "SocketWin/phbalReg_SocketWin.h"
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
#include "Rd710Sam/phbalReg_Rd710Sam.h"
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_SAM
#include "Sam\/phbalReg_Sam.h"
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
#include "Visa/phbalReg_Visa.h"
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
#include "RdFpgaV6/phbalReg_RdFpgaV6.h"
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
#include "Ps6000Usb/phbalReg_Ps6000Usb.h"
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
#include "MultiSocket\phbalReg_MultiSocket.h"
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
#include "ProxiLAB\phbalReg_ProxiLAB.h"
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
#include "RdScr01\phbalReg_RdScr01.h"
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
#include "RdScr2\phbalReg_RdScr2.h"
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
#include "ContactLAB\phbalReg_ContactLAB.h"
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
#include "Smartware\phbalReg_Smartware.h"
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

#ifdef NXPBUILD__PHBAL_REG

phStatus_t phbalReg_GetPortList(void * pDataParams, uint16_t wPortBufSize, uint8_t * pPortNames, uint16_t * pNumOfPorts)
{
    phStatus_t PH_MEMLOC_REM status;
#ifdef NXPBUILD__PH_LOG
    uint16_t PH_MEMLOC_REM wCnt;
    uint16_t PH_MEMLOC_REM wLen;
#endif /* NXPBUILD__PH_LOG */

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phbalReg_GetPortList");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wPortBufSize);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pPortNames);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pNumOfPorts);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);

    /* Validate the parameters */
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_BAL);
    PH_ASSERT_NULL_PARAM(pPortNames, PH_COMP_BAL);
    PH_ASSERT_NULL_PARAM(pNumOfPorts, PH_COMP_BAL);

    /* Log the information. */
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wPortBufSize), &wPortBufSize);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    /* Component Code Validation */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_BAL)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
    }

    /* Perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHBAL_REG_STUB
        case PHBAL_REG_STUB_ID:
            status = phbalReg_Stub_GetPortList((phbalReg_Stub_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_STUB */

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
        case PHBAL_REG_SERIALWIN_ID:
            status = phbalReg_SerialWin_GetPortList((phbalReg_SerialWin_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
        case PHBAL_REG_PCSCWIN_ID:
            status = phbalReg_PcscWin_GetPortList((phbalReg_PcscWin_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
        case PHBAL_REG_RD70X_USBWIN_ID:
            status = phbalReg_Rd70xUsbWin_GetPortList((phbalReg_Rd70xUsbWin_DataParams_t*) pDataParams, wPortBufSize,
                pPortNames, pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
        case PHBAL_REG_MP300USB_ID:
            status = phbalReg_Mp300Usb_GetPortList((phbalReg_Mp300Usb_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
        case PHBAL_REG_PIPELIN_ID:
            status = phbalReg_PipeLin_GetPortList((phbalReg_PipeLin_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
        case PHBAL_REG_SOCKETWIN_ID:
            status = phbalReg_SocketWin_GetPortList((phbalReg_SocketWin_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_SAM
        case PHBAL_REG_SAM_ID:
            status = phbalReg_Sam_GetPortList((phbalReg_Sam_DataParams_t*) pDataParams, wPortBufSize, pPortNames, pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
        case PHBAL_REG_RD710_SAM_ID:
            status = phbalReg_Rd710Sam_GetPortList((phbalReg_Rd710Sam_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
        case PHBAL_REG_VISA_ID:
            status = phbalReg_Visa_GetPortList((phbalReg_Visa_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
        case PHBAL_REG_RDFPGAV6_ID:
            status = phbalReg_RdFpgaV6_GetPortList((phbalReg_RdFpgaV6_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
        case PHBAL_REG_PS6000USB_ID:
            status = phbalReg_Ps6000Usb_GetPortList((phbalReg_Ps6000Usb_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
        case PHBAL_REG_MULTISOCKET_ID:
            status = phbalReg_MultiSocket_GetPortList((phbalReg_MultiSocket_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
        case PHBAL_REG_PROXILAB_ID:
            status = phbalReg_ProxiLAB_GetPortList((phbalReg_ProxiLAB_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
        case PHBAL_REG_RDSCR01_ID:
            status = phbalReg_RdScr01_GetPortList((phbalReg_RdScr01_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
        case PHBAL_REG_RDSCR2_ID:
            status = phbalReg_RdScr2_GetPortList((phbalReg_RdScr2_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
        case PHBAL_REG_CONTACTLAB_ID:
            status = phbalReg_ContactLAB_GetPortList((phbalReg_ContactLAB_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
        case PHBAL_REG_SMARTWARE_ID:
            status = phbalReg_Smartware_GetPortList((phbalReg_Smartware_DataParams_t*) pDataParams, wPortBufSize, pPortNames,
                pNumOfPorts);
            break;
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if((status & PH_ERR_MASK) == PH_ERR_SUCCESS)
    {
        for(wCnt = 0; wCnt < *pNumOfPorts; wCnt++)
        {
            wLen = (uint16_t) strlen((char*) pPortNames);
            PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(pPortNames), pPortNames, wLen);
            pPortNames += wLen;
        }
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(pNumOfPorts), pNumOfPorts);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phbalReg_SetPort(void * pDataParams, uint8_t * pPortName)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phbalReg_SetPort");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pPortName);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);

    /* Validate the parameters */
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_BAL);
    PH_ASSERT_NULL_PARAM(pPortName, PH_COMP_BAL);

    /* Log the information. */
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(pPortName), pPortName, (uint16_t) strlen((char*) pPortName));
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    /* Component Code Validation */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_BAL)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
    }

    /* Perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHBAL_REG_STUB
        case PHBAL_REG_STUB_ID:
            status = phbalReg_Stub_SetPort((phbalReg_Stub_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_STUB */

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
        case PHBAL_REG_SERIALWIN_ID:
            status = phbalReg_SerialWin_SetPort((phbalReg_SerialWin_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
        case PHBAL_REG_PCSCWIN_ID:
            status = phbalReg_PcscWin_SetPort((phbalReg_PcscWin_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
        case PHBAL_REG_RD70X_USBWIN_ID:
            status = phbalReg_Rd70xUsbWin_SetPort((phbalReg_Rd70xUsbWin_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
        case PHBAL_REG_MP300USB_ID:
            status = phbalReg_Mp300Usb_SetPort((phbalReg_Mp300Usb_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
        case PHBAL_REG_PIPELIN_ID:
            status = phbalReg_PipeLin_SetPort((phbalReg_PipeLin_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
        case PHBAL_REG_SOCKETWIN_ID:
            status = phbalReg_SocketWin_SetPort((phbalReg_SocketWin_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_SAM
        case PHBAL_REG_SAM_ID:
            status = phbalReg_Sam_SetPort((phbalReg_Sam_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
        case PHBAL_REG_RD710_SAM_ID:
            status = phbalReg_Rd710Sam_SetPort((phbalReg_Rd710Sam_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
        case PHBAL_REG_VISA_ID:
            status = phbalReg_Visa_SetPort((phbalReg_Visa_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
        case PHBAL_REG_RDFPGAV6_ID:
            status = phbalReg_RdFpgaV6_SetPort((phbalReg_RdFpgaV6_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
        case PHBAL_REG_PS6000USB_ID:
            status = phbalReg_Ps6000Usb_SetPort((phbalReg_Ps6000Usb_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
        case PHBAL_REG_MULTISOCKET_ID:
            status = phbalReg_MultiSocket_SetPort((phbalReg_MultiSocket_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
        case PHBAL_REG_PROXILAB_ID:
            status = phbalReg_ProxiLAB_SetPort((phbalReg_ProxiLAB_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
        case PHBAL_REG_RDSCR01_ID:
            status = phbalReg_RdScr01_SetPort((phbalReg_RdScr01_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
        case PHBAL_REG_RDSCR2_ID:
            status = phbalReg_RdScr2_SetPort((phbalReg_RdScr2_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
        case PHBAL_REG_CONTACTLAB_ID:
            status = phbalReg_ContactLAB_SetPort((phbalReg_ContactLAB_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
        case PHBAL_REG_SMARTWARE_ID:
            status = phbalReg_Smartware_SetPort((phbalReg_Smartware_DataParams_t*) pDataParams, pPortName);
            break;
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phbalReg_OpenPort(void * pDataParams)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phbalReg_OpenPort");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);

    /* Validate the parameters */
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_BAL);

    /* Log the information. */
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    /* Component Code Validation */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_BAL)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
    }

    /* Perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHBAL_REG_STUB
        case PHBAL_REG_STUB_ID:
            status = phbalReg_Stub_OpenPort((phbalReg_Stub_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_STUB*/

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
        case PHBAL_REG_SERIALWIN_ID:
            status = phbalReg_SerialWin_OpenPort((phbalReg_SerialWin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
        case PHBAL_REG_PCSCWIN_ID:
            status = phbalReg_PcscWin_OpenPort((phbalReg_PcscWin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
        case PHBAL_REG_RD70X_USBWIN_ID:
            status = phbalReg_Rd70xUsbWin_OpenPort((phbalReg_Rd70xUsbWin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
        case PHBAL_REG_MP300USB_ID:
            status = phbalReg_Mp300Usb_OpenPort((phbalReg_Mp300Usb_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
        case PHBAL_REG_PIPELIN_ID:
            status = phbalReg_PipeLin_OpenPort((phbalReg_PipeLin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
        case PHBAL_REG_SOCKETWIN_ID:
            status = phbalReg_SocketWin_OpenPort((phbalReg_SocketWin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_SAM
        case PHBAL_REG_SAM_ID:
            status = phbalReg_Sam_OpenPort((phbalReg_Sam_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
        case PHBAL_REG_RD710_SAM_ID:
            status = phbalReg_Rd710Sam_OpenPort((phbalReg_Rd710Sam_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
        case PHBAL_REG_VISA_ID:
            status = phbalReg_Visa_OpenPort((phbalReg_Visa_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
        case PHBAL_REG_RDFPGAV6_ID:
            status = phbalReg_RdFpgaV6_OpenPort((phbalReg_RdFpgaV6_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
        case PHBAL_REG_PS6000USB_ID:
            status = phbalReg_Ps6000Usb_OpenPort((phbalReg_Ps6000Usb_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
        case PHBAL_REG_MULTISOCKET_ID:
            status = phbalReg_MultiSocket_OpenPort((phbalReg_MultiSocket_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
        case PHBAL_REG_PROXILAB_ID:
            status = phbalReg_ProxiLAB_OpenPort((phbalReg_ProxiLAB_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
        case PHBAL_REG_RDSCR01_ID:
            status = phbalReg_RdScr01_OpenPort((phbalReg_RdScr01_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
        case PHBAL_REG_RDSCR2_ID:
            status = phbalReg_RdScr2_OpenPort((phbalReg_RdScr2_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
        case PHBAL_REG_CONTACTLAB_ID:
            status = phbalReg_ContactLAB_OpenPort((phbalReg_ContactLAB_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
        case PHBAL_REG_SMARTWARE_ID:
            status = phbalReg_Smartware_OpenPort((phbalReg_Smartware_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phbalReg_ClosePort(void * pDataParams)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phbalReg_ClosePort");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);

    /* Validate the parameters */
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_BAL);

    /* Log the information. */
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    /* Component Code Validation */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_BAL)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
    }

    /* Perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHBAL_REG_STUB
        case PHBAL_REG_STUB_ID:
            status = phbalReg_Stub_ClosePort((phbalReg_Stub_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_STUB */

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
        case PHBAL_REG_SERIALWIN_ID:
            status = phbalReg_SerialWin_ClosePort((phbalReg_SerialWin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
        case PHBAL_REG_PCSCWIN_ID:
            status = phbalReg_PcscWin_ClosePort((phbalReg_PcscWin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
        case PHBAL_REG_RD70X_USBWIN_ID:
            status = phbalReg_Rd70xUsbWin_ClosePort((phbalReg_Rd70xUsbWin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
        case PHBAL_REG_MP300USB_ID:
            status = phbalReg_Mp300Usb_ClosePort((phbalReg_Mp300Usb_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
        case PHBAL_REG_PIPELIN_ID:
            status = phbalReg_PipeLin_ClosePort((phbalReg_PipeLin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
        case PHBAL_REG_SOCKETWIN_ID:
            status = phbalReg_SocketWin_ClosePort((phbalReg_SocketWin_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_SAM
        case PHBAL_REG_SAM_ID:
            status = phbalReg_Sam_ClosePort((phbalReg_Sam_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
        case PHBAL_REG_RD710_SAM_ID:
            status = phbalReg_Rd710Sam_ClosePort((phbalReg_Rd710Sam_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
        case PHBAL_REG_VISA_ID:
            status = phbalReg_Visa_ClosePort((phbalReg_Visa_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
        case PHBAL_REG_RDFPGAV6_ID:
            status = phbalReg_RdFpgaV6_ClosePort((phbalReg_RdFpgaV6_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
        case PHBAL_REG_PS6000USB_ID:
            status = phbalReg_Ps6000Usb_ClosePort((phbalReg_Ps6000Usb_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
        case PHBAL_REG_MULTISOCKET_ID:
            status = phbalReg_MultiSocket_ClosePort((phbalReg_MultiSocket_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
        case PHBAL_REG_PROXILAB_ID:
            status = phbalReg_ProxiLAB_ClosePort((phbalReg_ProxiLAB_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
        case PHBAL_REG_RDSCR01_ID:
            status = phbalReg_RdScr01_ClosePort((phbalReg_RdScr01_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
        case PHBAL_REG_RDSCR2_ID:
            status = phbalReg_RdScr2_ClosePort((phbalReg_RdScr2_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
        case PHBAL_REG_CONTACTLAB_ID:
            status = phbalReg_ContactLAB_ClosePort((phbalReg_ContactLAB_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
        case PHBAL_REG_SMARTWARE_ID:
            status = phbalReg_Smartware_ClosePort((phbalReg_Smartware_DataParams_t*) pDataParams);
            break;
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phbalReg_Exchange(void * pDataParams, uint16_t wOption, uint8_t * pTxBuffer, uint16_t wTxLength, uint16_t wRxBufSize,
    uint8_t * pRxBuffer, uint16_t * pRxLength)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phbalReg_Exchange");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wOption);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pTxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wRxBufSize);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pRxBuffer);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);

    /* Validate the parameters */
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_BAL);
    if(wTxLength)
        PH_ASSERT_NULL_PARAM(pTxBuffer, PH_COMP_BAL);

    /* Log the information. */
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wOption), &wOption);
    PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(pTxBuffer), pTxBuffer, wTxLength);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wRxBufSize), &wRxBufSize);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    /* Component Code Validation */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_BAL)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
    }

    /* Perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHBAL_REG_STUB
        case PHBAL_REG_STUB_ID:
            status = phbalReg_Stub_Exchange((phbalReg_Stub_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength, wRxBufSize,
                pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_STUB */

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
        case PHBAL_REG_SERIALWIN_ID:
            status = phbalReg_SerialWin_Exchange((phbalReg_SerialWin_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
        case PHBAL_REG_PCSCWIN_ID:
            status = phbalReg_PcscWin_Exchange((phbalReg_PcscWin_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
        case PHBAL_REG_RD70X_USBWIN_ID:
            status = phbalReg_Rd70xUsbWin_Exchange((phbalReg_Rd70xUsbWin_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
        case PHBAL_REG_MP300USB_ID:
            status = phbalReg_Mp300Usb_Exchange((phbalReg_Mp300Usb_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
        case PHBAL_REG_PIPELIN_ID:
            status = phbalReg_PipeLin_Exchange((phbalReg_PipeLin_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
        case PHBAL_REG_SOCKETWIN_ID:
            status = phbalReg_SocketWin_Exchange((phbalReg_SocketWin_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_SAM
        case PHBAL_REG_SAM_ID:
            status = phbalReg_Sam_Exchange((phbalReg_Sam_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
        case PHBAL_REG_RD710_SAM_ID:
            status = phbalReg_Rd710Sam_Exchange((phbalReg_Rd710Sam_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
        case PHBAL_REG_VISA_ID:
            status = phbalReg_Visa_Exchange((phbalReg_Visa_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength, wRxBufSize,
                pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
        case PHBAL_REG_RDFPGAV6_ID:
            status = phbalReg_RdFpgaV6_Exchange((phbalReg_RdFpgaV6_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
        case PHBAL_REG_PS6000USB_ID:
            status = phbalReg_Ps6000Usb_Exchange((phbalReg_Ps6000Usb_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
        case PHBAL_REG_MULTISOCKET_ID:
            status = phbalReg_MultiSocket_Exchange((phbalReg_MultiSocket_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
        case PHBAL_REG_PROXILAB_ID:
            status = phbalReg_ProxiLAB_Exchange((phbalReg_ProxiLAB_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
        case PHBAL_REG_RDSCR01_ID:
            status = phbalReg_RdScr01_Exchange((phbalReg_RdScr01_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
        case PHBAL_REG_RDSCR2_ID:
            status = phbalReg_RdScr2_Exchange((phbalReg_RdScr2_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
        case PHBAL_REG_CONTACTLAB_ID:
            status = phbalReg_ContactLAB_Exchange((phbalReg_ContactLAB_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
        case PHBAL_REG_SMARTWARE_ID:
            status = phbalReg_Smartware_Exchange((phbalReg_Smartware_DataParams_t*) pDataParams, wOption, pTxBuffer, wTxLength,
                wRxBufSize, pRxBuffer, pRxLength);
            break;
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
#ifdef NXPBUILD__PH_LOG
    if((((status & PH_ERR_MASK) == PH_ERR_SUCCESS) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_CHAINING) ||
        ((status & PH_ERR_MASK) == PH_ERR_SUCCESS_INCOMPLETE_BYTE))
        &&
        (pRxBuffer != NULL) &&
        (pRxLength != NULL))
    {
        PH_LOG_HELPER_ADDPARAM_BUFFER(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(pRxBuffer), pRxBuffer, *pRxLength);
    }
#endif /* NXPBUILD__PH_LOG */
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return status;
}

phStatus_t phbalReg_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phbalReg_SetConfig");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);

    /* Validate the parameters */
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_BAL);

    /* Log the information. */
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wConfig), &wConfig);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wValue), &wValue);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    /* Component Code Validation */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_BAL)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
    }

    /* Perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHBAL_REG_STUB
        case PHBAL_REG_STUB_ID:
            status = phbalReg_Stub_SetConfig((phbalReg_Stub_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_STUB */

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
        case PHBAL_REG_SERIALWIN_ID:
            status = phbalReg_SerialWin_SetConfig((phbalReg_SerialWin_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
        case PHBAL_REG_PCSCWIN_ID:
            status = phbalReg_PcscWin_SetConfig((phbalReg_PcscWin_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
        case PHBAL_REG_MP300USB_ID:
            status = phbalReg_Mp300Usb_SetConfig((phbalReg_Mp300Usb_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
        case PHBAL_REG_RD70X_USBWIN_ID:
            status = phbalReg_Rd70xUsbWin_SetConfig((phbalReg_Rd70xUsbWin_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
        case PHBAL_REG_PIPELIN_ID:
            status = phbalReg_PipeLin_SetConfig((phbalReg_PipeLin_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
        case PHBAL_REG_SOCKETWIN_ID:
            status = phbalReg_SocketWin_SetConfig((phbalReg_SocketWin_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_SAM
        case PHBAL_REG_SAM_ID:
            status = phbalReg_Sam_SetConfig((phbalReg_Sam_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
        case PHBAL_REG_RD710_SAM_ID:
            status = phbalReg_Rd710Sam_SetConfig((phbalReg_Rd710Sam_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
        case PHBAL_REG_VISA_ID:
            status = phbalReg_Visa_SetConfig((phbalReg_Visa_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
        case PHBAL_REG_RDFPGAV6_ID:
            status = phbalReg_RdFpgaV6_SetConfig((phbalReg_RdFpgaV6_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
        case PHBAL_REG_PS6000USB_ID:
            status = phbalReg_Ps6000Usb_SetConfig((phbalReg_Ps6000Usb_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
        case PHBAL_REG_MULTISOCKET_ID:
            status = phbalReg_MultiSocket_SetConfig((phbalReg_MultiSocket_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
        case PHBAL_REG_PROXILAB_ID:
            status = phbalReg_ProxiLAB_SetConfig((phbalReg_ProxiLAB_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
        case PHBAL_REG_RDSCR01_ID:
            status = phbalReg_RdScr01_SetConfig((phbalReg_RdScr01_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
        case PHBAL_REG_RDSCR2_ID:
            status = phbalReg_RdScr2_SetConfig((phbalReg_RdScr2_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
        case PHBAL_REG_CONTACTLAB_ID:
            status = phbalReg_ContactLAB_SetConfig((phbalReg_ContactLAB_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
        case PHBAL_REG_SMARTWARE_ID:
            status = phbalReg_Smartware_SetConfig((phbalReg_Smartware_DataParams_t*) pDataParams, wConfig, wValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return PH_ADD_COMPCODE(status, PH_COMP_BAL);
}

phStatus_t phbalReg_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phbalReg_GetConfig");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(wConfig);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(pValue);
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);

    /* Validate the parameters */
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_BAL);
    PH_ASSERT_NULL_PARAM(pValue, PH_COMP_BAL);

    /* Log the information. */
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(wConfig), &wConfig);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    /* Component Code Validation */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_BAL)
    {
        status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);

        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return status;
    }

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHBAL_REG_STUB
        case PHBAL_REG_STUB_ID:
            status = phbalReg_Stub_GetConfig((phbalReg_Stub_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_STUB */

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
        case PHBAL_REG_SERIALWIN_ID:
            status = phbalReg_SerialWin_GetConfig((phbalReg_SerialWin_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
        case PHBAL_REG_PCSCWIN_ID:
            status = phbalReg_PcscWin_GetConfig((phbalReg_PcscWin_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
        case PHBAL_REG_MP300USB_ID:
            status = phbalReg_Mp300Usb_GetConfig((phbalReg_Mp300Usb_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
        case PHBAL_REG_RD70X_USBWIN_ID:
            status = phbalReg_Rd70xUsbWin_GetConfig((phbalReg_Rd70xUsbWin_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
        case PHBAL_REG_PIPELIN_ID:
            status = phbalReg_PipeLin_GetConfig((phbalReg_PipeLin_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
        case PHBAL_REG_SOCKETWIN_ID:
            status = phbalReg_SocketWin_GetConfig((phbalReg_SocketWin_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_SAM
        case PHBAL_REG_SAM_ID:
            status = phbalReg_Sam_GetConfig((phbalReg_Sam_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
        case PHBAL_REG_RD710_SAM_ID:
            status = phbalReg_Rd710Sam_GetConfig((phbalReg_Rd710Sam_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
        case PHBAL_REG_VISA_ID:
            status = phbalReg_Visa_GetConfig((phbalReg_Visa_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
        case PHBAL_REG_RDFPGAV6_ID:
            status = phbalReg_RdFpgaV6_GetConfig((phbalReg_RdFpgaV6_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
        case PHBAL_REG_PS6000USB_ID:
            status = phbalReg_Ps6000Usb_GetConfig((phbalReg_Ps6000Usb_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
        case PHBAL_REG_MULTISOCKET_ID:
            status = phbalReg_MultiSocket_GetConfig((phbalReg_MultiSocket_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
        case PHBAL_REG_PROXILAB_ID:
            status = phbalReg_ProxiLAB_GetConfig((phbalReg_ProxiLAB_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
        case PHBAL_REG_RDSCR01_ID:
            status = phbalReg_RdScr01_GetConfig((phbalReg_RdScr01_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
        case PHBAL_REG_RDSCR2_ID:
            status = phbalReg_RdScr2_GetConfig((phbalReg_RdScr2_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
        case PHBAL_REG_CONTACTLAB_ID:
            status = phbalReg_ContactLAB_GetConfig((phbalReg_ContactLAB_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
        case PHBAL_REG_SMARTWARE_ID:
            status = phbalReg_Smartware_GetConfig((phbalReg_Smartware_DataParams_t*) pDataParams, wConfig, pValue);
            break;
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_DEBUG, PH_LOG_VAR(pValue), pValue);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return PH_ADD_COMPCODE(status, PH_COMP_BAL);
}

phStatus_t phbalReg_RegisterCallback(void * pDataParams, TySocketWinCallback pCallback)
{
    phStatus_t PH_MEMLOC_REM status;

    PH_LOG_HELPER_ALLOCATE_TEXT(bFunctionName, "phbalReg_RegisterCallback");
    PH_LOG_HELPER_ALLOCATE_PARAMNAME(status);

    /* Validate the parameters */
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_BAL);

    /* Log the information. */
    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_ENTER);

    /* Component Code Validation */
    if(PH_GET_COMPCODE(pDataParams) != PH_COMP_BAL)
    {
        PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
        PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
        PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
    }

    /* Perform operation on active layer */
    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHBAL_REG_STUB
        case PHBAL_REG_STUB_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_STUB */

#ifdef NXPBUILD__PHBAL_REG_SERIALWIN
        case PHBAL_REG_SERIALWIN_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_SERIALWIN */

#ifdef NXPBUILD__PHBAL_REG_PCSCWIN
        case PHBAL_REG_PCSCWIN_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_PCSCWIN */

#ifdef NXPBUILD__PHBAL_REG_MP300USB
        case PHBAL_REG_MP300USB_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_MP300USB */

#ifdef NXPBUILD__PHBAL_REG_RD70XUSBWIN
        case PHBAL_REG_RD70X_USBWIN_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD70XUSBWIN */

#ifdef NXPBUILD__PHBAL_REG_PIPELIN
        case PHBAL_REG_PIPELIN_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_PIPELIN */

#ifdef NXPBUILD__PHBAL_REG_SOCKETWIN
        case PHBAL_REG_SOCKETWIN_ID:
            status = phbalReg_SocketWin_RegisterCallback((phbalReg_SocketWin_DataParams_t *) pDataParams, pCallback);
            break;
#endif /* NXPBUILD__PHBAL_REG_SOCKETWIN */

#ifdef NXPBUILD__PHBAL_REG_SAM
        case PHBAL_REG_SAM_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_SAM */

#ifdef NXPBUILD__PHBAL_REG_RD710SAM
        case PHBAL_REG_RD710_SAM_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_RD710SAM */

#ifdef NXPBUILD__PHBAL_REG_VISA
        case PHBAL_REG_VISA_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_VISA */

#ifdef NXPBUILD__PHBAL_REG_RDFPGAV6
        case PHBAL_REG_RDFPGAV6_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDFPGAV6 */

#ifdef NXPBUILD__PHBAL_REG_PS6000USB
        case PHBAL_REG_PS6000USB_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_PS6000USB */

#ifdef NXPBUILD__PHBAL_REG_MULTISOCKET
        case PHBAL_REG_MULTISOCKET_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_MULTISOCKET */

#ifdef NXPBUILD__PHBAL_REG_PROXILAB
        case PHBAL_REG_PROXILAB_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_PROXILAB */

#ifdef NXPBUILD__PHBAL_REG_RDSCR01
        case PHBAL_REG_RDSCR01_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR01 */

#ifdef NXPBUILD__PHBAL_REG_RDSCR2
        case PHBAL_REG_RDSCR2_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */

#ifdef NXPBUILD__PHBAL_REG_CONTACTLAB
        case PHBAL_REG_CONTACTLAB_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_CONTACTLAB */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE
        case PHBAL_REG_SMARTWARE_ID:
            status = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_BAL);
            break;
#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */

        default:
            status = PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_BAL);
            break;
    }

    PH_LOG_HELPER_ADDSTRING(PH_LOG_LOGTYPE_INFO, bFunctionName);
    PH_LOG_HELPER_ADDPARAM_UINT16(PH_LOG_LOGTYPE_INFO, PH_LOG_VAR(status), &status);
    PH_LOG_HELPER_EXECUTE(PH_LOG_OPTION_CATEGORY_LEAVE);

    return PH_ADD_COMPCODE(status, PH_COMP_BAL);
}

#endif /* NXPBUILD__PHBAL_REG */
