/*
 * Copyright 2013, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * VISA BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_VISA_INT_H
#define PHBALREG_VISA_INT_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_Visa_Ex_LoadFunctions(
    phbalReg_Visa_DataParams_t * pDataParams
    );

phStatus_t phbalReg_Visa_Ex_UnLoadFunctions(
    phbalReg_Visa_DataParams_t * pDataParams
    );

/* define the dll that has to be loaded */
#define	PHBAL_REG_VISA_INT_DLL_NAME                  "visa32.dll"

/* define the function names that have to be loaded */
#define	PHBAL_REG_VISA_INT_OPEN_DEFAULT_RM_FNAME    "viOpenDefaultRM"
#define	PHBAL_REG_VISA_INT_OPEN_FNAME               "viOpen"
#define	PHBAL_REG_VISA_INT_CLOSE_FNAME              "viClose"
#define	PHBAL_REG_VISA_INT_FIND_RSRC_FNAME          "viFindRsrc"
#define	PHBAL_REG_VISA_INT_FIND_NEXT_FNAME          "viFindNext"
#define	PHBAL_REG_VISA_INT_READ_FNAME               "viRead"
#define	PHBAL_REG_VISA_INT_WRITE_FNAME              "viWrite"
#define	PHBAL_REG_VISA_INT_SET_ATTRIBUTE_FNAME      "viSetAttribute"
#define	PHBAL_REG_VISA_INT_GET_ATTRIBUTE_FNAME      "viGetAttribute"

#endif /* PHBALREG_VISA_INT_H */
