/*
 * Copyright 2013, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * VISA BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHBAL_REG_VISA

#include "../phbalReg_Visa.h"
#include "phbalReg_Visa_Ex.h"

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4001)           /* PRQA S 3116 */
#define NIVISA_USB
#include "visa.h"
#pragma warning(pop)                    /* PRQA S 3116 */

#ifdef _WIN32

#include <string.h>
#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4200)           /* PRQA S 3116 */
#pragma warning(disable:4201)           /* PRQA S 3116 */
#include <windows.h>
#pragma warning(pop)                    /* PRQA S 3116 */

#endif
phStatus_t phbalReg_Visa_Ex_LoadFunctions(
    phbalReg_Visa_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    /* load library */
    pDataParams->pHandle = LoadLibrary(PHBAL_REG_VISA_INT_DLL_NAME);

    /* check if loading succeded */
    if (pDataParams->pHandle == NULL)
    {
        /* failed to load the visa32.dll */
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    /* get all function pointers */
    pDataParams->pviOpenDefaultRM = (PHBAL_REG_VISA_OPEN_DEFAULT_RM)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_OPEN_DEFAULT_RM_FNAME);
    if (pDataParams->pviOpenDefaultRM == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pviOpen = (PHBAL_REG_VISA_OPEN)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_OPEN_FNAME);
    if (pDataParams->pviOpen == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pviClose = (PHBAL_REG_VISA_CLOSE)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_CLOSE_FNAME);
    if (pDataParams->pviClose == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pviFindRsrc = (PHBAL_REG_VISA_FIND_RSRC)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_FIND_RSRC_FNAME);
    if (pDataParams->pviFindRsrc == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pviFindNext = (PHBAL_REG_VISA_FIND_NEXT)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_FIND_NEXT_FNAME);
    if (pDataParams->pviFindNext == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pviRead = (PHBAL_REG_VISA_READ)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_READ_FNAME);
    if (pDataParams->pviRead == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pviWrite = (PHBAL_REG_VISA_WRITE)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_WRITE_FNAME);
    if (pDataParams->pviWrite == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pviSetAttribute = (PHBAL_REG_VISA_SET_ATTRIBUTE)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_SET_ATTRIBUTE_FNAME);
    if (pDataParams->pviSetAttribute == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    pDataParams->pviGetAttribute = (PHBAL_REG_VISA_GET_ATTRIBUTE)GetProcAddress((HMODULE)pDataParams->pHandle, PHBAL_REG_VISA_INT_GET_ATTRIBUTE_FNAME);
    if (pDataParams->pviGetAttribute == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

phStatus_t phbalReg_Visa_Ex_UnLoadFunctions(
    phbalReg_Visa_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    uint8_t bResult;

    /* check if the library is loaded */
    if (pDataParams->pHandle != NULL)
    {
        /* unload the library */
        bResult = (uint8_t)FreeLibrary((HMODULE)pDataParams->pHandle);

        /* check the success of the command */
        if (bResult == PH_OFF)
        {
            return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
        }

        /* set all function pointers to NULL */
        pDataParams->pviOpenDefaultRM = NULL;
        pDataParams->pviOpen = NULL;
        pDataParams->pviClose = NULL;
        pDataParams->pviFindRsrc = NULL;
        pDataParams->pviFindNext = NULL;
        pDataParams->pviRead = NULL;
        pDataParams->pviWrite = NULL;
        pDataParams->pviSetAttribute = NULL;
        pDataParams->pviGetAttribute = NULL;

        /* set the handle to NULL */
        pDataParams->pHandle = NULL;
        /* return success */
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

#endif /* NXPBUILD__PHBAL_REG_VISA */
