/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal FPGA Box BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#pragma once
#ifndef PHBALREG_SMARTWARE_INT_H
#define PHBALREG_SMARTWARE_INT_H

#include <ph_Status.h>
#include <phbalReg.h>

#ifdef __cplusplus
extern "C" {
#endif

phStatus_t phbalReg_Smartware_Int_StartReader(
                                             phbalReg_Smartware_DataParams_t * pDataParams
                                             );

phStatus_t phbalReg_Smartware_Int_StopReader(
                                             phbalReg_Smartware_DataParams_t * pDataParams
                                             );

phStatus_t phbalReg_Smartware_Int_ConvertError(
                                               phbalReg_Smartware_DataParams_t * pDataParams,
                                               uint32_t error
                                               );

phStatus_t phbalReg_Smartware_Int_CheckInternalBuffers(
                                                       phbalReg_Smartware_DataParams_t * pDataParams
                                                       );

#ifdef __cplusplus
}
#endif
#endif /* PHBALREG_SMARTWARE_INT_H */
