/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal FPGA BOX BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>
#include <phTools.h>
#include <stdio.h>              /* PRQA S 5124 */

#ifdef NXPBUILD__PHBAL_REG_SMARTWARE

#include "phbalReg_Smartware_Int.h"

#include "../../../phHalHwContact/src/ContactSmartware/ex/CARD/card.h"
#include "../../../phHalHwContact/src/ContactSmartware/ex/CARDTM/cardtm.h"
#include "../../../phHalHwContact/src/ContactSmartware/ex/CMT/cmt.H"
#include "../../../phHalHwContact/src/ContactSmartware/ex/MLOS/mloscfg.h"

err_Type MlosPrint(char * St)
{
    FILE * fh = fopen(".\\smartware.log", "a");
    fprintf(fh, "%s", St);
    fclose(fh);
    return err__Ok;
}

phStatus_t phbalReg_Smartware_Int_StartReader(
                                              phbalReg_Smartware_DataParams_t * pDataParams
                                              )
{
    phStatus_t statusTmp;
    mloscfg_Type  * Cfg;
    card_Ref Card;

    Cfg = (mloscfg_Type *)pDataParams->MlosCfgBuffer;
    Card = (card_Ref)pDataParams->CardBuffer;

    Cfg->Mode = mloscfg_ModeMaskV2r24;
    PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_Smartware_Int_ConvertError(pDataParams, pDataParams->pfMlosCfgInit(Cfg)));
    PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_Smartware_Int_ConvertError(pDataParams, pDataParams->pfMlosCfgStart(Cfg)));

    PH_CHECK_SUCCESS_FCT(statusTmp, phTools_Sleep(1000));
    PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_Smartware_Int_ConvertError(pDataParams,
        pDataParams->pfCardOpen(Card, card_ModelC7816_3, (card_NOType)((1 << 8) + sys_Cd1Id))));

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_Smartware_Int_StopReader(
                                             phbalReg_Smartware_DataParams_t * pDataParams
                                             )
{
    phStatus_t statusTmp;
    mloscfg_Type * Cfg = (mloscfg_Type *)pDataParams->MlosCfgBuffer;

    /* Maybe function pointers already unloaded */
    if(pDataParams->pfMlosCfgEnd != NULL)
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_Smartware_Int_ConvertError(pDataParams, pDataParams->pfMlosCfgEnd(Cfg)));
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

phStatus_t phbalReg_Smartware_Int_ConvertError(
                                               phbalReg_Smartware_DataParams_t * pDataParams,
                                               uint32_t error
                                               )
{
    phStatus_t convertedStatus;

    /* to satisfy compiler for now */
    if(pDataParams);

    switch(error)
    {
    case err__Ok:
        convertedStatus = PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
        break;

    default:
        convertedStatus = PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_BAL);
        break;
    }

    return convertedStatus;
}

phStatus_t phbalReg_Smartware_Int_CheckInternalBuffers(
                                                       phbalReg_Smartware_DataParams_t * pDataParams
                                                       )
{
    uint8_t bufferOverflowCfg = sizeof(pDataParams->MlosCfgBuffer) < sizeof(mloscfg_Type);
    uint8_t bufferOverflowCard = sizeof(pDataParams->CardBuffer) < sizeof(card_Type);

    if(bufferOverflowCfg || bufferOverflowCard)
    {
        return PH_ADD_COMPCODE(PH_ERR_BUFFER_OVERFLOW, PH_COMP_BAL);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }
}

#endif /* NXPBUILD__PHBAL_REG_SMARTWARE */
