/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SAM (Secure Access Module) internal implementation via TDA interface for Reader Library
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  Rajendran Kumar: Generated 08. Feb 2024
 *
 */

#ifndef PHBALREG_SAM_TDA_H
#define PHBALREG_SAM_TDA_H

#include <ph_Status.h>
#include <phbalReg.h>

#ifdef NXPBUILD__PHBAL_REG_SAM

#define PHBAL_SAM_CMD_READER_OPERATION          0xA0U
#define PHBAL_SAM_CMD_COMMUNICATION_TDA         0x80U
#define PHBAL_SAM_CONFIG_RD_OPS_SET_PCSC_MODE   0x0DU   /**< PCSC mode: Standard (0x00) or Direct (0x01). Only applicable for Pegoda 2 reader. */

#define PHBAL_SAM_CMD_ACTIVATE                  0x01U
#define PHBAL_SAM_CMD_COLD_RESET                0x02U
#define PHBAL_SAM_CMD_DEACTIVATE                0x06U
#define PHBAL_SAM_CMD_TRANSMIT_DATA             0x08U
#define PHBAL_SAM_CMD_SEND_PPS                  0x09U

phStatus_t phbalReg_Sam_Int_Exchange_TDA(phbalReg_Sam_DataParams_t * pDataParams, uint8_t bCommType, uint8_t bCmd, uint8_t * pData,
    uint16_t wDataLen, uint8_t ** ppResponse, uint16_t * pRspLen);

phStatus_t phbalReg_Sam_ActivateSam_TDA(phbalReg_Sam_DataParams_t * pDataParams);

phStatus_t phbalReg_Sam_Pps_TDA(phbalReg_Sam_DataParams_t * pDataParams);

phStatus_t phbalReg_Sam_DeActivateSam_TDA(phbalReg_Sam_DataParams_t * pDataParams);

phStatus_t phbalReg_Sam_TransmitData_TDA(phbalReg_Sam_DataParams_t * pDataParams, uint8_t * pTxBuffer, uint16_t wTxBufLen,
    uint16_t wRxBufSize, uint8_t * pRxBuffer, uint16_t * pRxBufLen);

#endif /* NXPBUILD__PHBAL_REG_SAM */

#endif /* PHBALREG_SAM_TDA_H */
