/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal FPGA BOX BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHBAL_REG_RDSCR2

#include "phbalReg_RdScr2_Int.h"

typedef struct _FiDi_t
{
    uint32_t    br;
    uint8_t     fi;
    uint8_t     di;
} FiDi_t;

static const FiDi_t gFiDi_5Mhz[] =
{
    {   9600, 0x01, 0x01 },
    {  19200, 0x01, 0x02 },
    {  38400, 0x01, 0x03 },
    { 115200, 0x01, 0x08 }
};

phStatus_t phbalReg_RdScr2_Int_ConvertError(
                                             uint32_t status
                                             )
{
    switch (status)
    {
    case SCR2_OK:
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);

    case SCR2_E_INITIALIZE:
        return PH_ADD_COMPCODE(PH_ERR_IO_TIMEOUT, PH_COMP_BAL);

    case SCR2_E_ENUMERATE :
    case SCR2_E_SHAREDMEMORY:
    case SCR2_E_SERIAL_ERROR:
    case SCR2_E_READER_NOT_FOUND:
    case SCR2_E_SERIAL_NOT_FOUND:
    case SCR2_E_NOT_INITIALIZED:
    case SCR2_E_ALREADY_INITIALIZED:
    case SCR2_E_READ_REGISTER:
    case SCR2_E_WRITE_REGISTER:
    case SCR2_E_READ_MEMORY:
    case SCR2_E_WRITE_MEMORY:
    case SCR2_E_SET_TIMEOUT:
    case SCR2_E_TSENS_NOT_ENABLED:
    case SCR2_E_TSENS_ERROR:
    case SCR2_E_PARAM_ERROR:
    case SCR2_E_CONTROL_IO_PORTS:
    case SCR2_E_FATALERROR:
    case SCR2_E_EXCEPTION:
    case SCR2_E_TRACEERROR:
    case SCR2_E_TRACEINCONSISTENT:
    case SCR2_E_TRACEFILE:
    case SCR2_E_LOGGERISACTIVE:
    case SCR2_E_LOGGERNOTSTARTED:
    case SCR2_E_LOGGERNOTSTOPPED:
    case SCR2_E_LOGGEROVERFLOW:
    case SCR2_E_GENERALHCIERROR:
    case SCR2_E_CONTROL_TRAPDOOR:
    case SCR2_E_FEATURENOTSUPPORTED:
    case SCR2_E_PORTNOTAVAILABLE:
    case SCR2_E_COMMIFNOTENABLED:
    case SCR2_E_COMMIFNOTSELECTED:
    case SCR2_E_DUALIFNOTSELECTED:
    case SCR2_E_WRONG_VTP_VALUE:
    case SCR2_E_COMMIF1NOTAVAILABLE:
    case SCR2_E_COMMIF2NOTAVAILABLE:
    case SCR2_E_GTKWFILE:
    case SCR2_E_SUPPORT_DLL_NOT_FOUND:
    case SCR2_E_TRIM_WRITE:
    case SCR2_E_MEASUREMENT_DISABLED:
    case SCR2_E_DISPLAYSTRING_TOO_LONG:
    case SCR2_E_WRONG_VCC_VALUE:
    case SCR2_E_CLOCK1_ERROR:
    case SCR2_E_CLOCK2_ERROR:
    case SCR2_E_ABORTED_BY_USER:
    case SCR2_E_MEMORY_ALLOCATION_FAILED:
    case SCR2_E_LOGFILE_ERROR:
    case SCR2_E_LOGFILE_NOT_OPEN:
    case SCR2_E_TRIGGERPORTNOTAVAILABLE:
    case SCR2_E_IDENT_CRC_ERROR:
    case SCR2_E_IDENT_NOT_FOUND:
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_BAL);

    default:
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_BAL);
    }
}

phStatus_t phbalReg_RdScr2_Int_SetBitRate(
                                           phbalReg_RdScr2_DataParams_t * pDataParams,
                                           uint32_t bitrate
                                           )
{
    phStatus_t statusTmp;
    FiDi_t *pFiDi = NULL;
    uint8_t i;

    for (i = 0; i < sizeof(gFiDi_5Mhz)/sizeof(gFiDi_5Mhz[0]); i++)
    {
        if (gFiDi_5Mhz[i].br == bitrate)
        {
            pFiDi = (FiDi_t *)&gFiDi_5Mhz[i];
            break;
        }
    }

    if (pFiDi != NULL)
    {
        PH_CHECK_SUCCESS_FCT(statusTmp, phbalReg_RdScr2_Int_ConvertError(pDataParams->pf7816SetParameter(SCR2_ISO7816_FIDI, ((pFiDi->fi << 4) & 0xF0)|(pFiDi->di & 0x0F))));
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_BAL);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
}

#endif /* NXPBUILD__PHBAL_REG_RDSCR2 */
