/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * RDFPGA BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_RDSCR2_EX_H
#define PHBALREG_RDSCR2_EX_H

#include <ph_Status.h>
#include <phbalReg.h>

phStatus_t phbalReg_RdScr2_Ex_LoadFunctions(
                                             phbalReg_RdScr2_DataParams_t * pDataParams
                                             );

phStatus_t phbalReg_RdScr2_Ex_UnLoadFunctions(
                                               phbalReg_RdScr2_DataParams_t * pDataParams
                                               );

/* define the dll that has to be loaded */
#define PHBAL_REG_RDSCR2_EX_DLL_NAME                           "scr2_dll_x86.dll"

/* define the function names that have to be loaded */
#define PHBAL_REG_RDSCR2_EX_ENUMERATE                          "scr2_enumerate"
#define PHBAL_REG_RDSCR2_EX_INIT                               "scr2_initialize"
#define PHBAL_REG_RDSCR2_EX_CLOSE                              "scr2_close"
#define PHBAL_REG_RDSCR2_EX_SLEEP                              "scr2_hal_sleep"

#define PHBAL_REG_RDSCR2_EX_ISO7816_SET_PARAMETER              "scr2_iso7816_set_parameter"
#define PHBAL_REG_RDSCR2_EX_ISO7816_RAW_EXCHANGE               "scr2_iso7816_raw_exchange"
#define PHBAL_REG_RDSCR2_EX_ISO7816_RAW_ACTIVATE               "scr2_iso7816_raw_activate"

#define PHBAL_REG_RDSCR2_EX_CONTROL_IO_PORT                    "scr2_control_io_port"
#define PHBAL_REG_RDSCR2_EX_SET_VCC                            "scr2_set_vcc"
#define PHBAL_REG_RDSCR2_EX_POWEROFF_RESET                     "scr2_poweroff_reset"

#define PHBAL_REG_RDSCR2_EX_ISO7816_ACTIVATE                   "scr2_iso7816_protocol_activate"
#define PHBAL_REG_RDSCR2_EX_ISO7816_DEACTIVATE                 "scr2_iso7816_protocol_deactivate"
#define PHBAL_REG_RDSCR2_EX_ISO7816_GETATR                     "scr2_iso7816_get_atr"
#define PHBAL_REG_RDSCR2_EX_ISO7816_EXCHANGE                   "scr2_iso7816_protocol_exchange"
#define PHBAL_REG_RDSCR2_EX_ISO7816_GET_PARAMETER              "scr2_iso7816_get_parameter"

#define PHBAL_REG_RDSCR2_EX_I2C_SET_SLAVE_PARAMETER            "scr2_i2cslave_set_parameter"
#define PHBAL_REG_RDSCR2_EX_SET_COMMIF_CONFIG                  "scr2_set_commif_configuration"
#define PHBAL_REG_RDSCR2_EX_I2C_SEND_DATA                      "scr2_rawi2c_send_data"
#define PHBAL_REG_RDSCR2_EX_I2C_READ_DATA                      "scr2_rawi2c_read_data"
#define PHBAL_REG_RDSCR2_EX_I2C_SET_PARAMETER                  "scr2_rawi2c_set_parameter"

#define PHBAL_REG_RDSCR2_EX_SPI_SET_PARAMETER                   "scr2_t1spi_set_parameter"
#define PHBAL_REG_RDSCR2_EX_SPI_GET_PARAMETER                   "scr2_t1spi_get_parameter"
#define PHBAL_REG_RDSCR2_EX_SPI_PROTOCOL_ACTIVATE               "scr2_t1spi_protocol_activate"
#define PHBAL_REG_RDSCR2_EX_SPI_PROTOCOL_DEACTIVATE             "scr2_t1spi_protocol_deactivate"
#define PHBAL_REG_RDSCR2_EX_SPI_PROTOCOL_EXCHANGE               "scr2_t1spi_protocol_exchange"
#define PHBAL_REG_RDSCR2_EX_SPI_RAW_EXCHANGE                    "scr2_t1spi_raw_exchange"
#define PHBAL_REG_RDSCR2_EX_SPI_RAW_SEND                        "scr2_t1spi_raw_send"
#define PHBAL_REG_RDSCR2_EX_SPI_RAW_READ                        "scr2_t1spi_raw_read"

#define PHBAL_REG_RDSCR2_EX_TRIGGER_SET_PORT1                   "scr2_trigger_set_port1"
#define PHBAL_REG_RDSCR2_EX_TRIGGER_SET_PORT2                   "scr2_trigger_set_port2"
#define PHBAL_REG_RDSCR2_EX_TRIGGER_SET_ICC_VALUE               "scr2_trigger_set_iccvalue"
#define PHBAL_REG_RDSCR2_EX_TRIGGER_SET_VTP_VALUE               "scr2_trigger_set_vtpvalue"
#define PHBAL_REG_RDSCR2_EX_TRIGGER_SET_HW_INTERFACE_WAIT1      "scr2_trigger_set_hw_interface_wait1"
#define PHBAL_REG_RDSCR2_EX_TRIGGER_SET_HW_INTERFACE_WAIT2      "scr2_trigger_set_hw_interface_wait2"

#define PHBAL_REG_RDSCR2_EX_TDA_CLEAR_TRIGGERS                  "scr2_tda_clear_triggers"
#define PHBAL_REG_RDSCR2_EX_TDA_SET_TRIGGER                     "scr2_tda_set_trigger"
#define PHBAL_REG_RDSCR2_EX_TDA_START                           "scr2_tda_start"
#define PHBAL_REG_RDSCR2_EX_TDA_STOP                            "scr2_tda_stop"
#define PHBAL_REG_RDSCR2_EX_TDA_GET_STATUS                      "scr2_tda_get_status"

#define PHBAL_REG_RDSCR2_EX_EXTI2C_ENABLED                      "scr2_exti2c_enable"

#endif /* PHBALREG_RDSCR2_EX_H */
