/*
 * Copyright 2017, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PS6000USB BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHBAL_REG_PS6000USB

#include "phbalReg_Ps6000Usb_Int.h"

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4001)           /* PRQA S 3116 */
#include "../../../phbalReg/src/Ps6000Usb/external/picoStatus.h"
#pragma warning(pop)                    /* PRQA S 3116 */

/* TODO: adapt to PicoScope Errors! */
phStatus_t phbalReg_Ps6000Usb_Int_ConvertError(phbalReg_Ps6000Usb_DataParams_t * pDataParams,
                                              int32_t status)
{
    switch (status)
    {
    case PICO_OK:
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);

    case PICO_NOT_FOUND:
    case PICO_NOT_RESPONDING:
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_BAL);

    case PICO_OS_NOT_SUPPORTED:
    case PICO_OPEN_OPERATION_IN_PROGRESS:
    case PICO_KERNEL_DRIVER_TOO_OLD:
    case PICO_EEPROM_CORRUPT:
    case PICO_FW_FAIL:
    case PICO_MEMORY_FAIL:
    case PICO_ANALOG_BOARD:
    case PICO_CONFIG_FAIL_AWG:
    case PICO_INITIALISE_FPGA:
    case PICO_MAX_UNITS_OPENED:
    default:
        pDataParams->dwAdditionalInfo = status;
        return PH_ADD_COMPCODE(PHBAL_REG_ERR_DLL, PH_COMP_BAL);
    }
}

#endif /* NXPBUILD__PHBAL_REG_PS6000USB */
