/*
 * Copyright 2013 - 2014, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PipeLinux specific BAL-Component of Reader Library Framework.
 * $RCSfile $
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHBALREG_PIPELIN_INT_H
#define PHBALREG_PIPELIN_INT_H

#include <ph_Status.h>

#ifndef _WIN32
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>              /* PRQA S 5124 */
#else
#pragma warning(push)           /* PRQA S 3116 */
#pragma warning(disable:4001)   /* PRQA S 3116 */
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>              /* PRQA S 5124 */
#pragma warning(pop)            /* PRQA S 3116 */
#endif

/** \addtogroup ph_Private
* @{
*/

#define PHBAL_REG_PIPELIN_RX_PIPENAME_DEFAULT   "NCSIM2NUNIT.FIFO"  /**< Default Rx-Pipename for NcSim connection. */
#define PHBAL_REG_PIPELIN_TX_PIPENAME_DEFAULT   "NUNIT2NCSIM.FIFO"  /**< Default Tx-Pipename for NcSim connection. */
#define FNULL   (FILE *) NULL

#define PHBAL_REG_PIPELIN_ACK_RX    "ACK"   /**< ACK string on Rx from NcSim. */

void phbalReg_PipeLin_Removechar(
                                 uint8_t * pStr,
                                 uint8_t Ch
                                 );

phStatus_t phbalReg_PipeLin_HexToString(
                                        uint8_t * pHex,
                                        uint16_t wHexLength,
                                        uint16_t wStringSize,
                                        uint8_t * pString
                                        );

phStatus_t phbalReg_PipeLin_StringToHex(
                                        uint8_t * pString,
                                        uint16_t * pNewLength
                                        );

/** @}
* end of ph_Private group
*/

#endif /* PHBALREG_PIPELIN_INT_H */
