/*
 * Copyright 2019, 2022, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * BAL MultiSocket Internal Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>

#ifndef PHBALREG_MULTISOCKET_INT_H
#define PHBALREG_MULTISOCKET_INT_H

#ifdef _WIN32
#pragma warning(push)               /* PRQA S 3116 */
#pragma warning(disable:4001)       /* PRQA S 3116 */
#include <winsock2.h>               /* winsock has to be included first! */
#include <windows.h>
#include <ws2tcpip.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>                  /* PRQA S 5124 */
#pragma warning(pop)                /* PRQA S 3116 */
#pragma comment(lib, "ws2_32.lib")  /* PRQA S 3116 */
#else
#include <sys/socket.h>             /* Socket */
#include <netinet/in.h>             /* sockaddr_in struct */
#include <arpa/inet.h>              /* inet_addr struct */
#include <netdb.h>                  /* hostent struct */
#include <errno.h>                  /* Error codes */
#include <unistd.h>                 /* close() */
#endif

#define PHBAL_REG_MULTISOCKET_TX_TIMEOUT_DEFAULT    10000  /* Timeout in milliseconds for send() */
#define PHBAL_REG_MULTISOCKET_RX_TIMEOUT_DEFAULT    10000  /* Timeout in milliseconds for recv() */

phStatus_t phbalReg_MultiSocket_Int_Send(
    phbalReg_MultiSocket_DataParams_t * pParams,
    uint8_t * pbTxBuffer,
    uint16_t wTxSizeBytes
    );

phStatus_t phbalReg_MultiSocket_Int_Recv(
    phbalReg_MultiSocket_DataParams_t * pDataParams,
    uint8_t * pbRxBuffer,
    uint32_t dwBufferSizeBytes
    );

phStatus_t phbalReg_Int_ParseWindowsError(
    uint32_t dwWinErrorCode
    );

phStatus_t phbalReg_MultiSocket_Int_OpenSendPort(
    phbalReg_MultiSocket_DataParams_t * pDataParams
    );

phStatus_t phbalReg_MultiSocket_Int_OpenRecvPort(
    phbalReg_MultiSocket_DataParams_t * pDataParams
    );

phStatus_t phbalReg_MultiSocket_Int_CloseSendPort(
    phbalReg_MultiSocket_DataParams_t * pDataParams
    );

phStatus_t phbalReg_MultiSocket_Int_CloseRecvPort(
    phbalReg_MultiSocket_DataParams_t * pDataParams
    );

#endif /* PHBALREG_MULTISOCKET_INT_H */
