/*
 * Copyright 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * BAL MultiSocket Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>

#ifndef PHBALREG_MULTISOCKET_H
#define PHBALREG_MULTISOCKET_H

/* \brief This command is not supported
*
*/
phStatus_t phbalReg_MultiSocket_GetPortList(
    phbalReg_MultiSocket_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wPortBufSize,                              /**< [In] Buffer Size of Port Name String. */
    uint8_t * pPortNames,                               /**< [Out] Port Name as Multi-String. */
    uint16_t * pNumOfPorts                              /**< [Out] Number of found port strings. */
    );

/**
* \brief Select Port to be used.
*
* <em>Example SerialWin:</em> The caller has to ensure that \c pPortName
* is valid throughout the whole lifetime of \c pDataParams.\n
* The \c pPortName must have the form "<ipAddress>\0<sendPort>\0<recvPort>\0"!
* \b Example:
\code
bal.SetPort("10.0.2.15" + "\0" + "22221" + "\0" + "22223" + "\0");          <-- correct
bal.SetPort("10.0.2.15" + "\0" + "22220" + "\0" + "22220" + "\0");          <-- correct
bal.SetPort("10.0.2.15" + "22221" + "22223" + "\0");                        <-- wrong
bal.SetPort("10.0.2.15" + "\0" + "22220" + "\0");                           <-- wrong
\endcode
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
*/
phStatus_t phbalReg_MultiSocket_SetPort(
    phbalReg_MultiSocket_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
    uint8_t * pPortName                                 /**< [In] Port Name as String. */
    );

/**
* \brief Open communication port(s).
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval #PH_ERR_USE_CONDITION Communication port is already open.
* \retval #PH_ERR_INTERFACE_ERROR Error while opening port.
*/
phStatus_t phbalReg_MultiSocket_OpenPort(
    phbalReg_MultiSocket_DataParams_t * pDataParams     /**< [In] Pointer to this layer's parameter structure. */
    );

/**
* \brief Close communication port.
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval #PH_ERR_USE_CONDITION Communication port is not open.
* \retval #PH_ERR_INTERFACE_ERROR Error while closing port.
*/
phStatus_t phbalReg_MultiSocket_ClosePort(
    phbalReg_MultiSocket_DataParams_t * pDataParams     /**< [In] Pointer to this layer's parameter structure. */
    );

/**
* \brief Perform Data Exchange on the bus.
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval #PH_ERR_INVALID_PARAMETER \b wOption is invalid.
* \retval #PH_ERR_IO_TIMEOUT No response received within given time frame.
* \retval #PH_ERR_INTERFACE_ERROR Communication error.
*/
phStatus_t phbalReg_MultiSocket_Exchange(
    phbalReg_MultiSocket_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wOption,                                   /**< [In] Option parameter. */
    uint8_t * pTxBuffer,                                /**< [In] Data to transmit. */
    uint16_t wTxLength,                                 /**< [In] Number of bytes to transmit. */
    uint16_t wRxBufSize,                                /**< [In] Number of bytes to receive. */
    uint8_t * pRxBuffer,                                /**< [Out] Received data. */
    uint16_t * pRxLength                                /**< [Out] Number of received data bytes. */
    );

phStatus_t phbalReg_MultiSocket_SetConfig(
    phbalReg_MultiSocket_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wConfig,
    uint16_t wValue
    );

phStatus_t phbalReg_MultiSocket_GetConfig(
    phbalReg_MultiSocket_DataParams_t * pDataParams,    /**< [In] Pointer to this layer's parameter structure. */
    uint16_t wConfig,
    uint16_t * pValue
    );

#endif /* PHBALREG_MULTISOCKET_H */
