/*
 * Copyright 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * BAL Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>

#ifdef _WIN32
#include <string.h>
#endif

#ifdef NXPBUILD__PHBAL_REG_MP300USB

#include "phbalReg_Mp300Usb_Ex.h"

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4200)           /* PRQA S 3116 */
#pragma warning(disable:4201)           /* PRQA S 3116 */
#include <windows.h>
#pragma warning(pop)                    /* PRQA S 3116 */

phStatus_t phbalReg_Mp300Usb_Ex_LoadFunctions(
    phbalReg_Mp300Usb_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    /* load libraries */
    pDataParams->pLibraryHandleLibUsb = LoadLibrary(PHBAL_REG_MP300USB_EX_DLL_LIBUSB_NAME);

    /* check if loading succeded */
    if (pDataParams->pLibraryHandleLibUsb == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    /* get all function pointers */
    pDataParams->pfInit = (PHBAL_REG_MP300USB_INIT) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_INIT);
    if (pDataParams->pfInit == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfFindBusses = (PHBAL_REG_MP300USB_FIND_BUSSES) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_FIND_BUSSES);
    if (pDataParams->pfFindBusses == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfFindDevices = (PHBAL_REG_MP300USB_FIND_DEVICES) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_FIND_DEVICES);
    if (pDataParams->pfFindDevices == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfGetBusses = (PHBAL_REG_MP300USB_GET_BUSSES) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_GET_BUSSES);
    if (pDataParams->pfGetBusses == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfOpen = (PHBAL_REG_MP300USB_OPEN) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_OPEN);
    if (pDataParams->pfOpen == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfClose = (PHBAL_REG_MP300USB_CLOSE) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_CLOSE);
    if (pDataParams->pfClose == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfClaimInterface = (PHBAL_REG_MP300USB_CLAIM_INTERFACE) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_CLAIM_INTERFACE);
    if (pDataParams->pfClaimInterface == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfReleaseInterface = (PHBAL_REG_MP300USB_RELEASE_INTERFACE) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_RELEASE_INTERFACE);
    if (pDataParams->pfReleaseInterface == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfInterruptWrite = (PHBAL_REG_MP300USB_INTERRUPT_WRITE) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_INTERRUPT_WRITE);
    if (pDataParams->pfInterruptWrite == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfBulkWrite = (PHBAL_REG_MP300USB_BULK_WRITE) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_BULK_WRITE);
    if (pDataParams->pfBulkWrite == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfInterruptRead = (PHBAL_REG_MP300USB_INTERRUPT_READ) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_INTERRUPT_READ);
    if (pDataParams->pfInterruptRead == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfBulkRead = (PHBAL_REG_MP300USB_BULK_READ) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_READ);
    if (pDataParams->pfBulkRead == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
    pDataParams->pfGetStringSimple = (PHBAL_REG_MP300USB_GET_STRING_SIMPLE) GetProcAddress((HMODULE)pDataParams->pLibraryHandleLibUsb, PHBAL_REG_MP300USB_EX_GET_STRING_SIMPLE);
    if (pDataParams->pfGetStringSimple == NULL)
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
#else
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

phStatus_t phbalReg_Mp300Usb_Ex_UnLoadFunctions(
    phbalReg_Mp300Usb_DataParams_t * pDataParams
    )
{
#ifdef _WIN32
    uint8_t bResult;

    /* check if the library is loaded */
    if (pDataParams->pLibraryHandleLibUsb != NULL)
    {
        /* unload the library */
        bResult = (uint8_t)FreeLibrary((HMODULE)pDataParams->pLibraryHandleLibUsb);

        /* check the success of the command */
        if (bResult == PH_OFF)
        {
            return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
        }

        /* set all function pointers to NULL */
        pDataParams->pfInit                 = NULL;
        pDataParams->pfFindBusses           = NULL;
        pDataParams->pfFindDevices          = NULL;
        pDataParams->pfGetBusses            = NULL;
        pDataParams->pfOpen                 = NULL;
        pDataParams->pfClose                = NULL;
        pDataParams->pfClaimInterface       = NULL;
        pDataParams->pfReleaseInterface     = NULL;
        pDataParams->pfInterruptWrite       = NULL;
        pDataParams->pfBulkWrite            = NULL;
        pDataParams->pfInterruptRead        = NULL;
        pDataParams->pfBulkRead             = NULL;
        pDataParams->pfGetStringSimple      = NULL;

        /* set the handle to NULL */
        pDataParams->pLibraryHandleLibUsb = NULL;
        /* return success */
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_BAL);
    }
    else
    {
        return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
    }
#else /* _WIN32 */
    return PH_ADD_COMPCODE(PH_ERR_USE_CONDITION, PH_COMP_BAL);
#endif
}

#endif /* NXPBUILD__PHBAL_REG_MP300USB */
