/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Inernal implementation of P40 CmdPub
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALP40CMDPUB_INT_H
#define PHALP40CMDPUB_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
* @{
*/

/** \name I.PrivateCommand instruction codes
*/
/*@{*/
#define PHAL_P40CMDPUB_GETVERSION_INS                   0x60U
#define PHAL_P40CMDPUB_DOWNLOADCODE_INS          0x61U
#define PHAL_P40CMDPUB_DOWNLOADCONST_INS        0x62U
#define PHAL_P40CMDPUB_DOWNLOADEE_INS                0x63U
#define PHAL_P40CMDPUB_DOWNLOADPATCH_INS         0x64U
#define PHAL_P40CMDPUB_DOWNLOADFLASH_INS	         0x65U
#define PHAL_P40CMDPUB_LOCKAPPLICATION_INS	         0x66U
#define PHAL_P40CMDPUB_FORMATAPPLICATION_INS   0x67U
#define PHAL_P40CMDPUB_SWITCHLIFECYCLE_INS         0x68U
#define PHAL_P40CMDPUB_EXECUTETRAPDOOR_INS    0x69U
#define PHAL_P40CMDPUB_SETCONFIGURATION_INS     0x6aU
#define PHAL_P40CMDPUB_GETCONFIGURATION_INS     0x6bU
#define PHAL_P40CMDPUB_FASTTEST_INS                        0x6cU
#define PHAL_P40CMDPUB_VERIFYDOWNLOAD_INS        0x6dU
#define PHAL_P40CMDPUB_GETCHALLENGE_INS             0x6eU
#define PHAL_P40CMDPUB_EXTAUTHENTICATE_INS       0x6fU
#define PHAL_P40CMDPUB_INTAUTHENTICATE_INS         0x70U

#define PHAL_P40CMDPUB_MAINTAINANCE_INS              0x11U
#define PHAL_P40CMDPUB_ANS_TO_MAINTAINANCE     0x12U
/*@}*/

/** \name P40 error codes
*/
/*@{*/
#define PHAL_P40CMDPUB_INT_ERR_OK                       0x9000U
#define PHAL_P40CMDPUB_INT_ERR_PARAM               0x6800U
#define PHAL_P40CMDPUB_INT_ERR_FORMAT             0x6700U
#define PHAL_P40CMDPUB_INT_ERR_INTERNAL          0x6600U
#define PHAL_P40CMDPUB_INT_ERR_NOT_AUTH        0x6900U
#define PHAL_P40CMDPUB_INT_ERR_WRONG_CMD    0x6500U
/*@}*/

/** \name Default 7816 params
*/
/*@{*/
#define PHAL_P40CMDPUB_INT_CLA_DEFAULT    0x80U
#define PHAL_P40CMDPUB_INT_P1_DEFAULT       0x00U
#define PHAL_P40CMDPUB_INT_P2_DEFAULT       0x00U
#define PHAL_P40CMDPUB_INT_LE_DEFAULT       0x00U
/*@}*/

/** \name defines used for CurrentCmd flags
*/
/*@{*/
#define PHPAL_I7816P4_CMDFLAG_DEFAULT               0x00U  /**< Reset value of the flag byte. */
#define PHPAL_I7816P4_CMDFLAG_LC_PRESENT        0x01U  /**< Set if the Lc field has been filled. */
#define PHPAL_I7816P4_CMDFLAG_USE_EXTENDED  0x02U  /**< Set if either Lc field or Le field requires it. */
#define PHPAL_I7816P4_CMDFLAG_MAX_LE                  0x04U /**< Set if  Le= 0 field specifies max value instead of zero. */
/*@}*/

/**
* \brief Internal tracker of current command/ response pair
*/
typedef struct
{
    uint16_t   wLc;	        /**< Total number of command bytes to be sent */
    uint16_t   wLe;	        /**< Total number of command bytes to be received*/
    uint8_t     bSw1;      /**< Returned SW1 byte of the current command*/
    uint8_t     bSw2;      /**< Returned SW2 byte of the current command*/
    uint8_t     bFlags;    /**< Bit flags for command*/

} phalP40CmdPub_Int_CurrenttApdu_t;

/**
* \brief Translate CMDPUB internally used return codes to general phStatus_t custom defined codes
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
*/
phStatus_t phalP40CmdPub_Int_TranslateError(
    uint16_t wSw1Sw2
    );

/** @}
* end of ph_Private
*/

#endif /*PHALP40CMDPUB_INT_H*/
