/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software implementation of P40 CmdPriv layer. Uses I.PrivateCommands  in P40
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALP40CMDPUB_SW_H
#define PHALP40CMDPUB_SW_H

#include <phalP40CmdPub.h>


phStatus_t phalP40CmdPub_Sw_GetVersion(
                                       phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                       uint8_t  bLifeCycleId,
                                       uint8_t * pVersionData
                                       );


phStatus_t phalP40CmdPub_Sw_DownloadCode(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint16_t wAddr,
                                        uint8_t * pCode,
                                       uint16_t wCodeLength
                                        );


phStatus_t phalP40CmdPub_Sw_DownloadConst(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint16_t wAddr,
                                        uint8_t * pConst,
                                        uint16_t wConstLength
                                        );


phStatus_t phalP40CmdPub_Sw_DownloadEE(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint16_t wAddr,
                                        uint8_t * pEEData,
                                        uint16_t wEEDataLength
                                        );


phStatus_t phalP40CmdPub_Sw_DownloadPatch(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint8_t bPatchNr,
                                        uint16_t wPatchAddress,
                                        uint8_t * pPatch,
                                        uint16_t wPatchLength
                                        );


phStatus_t phalP40CmdPub_Sw_DownloadFlash(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint16_t wAddr,
                                        uint8_t * pFlashData,
                                        uint16_t wFlashDataLength
                                        );


phStatus_t phalP40CmdPub_Sw_LockApplication(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams
                                        );


phStatus_t phalP40CmdPub_Sw_FormatApplication(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint8_t bApplicationId
                                        );


phStatus_t phalP40CmdPub_Sw_SwitchLifeCycle(
                                       phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                       uint8_t  bLifeCycleId,
                                       uint8_t bLcType
                                       );


phStatus_t phalP40CmdPub_Sw_ExecuteTrapdoor(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                       uint8_t  bLifeCycleId
                                        );


phStatus_t phalP40CmdPub_Sw_SetConfiguration(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint8_t bDisableCmdTestFuse,
                                        uint8_t bDisableTPTestFuse,
                                        uint8_t bUseExtendedConfig,
                                        uint16_t wApp1CodeSize,
                                        uint16_t wApp1ConstSize,
                                        uint16_t wApp2CodeSize,
                                        uint16_t wApp2ConstSize,
                                        uint16_t wCommBufferSize,
                                        uint8_t bNumKeys,
                                        uint8_t bDefaultApp
                                        );


phStatus_t phalP40CmdPub_Sw_GetConfiguration(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint8_t * pDisableCmdTestFuse,
                                        uint8_t * pDisableTPTestFuse,
                                        uint16_t * pApp1CodeSize,
                                        uint16_t * pApp1ConstSize,
                                        uint16_t * pApp2CodeSize,
                                        uint16_t * pApp2ConstSize,
                                        uint16_t * pCommBufferSize,
                                        uint8_t * pNumKeys,
                                        uint8_t * pDefaultApp
                                        );


phStatus_t phalP40CmdPub_Sw_FastTest(
                                       phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                       uint8_t  bLifeCycleId,
                                       uint8_t bFastTestType
                                       );

phStatus_t phalP40CmdPub_Sw_VerifyDownload(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint16_t wSHA5
                                        );

phStatus_t phalP40CmdPub_Sw_GetChallenge(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint8_t  bLifeCycleId,
                                        uint8_t bRequestLen,
                                        uint8_t* pChallenge
                                        );

phStatus_t phalP40CmdPub_Sw_ExternalAuthenticate(
                                    phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                    uint8_t  bLifeCycleId,
                                    uint8_t bCryptoMethod,
                                    uint8_t bKeyId,
                                    uint8_t* pEdata,
                                    uint8_t bEdataLen
                                     );

phStatus_t phalP40CmdPub_Sw_InternalAuthenticate(
                                    phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                    uint8_t  bLifeCycleId,
                                    uint8_t bCryptoMethod,
                                    uint8_t bKeyId,
                                    uint8_t* pEdata,
                                    uint8_t bEdataLen
                                    );

phStatus_t phalP40CmdPub_Sw_MaintainanceReqa(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams
                                        );

phStatus_t phalP40CmdPub_Sw_Authenticate(
                                        phalP40CmdPub_Sw_DataParams_t * pDataParams,
                                        uint8_t bLifeCycleId,
                                        uint8_t bKeyId,
                                        uint16_t wKeyNumber,
                                        uint16_t wKeyVersion
                                        );

#endif /* PHALP40CMDPUB_SW_H */
