/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Sam MIFARE(R) Ultralight Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>

#ifdef NXPBUILD__PHAL_MFUL_SAM_NONX
#include <phalMful.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHHAL_HW_SAMAV2
#include <phhalHw_SamAV2_Cmd.h>
#endif /* NXPBUILD__PHHAL_HW_SAMAV2 */

#ifdef NXPBUILD__PHHAL_HW_SAMAV3
#include <phhalHw_SamAV3_Cmd.h>
#endif /* NXPBUILD__PHHAL_HW_SAMAV3 */

#include "phalMful_Sam_NonX_Int.h"

phStatus_t phalMful_Sam_NonX_Int_SAM_KillAuthentication(void * pDataParams, uint8_t bOption)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_NONX
        case PHAL_MFUL_SAMAV2_ID:
            wStatus = phhalHw_SamAV2_Cmd_SAM_KillAuthentication(((phalMful_SamAV2_DataParams_t *) pDataParams)->pHalSamDataParams,
                bOption);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_NONX */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_NONX
        case PHAL_MFUL_SAMAV3_NONX_ID:
            wStatus = phhalHw_SamAV3_Cmd_SAM_KillAuthentication(((phalMful_SamAV3_NonX_DataParams_t *) pDataParams)->pHalSamDataParams,
                bOption);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_NONX */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    /*
     * SAM Kill Authenticate will return 0x6883 status code and its a call before Part2 call.
     * SAM status for this command is not required to be validated.
     */
    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFUL);
}

phStatus_t phalMful_Sam_NonX_Int_UlcAuthenticate_Part1(void * pDataParams, uint8_t bOption, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pCardResponse, uint8_t bCardRespLen, uint8_t ** ppSamResponse,
    uint16_t * pSamRespLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;

#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_NONX
    uint8_t PH_MEMLOC_REM bSamRespLen = 0;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_NONX */

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_NONX
        case PHAL_MFUL_SAMAV2_ID:
            wStatus = phhalHw_SamAV2_Cmd_SAM_AuthenticatePICC_Part1(
                ((phalMful_SamAV2_DataParams_t *) pDataParams)->pHalSamDataParams,
                bOption,
                (uint8_t) wKeyNo,
                (uint8_t) wKeyVer,
                pCardResponse,
                bCardRespLen,
                pDivInput,
                bDivInputLen,
                *ppSamResponse,
                &bSamRespLen);

            *pSamRespLen = bSamRespLen;
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_NONX */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_NONX
        case PHAL_MFUL_SAMAV3_NONX_ID:
            wStatus = phhalHw_SamAV3_Cmd_SAM_AuthenticatePICC_Part1(
                ((phalMful_SamAV3_NonX_DataParams_t *) pDataParams)->pHalSamDataParams,
                bOption,
                (uint8_t) wKeyNo,
                (uint8_t) wKeyVer,
                0x00U,
                pDivInput,
                bDivInputLen,
                pCardResponse,
                bCardRespLen,
                ppSamResponse,
                pSamRespLen);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_NONX */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    return wStatus;
}

phStatus_t phalMful_Sam_NonX_Int_UlcAuthenticate_Part2(void * pDataParams, uint8_t * pCardResponse, uint8_t bCardRespLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;
    uint8_t     PH_MEMLOC_REM bStatusCode = 0;

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_NONX
        case PHAL_MFUL_SAMAV2_ID:
            wStatus = phhalHw_SamAV2_Cmd_SAM_AuthenticatePICC_Part2(
                ((phalMful_SamAV2_DataParams_t *) pDataParams)->pHalSamDataParams,
                pCardResponse,
                bCardRespLen);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_NONX */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_NONX
        case PHAL_MFUL_SAMAV3_NONX_ID:
            wStatus = phhalHw_SamAV3_Cmd_SAM_AuthenticatePICC_Part2(
                ((phalMful_SamAV3_NonX_DataParams_t *) pDataParams)->pHalSamDataParams,
                0x00U,
                pCardResponse,
                bCardRespLen,
                NULL,
                NULL,
                &bStatusCode);

            if((wStatus & PH_ERR_MASK) == PHHAL_HW_SAMAV3_ERR_DESFIRE_GEN)
            {
                wStatus = PH_ADD_COMPCODE(bStatusCode, PH_COMP_AL_MFUL);
            }
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_NONX */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    return wStatus;
}

phStatus_t phalMful_Sam_NonX_Int_PwdAuth_Part1(void * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pDivInput,
    uint8_t bDivInputLen, uint8_t ** ppPwd, uint16_t * pPwdLen)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_NONX
        case PHAL_MFUL_SAMAV2_ID:
            /* Returning Chaining status as the prior level call requires the same for verification. */
            wStatus = PH_ADD_COMPCODE(PH_ERR_SUCCESS_CHAINING, PH_COMP_HAL);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_NONX */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_NONX
        case PHAL_MFUL_SAMAV3_NONX_ID:
            wStatus = phhalHw_SamAV3_Cmd_SAM_PwdAuthUL_Part1(
                ((phalMful_SamAV3_NonX_DataParams_t *) pDataParams)->pHalSamDataParams,
                (uint8_t) wKeyNo,
                (uint8_t) wKeyVer,
                pDivInput,
                bDivInputLen,
                ppPwd,
                pPwdLen);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_NONX */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    return wStatus;
}

phStatus_t phalMful_Sam_NonX_Int_PwdAuth_Part2(void * pDataParams, uint8_t * pPack)
{
    phStatus_t  PH_MEMLOC_REM wStatus = 0;

    switch(PH_GET_COMPID(pDataParams))
    {
#ifdef NXPBUILD__PHAL_MFUL_SAMAV2_NONX
        case PHAL_MFUL_SAMAV2_ID:
            wStatus = PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_AL_MFUL);
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV2_NONX */

#ifdef NXPBUILD__PHAL_MFUL_SAMAV3_NONX
        case PHAL_MFUL_SAMAV3_NONX_ID:
            wStatus = phhalHw_SamAV3_Cmd_SAM_PwdAuthUL_Part2(
                ((phalMful_SamAV3_NonX_DataParams_t *) pDataParams)->pHalSamDataParams,
                (uint16_t) ((pPack[0U] << 8U) | pPack[1U]));
            break;
#endif /* NXPBUILD__PHAL_MFUL_SAMAV3_NONX */

        default:
            wStatus = PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_AL_MFUL);
            break;
    }

    return wStatus;
}

#endif /* NXPBUILD__PHAL_MFUL_SAM_NONX */
