/*
 * Copyright 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/*
 * \file
 * Software MIFARE PRIME NTAG Application Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALMFPRIMENTAG_SAMAV3_NONX_H
#define PHALMFPRIMENTAG_SAMAV3_NONX_H

/* MIFARE PRIME NTAG secure messaging related commands. ------------------------------------------------------------------------------ */
phStatus_t phalMfPrimeNtag_Sam_NonX_AuthenticateEv2(void * pDataParams, uint8_t bAuthType, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer,
	uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pPcdCapsIn, uint8_t bPcdCapsInLen, uint8_t * pPcdCapsOut,
	uint8_t * pPdCapsOut);




/* MIFARE PRIME NTAG Memory and Configuration mamangement commands. ------------------------------------------------------------------ */
phStatus_t phalMfPrimeNtag_Sam_NonX_SetConfiguration(void * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfPrimeNtag_Sam_NonX_GetVersion(void * pDataParams, uint8_t * pVerInfo);




/* MIFARE PRIME NTAG Key mamangement commands. -------------------------------------------------------------------------------------- */
phStatus_t phalMfPrimeNtag_Sam_NonX_ChangeKey(void * pDataParams, uint16_t wOption, uint16_t wCurrKeyNo, uint16_t wCurrKeyVer, uint16_t wNewKeyNo,
	uint16_t wNewKeyVer, uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfPrimeNtag_Sam_NonX_GetKeyVersion(void * pDataParams, uint8_t bKeyNo, uint8_t * pKeyVersion, uint8_t * pKeyVerLen);




/* MIFARE PRIME NTAG File mamangement commands. -------------------------------------------------------------------------------------- */
phStatus_t phalMfPrimeNtag_Sam_NonX_GetFileSettings(void * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * pBufferLen);

phStatus_t phalMfPrimeNtag_Sam_NonX_GetFileCountersSDM(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pFileCounters, uint8_t * pRespLen);

phStatus_t phalMfPrimeNtag_Sam_NonX_ChangeFileSettings(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bCommSett, uint8_t *pAccessRights);

phStatus_t phalMfPrimeNtag_Sam_NonX_ChangeFileSettingsSDM(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption, uint8_t *pAccessRights,
	uint8_t bSdmOptions, uint8_t *pSdmAccessRights, uint8_t *pVCUIDOffset, uint8_t *pSDMReadCtrOffset, uint8_t *pSDMMACInputOffset, uint8_t *pSDMMACOffset);



/* MIFARE PRIME NTAG Data mamangement commands. -------------------------------------------------------------------------------------- */
phStatus_t phalMfPrimeNtag_Sam_NonX_ReadData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pLength, uint8_t ** ppResponse,
	uint16_t * pRespLen);

phStatus_t phalMfPrimeNtag_Sam_NonX_WriteData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);




/* MIFARE PRIME NTAG ISO7816-4 commands. --------------------------------------------------------------------------------------------- */
phStatus_t phalMfPrimeNtag_Sam_NonX_IsoSelectFile(void * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid, uint8_t * pDFname, uint8_t bDFnameLen,
	uint8_t	bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pFCILen);

phStatus_t phalMfPrimeNtag_Sam_NonX_IsoReadBinary ( void * pDataParams, uint16_t wOption, uint8_t bOffset, uint8_t bSfid, uint32_t dwBytesToRead, uint8_t bExtendedLenApdu,
	uint8_t ** ppResponse, uint32_t * pBytesRead );

phStatus_t phalMfPrimeNtag_Sam_NonX_IsoUpdateBinary ( void * pDataParams, uint8_t bOffset, uint8_t bSfid, uint8_t bExtendedLenApdu, uint8_t * pData, uint32_t dwDataLen );




/* MIFARE PRIME NTAG Originality Check functions. ------------------------------------------------------------------------------------ */
phStatus_t phalMfPrimeNtag_Sam_NonX_ReadSign(void * pDataParams, uint8_t bAddr, uint8_t ** ppSignature);




/* MIFARE PRIME NTAG Miscellaneous functions. ---------------------------------------------------------------------------------------- */
phStatus_t phalMfPrimeNtag_Sam_NonX_GetConfig(void * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phalMfPrimeNtag_Sam_NonX_SetConfig(void * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phalMfPrimeNtag_Sam_NonX_ResetAuthentication(void * pDataParams);

phStatus_t phalMfPrimeNtag_Sam_NonX_CalculateMACSDM(void * pDataParams, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer,
	uint16_t wDstKeyNo, uint16_t wDstKeyVer, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pInData, uint16_t wInDataLen,
	uint8_t * pMac);

#endif /* PHALMFPRIMENTAG_SAMAV3_NONX_H */
