/*
 * Copyright 2020, 2023 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
* SAM X MIFARE Plus EVx (Ev1, and future versions) Application Component of Reader Library Framework.
* $Author: Rajendran Kumar (nxp99556) $
* $Revision: 7467 $
* $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
*
* History:
*  CHu: Generated 31. July 2009
*
*/

#ifndef PHALMFPEVX_SAM_X_H
#define PHALMFPEVX_SAM_X_H

#include <ph_Status.h>

phStatus_t phalMfpEVx_Sam_X_WritePerso(void * pDataParams, uint8_t bLayer4Comm, uint16_t wBlockNr, uint8_t bNumBlocks, uint8_t * pValue);

phStatus_t phalMfpEVx_Sam_X_CommitPerso(void * pDataParams, uint8_t bOption, uint8_t bLayer4Comm);


/***************************************************************************************************************************************/
/* MIFARE Plus EVx Generic command for authentication.                                                                                 */
/***************************************************************************************************************************************/
phStatus_t phalMfpEVx_Sam_X_AuthenticateMfc(void * pDataParams, uint8_t bOption, uint8_t bBlockNo, uint8_t bKeyType,
    uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pUid, uint8_t bUidLen);

phStatus_t phalMfpEVx_Sam_X_AuthenticateSL0(void * pDataParams, uint8_t bLayer4Comm, uint8_t bFirstAuth, uint16_t wBlockNr,
    uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bDivInputLen, uint8_t * pDivInput, uint8_t bPcdCap2InLen, uint8_t * pPcdCap2In,
    uint8_t * pPcdCap2Out, uint8_t * pPdCap2);

phStatus_t phalMfpEVx_Sam_X_AuthenticateSL1(void * pDataParams, uint8_t bLayer4Comm, uint8_t bFirstAuth, uint16_t wBlockNr,
    uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bDivInputLen, uint8_t * pDivInput, uint8_t bPcdCap2InLen, uint8_t * pPcdCap2In,
    uint8_t * pPcdCap2Out, uint8_t * pPdCap2);

phStatus_t phalMfpEVx_Sam_X_AuthenticateSL3(void * pDataParams, uint8_t bFirstAuth, uint16_t wBlockNr, uint16_t wKeyNo,
    uint16_t wKeyVer, uint8_t bDivInputLen, uint8_t * pDivInput, uint8_t bPcdCap2InLen, uint8_t * pPcdCap2In,
    uint8_t * pPcdCap2Out, uint8_t * pPdCap2);

phStatus_t phalMfpEVx_Sam_X_SSAuthenticate(void * pDataParams, uint8_t bOption, uint16_t wSSKeyBNr, uint16_t wSSKeyNr, uint16_t wSSKeyVer,
    uint8_t bLenDivInputSSKey, uint8_t * pDivInputSSKey, uint8_t  bSecCount, uint16_t *pSectorNos, uint16_t * pKeyNos,
    uint16_t * pKeyVers, uint8_t bLenDivInputSectorKeyBs, uint8_t * pDivInputSectorKeyBs);

phStatus_t phalMfpEVx_Sam_X_AuthenticatePDC(void * pDataParams, uint16_t wBlockNr, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t bDivInputLen, uint8_t * pDivInput, uint8_t bUpgradeInfo);



/***************************************************************************************************************************************/
/* MIFARE Plus EVx Generic command for data operations.                                                                                */
/***************************************************************************************************************************************/
phStatus_t phalMfpEVx_Sam_X_Write(void * pDataParams, uint8_t bEncrypted, uint8_t bWriteMaced, uint16_t wBlockNr, uint8_t bNumBlocks,
    uint8_t * pBlocks, uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfpEVx_Sam_X_Read(void * pDataParams, uint8_t bEncrypted, uint8_t bReadMaced, uint8_t bMacOnCmd, uint16_t wBlockNr,
    uint8_t bNumBlocks, uint8_t * pBlocks);



/***************************************************************************************************************************************/
/* MIFARE Plus EVx Generic command for value operations.                                                                               */
/***************************************************************************************************************************************/
phStatus_t phalMfpEVx_Sam_X_WriteValue(void * pDataParams, uint8_t bEncrypted, uint8_t bWriteMaced, uint16_t wBlockNr, uint8_t * pValue,
    uint8_t bAddrData, uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfpEVx_Sam_X_ReadValue(void * pDataParams, uint8_t bEncrypted, uint8_t bReadMaced, uint8_t bMacOnCmd, uint16_t wBlockNr,
    uint8_t * pValue, uint8_t * pAddrData);

phStatus_t phalMfpEVx_Sam_X_Increment(void * pDataParams, uint8_t bIncrementMaced, uint16_t wBlockNr, uint8_t * pValue);

phStatus_t phalMfpEVx_Sam_X_Decrement(void * pDataParams, uint8_t bDecrementMaced, uint16_t wBlockNr, uint8_t * pValue);

phStatus_t phalMfpEVx_Sam_X_IncrementTransfer(void * pDataParams, uint8_t bIncrementTransferMaced, uint16_t wSrcBlockNr,
    uint16_t wDstBlockNr, uint8_t * pValue, uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfpEVx_Sam_X_DecrementTransfer(void * pDataParams, uint8_t bDecrementTransferMaced, uint16_t wSrcBlockNr,
    uint16_t wDstBlockNr, uint8_t * pValue, uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfpEVx_Sam_X_Transfer(void * pDataParams, uint8_t bTransferMaced, uint16_t wBlockNr, uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfpEVx_Sam_X_Restore(void * pDataParams, uint8_t bRestoreMaced, uint16_t wBlockNr);



/***************************************************************************************************************************************/
/* MIFARE Plus EVx Generic command for special commands.                                                                               */
/***************************************************************************************************************************************/
phStatus_t phalMfpEVx_Sam_X_GetVersion(void * pDataParams, uint8_t * pVerInfo, uint8_t * pVerLen);

phStatus_t phalMfpEVx_Sam_X_ReadSign(void * pDataParams, uint8_t bLayer4Comm, uint8_t bAddr, uint8_t ** pSignature);

phStatus_t phalMfpEVx_Sam_X_ResetAuth(void * pDataParams);

phStatus_t phalMfpEVx_Sam_X_PersonalizeUid(void * pDataParams, uint8_t bUidType);

phStatus_t phalMfpEVx_Sam_X_SetConfigSL1(void * pDataParams, uint8_t bOption);

phStatus_t phalMfpEVx_Sam_X_ReadSL1TMBlock(void * pDataParams, uint16_t wBlockNr, uint8_t * pBlocks);

phStatus_t phalMfpEVx_Sam_X_ChangeKey(void * pDataParams, uint8_t bChangeKeyMaced, uint16_t wBlockNr, uint16_t wKeyNo, uint16_t wKeyVer,
    uint8_t bDivInputLen, uint8_t * pDivInput);

phStatus_t phalMfpEVx_Sam_X_CommitReaderID(void * pDataParams, uint16_t wBlockNr, uint8_t * pEncTMRI);

phStatus_t phalMfpEVx_Sam_X_VCSupportLastISOL3(void * pDataParams, uint8_t * pIid, uint8_t * pPcdCapL3, uint8_t * pInfo);



/***************************************************************************************************************************************/
/* MIFARE Plus EVx Generic command for utility operations.                                                                             */
/***************************************************************************************************************************************/
phStatus_t phalMfpEVx_Sam_X_ResetSecMsgState(void * pDataParams);

phStatus_t phalMfpEVx_Sam_X_SetConfig(void *pDataParams, uint16_t wOption, uint16_t wValue);

phStatus_t phalMfpEVx_Sam_X_GetConfig(void * pDataParams, uint16_t wOption, uint16_t * pValue);

phStatus_t phalMfpEVx_Sam_X_CalculateTMV(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
    uint16_t wDstKeyVer, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen, uint8_t * pTMI, uint16_t wTMILen, uint8_t * pTMV);

phStatus_t phalMfpEVx_Sam_X_DecryptReaderID(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
    uint16_t wDstKeyVer, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen, uint8_t * pEncTMRI, uint8_t * pTMRIPrev);
#endif /* PHALMFPEVX_SAM_X_H */
