/*
 * Copyright 2016 - 2018, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions of Software implementation of MIFARE (R) application layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHALMFP_SAM_X_INT_H
#define PHALMFP_SAM_X_INT_H

#include <ph_Status.h>
#include <phalMfp.h>

#include <phhalHw_SamAV2_Cmd.h>
#include "../phalMfp_Int.h"

#ifdef NXPBUILD__PHAL_MFP_SAMAV3_X
#include <phhalHw_SamAV3_Cmd.h>
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_RESOLVE_PAL_MIFARE_DATAPARAMS(DataParams)																									\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ? ((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pPalMifareDataParams :					\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV3_X_ID) ? ((phalMfp_SamAV3_X_DataParams_t *) DataParams)->pPalMifareDataParams :					\
			NULL
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_RESOLVE_PAL_MIFARE_DATAPARAMS(DataParams)																									\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ? ((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pPalMifareDataParams :					\
			NULL
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_WRITE_PERSO(DataParams, Option, Blocks, BlocksLen, PiccErrCode )																			\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpWritePerso(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlocksLen,	PiccErrCode) :			\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MFP_WritePerso(((phalMfp_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, Option, Blocks, BlocksLen, PiccErrCode) :	\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_WRITE_PERSO(DataParams, Option, Blocks, BlocksLen, PiccErrCode )																			\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpWritePerso(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Blocks, BlocksLen,	PiccErrCode) :			\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_AUTHENTICATE(DataParams, Option, KeyNo, KeyVer, BlockNr, PcdCap2In, PcdCap2InLen, DivInput, DivInputLen, PcdCap2Out, PdCap2, PiccErrCode )	\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpAuthenticate(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Option, KeyNo, KeyVer, BlockNr,			\
					PcdCap2In, PcdCap2InLen, DivInput, DivInputLen, PcdCap2Out, PdCap2, PiccErrCode) :														\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MFP_Authenticate(((phalMfp_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, Option, KeyNo, KeyVer, BlockNr,			\
					PcdCap2In, PcdCap2InLen, DivInput, DivInputLen, PcdCap2Out, PdCap2, PiccErrCode) :														\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_AUTHENTICATE(DataParams, Option, KeyNo, KeyVer, BlockNr, PcdCap2In, PcdCap2InLen, DivInput, DivInputLen, PcdCap2Out, PdCap2, PiccErrCode )	\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpAuthenticate(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Option, KeyNo, KeyVer, BlockNr,			\
					PcdCap2In, PcdCap2InLen, DivInput, DivInputLen, PcdCap2Out, PdCap2, PiccErrCode) :														\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_COMBINED_WRITE(DataParams, Option, Data, DataLen, PiccErrCode )																			\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpCombinedWrite(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Option, Data, DataLen, PiccErrCode) :	\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MFP_CombinedWrite(((phalMfp_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, Option, Data, DataLen, NULL, NULL,		\
					PiccErrCode) :																															\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_COMBINED_WRITE(DataParams, Option, Data, DataLen, PiccErrCode )																			\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpCombinedWrite(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Option, Data, DataLen, PiccErrCode) :	\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_COMBINED_READ(DataParams, Option, Command, CmdLen, Data, DataLen, PiccErrCode )															\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpCombinedRead(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Option, Command, CmdLen, Data, DataLen,	\
					PiccErrCode) :																															\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MFP_CombinedRead(((phalMfp_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, Option, Command, CmdLen, Data, DataLen, \
					PiccErrCode) :																															\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_COMBINED_READ(DataParams, Option, Command, CmdLen, Data, DataLen, PiccErrCode )															\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpCombinedRead(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Option, Command, CmdLen, Data, DataLen,	\
					PiccErrCode) :																															\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_CHANGE_KEY(DataParams, Option, Command, BlockNr, KeyNo, KeyVer, DivInput, DivInputLen, PiccErrCode )										\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpChangeKey(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Command, BlockNr, KeyNo, KeyVer,			\
					DivInput, DivInputLen, PiccErrCode) :																									\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_MFP_ChangeKey(((phalMfp_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, Option, Command, BlockNr, KeyNo, KeyVer, 	\
					DivInput, DivInputLen, PiccErrCode) :																									\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHAL_MFP_CHANGE_KEY(DataParams, Option, Command, BlockNr, KeyNo, KeyVer, DivInput, DivInputLen, PiccErrCode )										\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_MfpChangeKey(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Command, BlockNr, KeyNo, KeyVer,			\
					DivInput, DivInputLen, PiccErrCode) :																									\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */

#ifdef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHHAL_HW_SAM_KILL_AUTHENTICATION(DataParams, Option )																								\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_SAM_KillAuthentication(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Option) :							\
																																							\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV3_X_ID) ?																							\
				phhalHw_SamAV3_Cmd_SAM_KillAuthentication(((phalMfp_SamAV3_X_DataParams_t *) DataParams)->pHalDataParams, Option) :	 						\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */
#ifndef NXPBUILD__PHAL_MFP_SAMAV3_X
#define PHHAL_HW_SAM_KILL_AUTHENTICATION(DataParams, Option )																								\
			(PH_GET_COMPID(DataParams) == PHAL_MFP_SAMAV2_X_ID) ?																							\
				phhalHw_SamAV2_Cmd_SAM_KillAuthentication(((phalMfp_SamAV2_X_DataParams_t *) DataParams)->pHalDataParams, Option) :							\
																																							\
			PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_AL_MFP)
#endif /* NXPBUILD__PHAL_MFP_SAMAV3_X */

/** MIFARE Plus SL and Key derivation info states. */
#define PHAL_MFP_AUTHENTICATE_SL1_NO_KDF					0x00	/**< Option to set the key derivation info for SL0 or SL1 layer. */
#define PHAL_MFP_AUTHENTICATE_SL2_KDF						0x08	/**< Option to set the key derivation info for SL2 layer. */
#define PHAL_MFP_AUTHENTICATE_SL3_KDF						0x0C	/**< Option to set the key derivation info for SL3 layer. */

#define PHAL_MFP_SAM_X_ORIGINALITY_KEY_0          0x8000
#define PHAL_MFP_SAM_X_ORIGINALITY_KEY_1          0x8001
#define PHAL_MFP_SAM_X_ORIGINALITY_KEY_2          0x8002
#define PHAL_MFP_SAM_X_ORIGINALITY_KEY_FIRST      PHAL_MFP_SAM_X_ORIGINALITY_KEY_0
#define PHAL_MFP_SAM_X_ORIGINALITY_KEY_LAST       PHAL_MFP_SAM_X_ORIGINALITY_KEY_2

/*
 * Perfomrs SAM_AuthenticateMFP. Here the data received from Card will be exchanged o SAM for further processig.
 * Also the data received from
 *
 * Input Parameters:
 *		pDataParams		: Pointer to this layer's parameter structure.
 *		bLayer4Comm		: ISO14443 protocol to be used.
 *							0x00: PHAL_MFP_ISO14443_L3
 *							0x01: PHAL_MFP_ISO14443_L4
 *		bFirstAuth		: Type of authentication to be performed.
 *							0x01: First Authentication.
 *							0x00: Non First Authentication (Following Authentication).
 *		bKdf			: The security level at which this interface is called. This value will be passed as
 *						  KDF information to HAL layer.
 *							0x00: Security Level 0 KDF.
 *							0x00: Security Level 1 KDF.
 *							0x01: Security Level 2 KDF.
 *							0x03: Security Level 3 KDF.
 *		wBlockNr		: Card's AES block number to be used for authentication.
 *		wKeyNum			: AES key address in hardware key store.
 *		wKeyVer			: AES key version to be used.
 *		pDivInput		: Diversification Input used to diversify the key.
 *		bDivInputLen	: Length of diversification input used to diversify the key.
 *						  If 0, no diversification is performed.
 *		pPcdCap2In		: PCD capibilites 2 information tobe passed.
 *		bPcdCap2InLen	: Length of PCD capibilities 2 to be sent to card.
 *
 * Output Parameters:
 *		pPcdCap2Out		: PCD Capabilities received from card. Consists of 6 bytes of data.
 *					      This PCD capibilities are returned by the card if its First authentication.
 *					      For Non First authentication (Following authentication)this data is not returned.
 *		pPdCap2			: PD Capabilities received from card. Consists of 6 bytes of data.
 *					      This PD capibilities are returned by the card if its First authentication.
 *					      For Non First authentication (Following authentication)this data is not returned.
 *
 * Return:
 *			PH_ERR_SUCCESS for successfull operation.
 *			Other Depending on implementation and underlaying component.
 */
phStatus_t phalMfp_Sam_X_Int_MFP_Authenticate(void * pDataParams, uint8_t bLayer4Comm, uint8_t bFirstAuth, uint8_t bKdf, uint16_t wBlockNr,
	uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pPcdCap2In, uint8_t bPcdCap2InLen,
	uint8_t * pPcdCap2Out, uint8_t * pPdCap2);

/*
 * Performs a CombinedWrite command with PICC via Sam hardware. This command is valid for Write, ValueWrite, Increment, Decrement,
 * IncrementTrenafer, DecrementTransfer, Transfer and REstore command.
 *
 * Input Parameters:
 *		pDataParams		: Pointer to this layer's parameter structure.
 *		bCmdCode		: One of the following command codes.
 *							Write				: 0xA0, 0xA1, 0xA2, 0xA3
 *							Increment			: 0xB0, 0xB1
 *							Decrement			: 0xB2, 0xB3
 *							Transfer			: 0xB4, 0xB5
 *							IncrementTransfer	: 0xB6, 0xB7
 *							DecrementTransfer	: 0xB8, 0xB9
 *							Restore				: 0xC2, 0xC3
 *		wSrcBlockNr		: Source block number.
 *		wDstBlockNr		: Destination block number for all Transfer related commands.
 *		pData			: Data to be written to the.
 *		bDataLen		: Length of input data stream.
 *
 * Return:
 *			PH_ERR_SUCCESS for successfull operation.
 *			Other Depending on implementation and underlaying component.
 */
phStatus_t phalMfp_Sam_X_Int_MFP_CombinedWrite(void * pDataParams, uint8_t bCmdCode, uint16_t wSrcBlockNr, uint16_t wDstBlockNr, uint8_t * pData,
	uint8_t bDataLen );

/*
 * Perform a MFP CombinedRead command. This command is common for Read and ReadValue.
 *
 * Input Parameters:
 *		pDataParams		: Pointer to this layer's parameter structure.
 *		bCmdCode		: One of the following command codes.
 *							Read				: 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37
 *		wBlockNr		: PICC block number from where the data should be read.
 *		bNumBlocks		: The number of blocks to be read.
 *
 * Output Parameters:
 *		pBlocks			: The data read from the block number specified. The buffer will contain the size calculated form
 *						  bNumBlocks * 16, where 16 is one block size.
 *
 * Return:
 *			PH_ERR_SUCCESS for successfull operation.
 *			Other Depending on implementation and underlaying component.
 */
phStatus_t phalMfp_Sam_X_Int_CombinedReadMFP(void * pDataParams, uint8_t bCmdCode, uint16_t wBlockNr, uint8_t bNumBlocks, uint8_t * pBlocks);

#endif /* PHALMFP_SAM_X_INT_H */
