/*
*         Copyright (c), NXP Semiconductors Bangalore / India
*
*                     (C)NXP Semiconductors
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
* particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/**
* \file
* SAM X MIFARE Identity Application Component of Reader Library Framework.
* $Author: Rajendran Kumar (nxp99556) $
* $Revision: 7230 $
* $Date: 2025-03-14 10:27:23 +0530 (Fri, 14 Mar 2025) $
*
* History:
*  SDA: Generated 23. April 2010
*
*/

#ifndef PHALMFIDENTITY_SAM_X_H
#define PHALMFIDENTITY_SAM_X_H

#include <phCryptoSym.h>
#include <phalMfIdentity.h>

#define PHAL_MFIDENTITY_SAM_X_AUTH_KEY_DIV_ENABLED            0x0001U		/**< Bit 0 of P1. Indicating diversification of new key requred. */
#define PHAL_MFIDENTITY_SAM_X_AUTH_KEY_DIV_MODE               (0x0018 >> 3)	/**< Bit 3-4 of P1. Indicating diversification mode. */

/* MIFARE Identity Secure Messaging commands. ------------------------------------------------------------------------------------------ */
phStatus_t phalMfIdentity_Sam_X_AuthenticateEv2(void *pDataParams, uint8_t bAuthType, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyNoCard,
	uint8_t * pDivInput, uint8_t bDivInputLen, uint8_t * pPcdCapsIn, uint8_t bPcdCapsInLen, uint8_t * pPcdCapsOut, uint8_t * pPdCapsOut);




/* MIFARE Identity Memory and Configuration commands. ---------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sam_X_SetConfiguration(void * pDataParams, uint8_t bOption, uint8_t * pData, uint8_t bDataLen);

phStatus_t phalMfIdentity_Sam_X_GetVersion(void * pDataParams, uint8_t * pVerInfo, uint8_t * pVerLen);

phStatus_t phalMfIdentity_Sam_X_GetCardUID(void * pDataParams, uint8_t * pUid, uint8_t * pUidLen);




/* MIFARE Identity Key Management commands. -------------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sam_X_ChangeKey(void * pDataParams, uint16_t wOption, uint16_t wCurrKeyNo, uint16_t wCurrKeyVer, uint16_t wNewKeyNo, uint16_t wNewKeyVer,
	uint8_t bKeyNoCard, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfIdentity_Sam_X_GetKeyVersion(void * pDataParams, uint8_t bKeyNo, uint8_t * pKeyVersion, uint8_t * pKeyVerLen);




/* MIFARE Identity File Management commands. ------------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sam_X_CreateTransactionMacFile(void * pDataParams, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights, uint16_t wKeyNo, uint8_t bKeyVer,
	uint8_t bKeyType, uint8_t * pDivInput, uint8_t bDivInputLen);

phStatus_t phalMfIdentity_Sam_X_DeleteFile(void * pDataParams, uint8_t bFileNo);

phStatus_t phalMfIdentity_Sam_X_GetFileSettings(void * pDataParams, uint8_t bFileNo, uint8_t * pFSBuffer, uint8_t * pBufferLen);

phStatus_t phalMfIdentity_Sam_X_GetFileCounters(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pResponse, uint8_t * pRespLen);

phStatus_t phalMfIdentity_Sam_X_ChangeFileSettings(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t bTMCLimitLen,
	uint8_t * pTMCLimit);

phStatus_t phalMfIdentity_Sam_X_ChangeFileSettingsSDM(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t bFileOption, uint8_t * pAccessRights, uint8_t bSdmOptions,
	uint8_t * pSdmAccessRights, uint8_t * pPICCDataOffset, uint8_t * pSDMMACInputOffset, uint8_t * pSDMENCOffset, uint8_t * pSDMENCLen, uint8_t * pSDMMACOffset,
	uint8_t * pSDMReadCtrOffset, uint8_t * pTMCLimitValue);




/* MIFARE Identity Data Management commands. ------------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sam_X_ReadData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pLength, uint8_t ** ppResponse,
	uint16_t * pRespLen);

phStatus_t phalMfIdentity_Sam_X_WriteData(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfIdentity_Sam_X_ReadRecords(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pRecNo, uint8_t * pRecCount, uint8_t * pRecSize,
	uint8_t ** ppResponse, uint16_t * pRespLen);

phStatus_t phalMfIdentity_Sam_X_WriteRecord(void * pDataParams, uint8_t bOption, uint8_t bFileNo, uint8_t * pOffset, uint8_t * pData, uint8_t * pDataLen);

phStatus_t phalMfIdentity_Sam_X_ClearRecordFile(void * pDataParams, uint8_t bFileNo);




/* MIFARE Identity Transaction Management commands. ------------------------------------------------------------------------------------ */
phStatus_t phalMfIdentity_Sam_X_CommitTransaction(void * pDataParams, uint8_t bOption, uint8_t * pTMC, uint8_t * pTMV);

phStatus_t phalMfIdentity_Sam_X_AbortTransaction(void * pDataParams);

phStatus_t phalMfIdentity_Sam_X_CommitReaderID(void * pDataParams, uint8_t * pTMRI, uint8_t * pEncTMRI);





/* MIFARE Identity ISO7816-4 commands. ------------------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sam_X_IsoSelectFile(void * pDataParams, uint8_t bOption, uint8_t bSelector, uint8_t * pFid, uint8_t * pDFname, uint8_t bDFnameLen,
	uint8_t	bExtendedLenApdu, uint8_t ** ppFCI, uint16_t * pFCILen);




/* MIFARE Identity OriginalityCheck commands. ------------------------------------------------------------------------------------------ */
phStatus_t phalMfIdentity_Sam_X_ReadSign(void * pDataParams, uint8_t bAddr, uint8_t ** pSignature);




/* MIFARE DESFire Light Miscellaneous commands. ---------------------------------------------------------------------------------------- */
phStatus_t phalMfIdentity_Sam_X_ResetAuthentication(void * pDataParams);

phStatus_t phalMfIdentity_Sam_X_GetConfig(void * pDataParams, uint16_t wConfig, uint8_t * pValue);

phStatus_t phalMfIdentity_Sam_X_SetConfig(void * pDataParams, uint16_t wConfig, uint8_t * pValue);

phStatus_t phalMfIdentity_Sam_X_CalculateTMV(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
	uint16_t wDstKeyVer, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen, uint8_t * pTMI, uint32_t dwTMILen, uint8_t * pTMV);

phStatus_t phalMfIdentity_Sam_X_DecryptReaderID(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo,
	uint16_t wDstKeyVer, uint8_t * pTMC, uint8_t * pUid, uint8_t bUidLen, uint8_t * pEncTMRI, uint8_t * pTMRIPrev);

phStatus_t phalMfIdentity_Sam_X_CalculateMACSDM(void * pDataParams, uint8_t bSdmOption, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer,
	uint16_t wDstKeyNo, uint16_t wDstKeyVer, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pInData, uint16_t wInDataLen,
	uint8_t * pMac);

phStatus_t phalMfIdentity_Sam_X_DecryptSDMENCFileData(void * pDataParams, uint16_t wSrcKeyNo, uint16_t wSrcKeyVer, uint16_t wDstKeyNo, 
	uint16_t wDstKeyVer, uint8_t * pUid, uint8_t bUidLen, uint8_t * pSDMReadCtr, uint8_t * pEncdata, uint16_t wEncDataLen, uint8_t * pPlainData);

phStatus_t phalMfIdentity_Sam_X_DecryptSDMPICCData(void * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t * pEncdata, 
	uint16_t wEncDataLen, uint8_t * pPlainData);

#endif /* PHALMFDFLIGHT_SAM_X_H */
