/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * DUT KeyStore Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  Generated 20 Sep, 2022
 *
 */

#ifndef PHKEYSTORE_DUT_H
#define PHKEYSTORE_DUT_H

#include <ph_Status.h>

#ifdef NXPBUILD__PH_KEYSTORE_DUT

#include <phKeyStore.h>

/* Common Interfaces ------------------------------------------------------------------------------------------------------------------- */
phStatus_t phKeyStore_DUT_FormatKeyEntry(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wNewKeyType);

phStatus_t phKeyStore_DUT_SetKUC(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wRefNoKUC);

phStatus_t phKeyStore_DUT_GetKUC(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wRefNoKUC, uint32_t * pLimit,
    uint32_t * pCurVal);

phStatus_t phKeyStore_DUT_ChangeKUC(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wRefNoKUC, uint32_t dwLimit);

phStatus_t phKeyStore_DUT_SetConfig(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue);

phStatus_t phKeyStore_DUT_SetConfigStr(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint8_t *pBuffer,
    uint16_t wBuffLen);

phStatus_t phKeyStore_DUT_GetConfig(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue);

phStatus_t phKeyStore_DUT_GetConfigStr(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wConfig, uint8_t ** ppBuffer,
    uint16_t * pBuffLen);





/* Interfaces for Symmetric Keys ------------------------------------------------------------------------------------------------------- */
phStatus_t phKeyStore_DUT_SetKey(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVersion,
    uint16_t wKeyType, uint8_t * pNewKey, uint16_t wNewKeyVersion);

phStatus_t phKeyStore_DUT_SetKeyAtPos(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wPos,
    uint16_t wKeyType, uint8_t * pNewKey, uint16_t wNewKeyVersion);

phStatus_t phKeyStore_DUT_SetFullKeyEntry(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wNoOfKeys, uint16_t wKeyNo,
    uint16_t wNewRefNoKUC, uint16_t wNewKeyType, uint8_t * pNewKeys, uint16_t * pNewKeyVersionList);

phStatus_t phKeyStore_DUT_GetKeyEntry(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVerBufSize,
       uint16_t * pKeyVer, uint16_t * pKeyVerLen, uint16_t * pKeyType);

phStatus_t phKeyStore_DUT_GetKey(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVer, uint8_t bKeyBufSize,
       uint8_t * pKey, uint16_t * pKeyType);





#ifdef  NXPBUILD__PH_KEYSTORE_ASYM
/* Interfaces for ASymmetric Keys ------------------------------------------------------------------------------------------------------ */

phStatus_t phKeyStore_DUT_SetKeyASym(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wPos, uint16_t wKeyType,
    uint16_t wKeyInfo, uint8_t * pKey, uint16_t wKeyLen);

phStatus_t phKeyStore_DUT_GetKeyASym(phKeyStore_DUT_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wPos, uint16_t wKeyPairType,
    uint16_t * pKeyType, uint8_t * pCurveID, uint8_t * pKey, uint16_t * pKeyLen);

#endif /* NXPBUILD__PH_KEYSTORE_ASYM */

#endif /* NXPBUILD__PH_KEYSTORE_DUT */

#endif /* PHKEYSTORE_DUT_H */
