/*
 * Copyright 2013, 2020, 2023 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software specific Crypto-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <ph_RefDefs.h>
#include <phCryptoSym.h>

#ifdef NXPBUILD__PH_CRYPTOSYM_STUB

#include "phCryptoSym_Stub.h"

phStatus_t phCryptoSym_Stub_Init(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wSizeOfDataParams)
{
    phStatus_t statusTmp;
    if(sizeof(phCryptoSym_Stub_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_CRYPTOSYM);
    }
    PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_CRYPTOSYM);

    /* Init. private data */
    pDataParams->wId = PH_COMP_CRYPTOSYM | PH_CRYPTOSYM_STUB_ID;

    PH_CHECK_SUCCESS_FCT(statusTmp, phCryptoSym_Stub_InvalidateKey(pDataParams))

        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_InvalidateKey(phCryptoSym_Stub_DataParams_t * pDataParams)
{
    /* satisfy compiler */
    if(pDataParams);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_Encrypt(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pPlainBuffer,
    uint16_t  wBufferLength, uint8_t * pEncryptedBuffer)
{
	/* satisfy compiler */
	if (pDataParams || wOption || pPlainBuffer || wBufferLength || pEncryptedBuffer);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_Decrypt(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pEncryptedBuffer,
    uint16_t  wBufferLength, uint8_t * pPlainBuffer)
{
    /* satisfy compiler */
    if(pDataParams || wOption || pEncryptedBuffer || wBufferLength || pPlainBuffer);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_CalculateMac(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, const uint8_t * pData,
    uint16_t  wDataLength, uint8_t * pMac, uint8_t * pMacLength)
{
    /* satisfy compiler */
    if(pDataParams || wOption || pData || wDataLength || pMac || pMacLength);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_LoadIv(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pIV, uint8_t bIVLength)
{
    /* satisfy compiler */
    if(pDataParams || pIV || bIVLength);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_LoadNonce(phCryptoSym_Stub_DataParams_t * pDataParams, uint8_t bCipher, const uint8_t * pNonce,
    uint8_t bNonceLen)
{
    /* satisfy compiler */
    if(pDataParams || bCipher || pNonce || bNonceLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_LoadAdditionalData(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pAddData,
    uint16_t wAddData_Len)
{
    /* satisfy compiler */
    if(pDataParams || pAddData || wAddData_Len);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_LoadKey(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wKeyNo, uint16_t wKeyVersion, uint16_t wKeyType)
{
    /* satisfy compiler */
    if(pDataParams || wKeyNo || wKeyVersion || wKeyType);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_LoadKeyDirect(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pKey, uint16_t wKeyType)
{
    /* satisfy compiler */
    if(pDataParams || pKey || wKeyType);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_DiversifyKey(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wKeyVersion,
    uint8_t * pDivInput, uint8_t  bLenDivInput, uint8_t * pDiversifiedKey, uint8_t * pDivKeyLen)
{
    /* satisfy compiler */
    if(pDataParams || wOption || wKeyNo || wKeyVersion || pDivInput || bLenDivInput || pDiversifiedKey || pDivKeyLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_DiversifyDirectKey(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pKey,
    uint16_t wKeyType, uint8_t * pDivInput, uint8_t bLenDivInput, uint8_t * pDiversifiedKey, uint8_t * pDivKeyLen)
{
    /* satisfy compiler */
    if(pDataParams || wOption || pKey || wKeyType || pDivInput || bLenDivInput || pDiversifiedKey || pDivKeyLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_SetConfig(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wConfig, uint16_t wValue)
{
    /* satisfy compiler */
    if(pDataParams || wConfig || wValue);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_GetConfig(phCryptoSym_Stub_DataParams_t * pDataParams, uint16_t wConfig, uint16_t * pValue)
{
    /* satisfy compiler */
    if(pDataParams || wConfig || pValue);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_SetAuthenticationTag(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pTag, uint8_t bTag_Len)
{
    /* satisfy compiler */
    if(pDataParams || pTag || bTag_Len);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

phStatus_t phCryptoSym_Stub_GetAuthenticationTag(phCryptoSym_Stub_DataParams_t * pDataParams, const uint8_t * pTag, uint8_t * pTag_Len)
{
    /* satisfy compiler */
    if(pDataParams || pTag || pTag_Len);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOSYM);
}

#endif /* NXPBUILD__PH_CRYPTOSYM_STUB */
