/*
 * Copyright 2021 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software specific Crypto-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  SLe: Generated 21.04.2021
 *
 */

#include <ph_Status.h>
#include <ph_RefDefs.h>
#include <phCryptoASym.h>

#ifdef NXPBUILD__PH_CRYPTOASYM_STUB

#include "phCryptoASym_Stub.h"

phStatus_t phCryptoASym_Stub_Init(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wSizeOfDataParams)
{
	phStatus_t wStatus = 0;

	PH_ASSERT_NULL_DATA_PARAM(pDataParams, PH_COMP_CRYPTOASYM);
	if (sizeof(phCryptoASym_Stub_DataParams_t) != wSizeOfDataParams)
	{
		return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_CRYPTOASYM);
	}

	/* Init. private data */
	pDataParams->wId = PH_COMP_CRYPTOASYM | PH_CRYPTOASYM_STUB_ID;

	PH_CHECK_SUCCESS_FCT(wStatus, phCryptoASym_Stub_InvalidateKey(pDataParams));

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}





/* CryptoASym RSA related commands ----------------------------------------------------------------------------------------------------- */





/* CryptoASym Hash related commands ---------------------------------------------------------------------------------------------------- */
phStatus_t phCryptoASym_Stub_ComputeHash(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t bHashAlgo,
    uint8_t * pMessage, uint16_t wMsgLen, uint8_t * pHash, uint16_t * pHashLen)
{
    /* Satisfy compiler */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(bHashAlgo);
    PH_UNUSED_VARIABLE(pMessage);
    PH_UNUSED_VARIABLE(wMsgLen);
    PH_UNUSED_VARIABLE(pHash);
    PH_UNUSED_VARIABLE(pHashLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}





/* CryptoASym ECC related commands ----------------------------------------------------------------------------------------------------- */
phStatus_t phCryptoASym_Stub_ECC_GenerateKeyPair(phCryptoASym_Stub_DataParams_t * pDataParams, uint8_t bCurveID)
{
	/* Satisfy compiler */
	PH_UNUSED_VARIABLE(pDataParams);
	PH_UNUSED_VARIABLE(bCurveID);

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}

phStatus_t phCryptoASym_Stub_ECC_ExportKey(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyBuffSize,
    uint8_t * pCurveID, uint8_t * pKey, uint16_t * pKeyLen)
{
    /* Satisfy compiler */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(wKeyBuffSize);
    PH_UNUSED_VARIABLE(pCurveID);
    PH_UNUSED_VARIABLE(pKey);
    PH_UNUSED_VARIABLE(pKeyLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}

phStatus_t phCryptoASym_Stub_ECC_LoadKey(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint16_t wKeyNo, uint16_t wPos)
{
    /* Satisfy compiler */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(wKeyNo);
    PH_UNUSED_VARIABLE(wPos);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}

phStatus_t phCryptoASym_Stub_ECC_LoadKeyDirect(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pKey, uint16_t wKeyLen)
{
    /* Satisfy compiler */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(pKey);
    PH_UNUSED_VARIABLE(wKeyLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}

phStatus_t phCryptoASym_Stub_ECC_Sign(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t bHashAlgo, uint8_t * pMessage,
    uint16_t wMsgLen, uint8_t * pSign, uint16_t * pSignLen)
{
    /* Satisfy compiler */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(bHashAlgo);
    PH_UNUSED_VARIABLE(pMessage);
    PH_UNUSED_VARIABLE(wMsgLen);
    PH_UNUSED_VARIABLE(pSign);
    PH_UNUSED_VARIABLE(pSignLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}

phStatus_t phCryptoASym_Stub_ECC_Verify(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t bHashAlgo, uint8_t * pMessage,
    uint16_t wMsgLen, uint8_t * pSign, uint16_t wSignLen)
{
    /* Satisfy compiler */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(bHashAlgo);
    PH_UNUSED_VARIABLE(pMessage);
    PH_UNUSED_VARIABLE(wMsgLen);
    PH_UNUSED_VARIABLE(pSign);
    PH_UNUSED_VARIABLE(wSignLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}

phStatus_t phCryptoASym_Stub_ECC_SharedSecret(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wOption, uint8_t * pPublicKey,
    uint16_t wPublicKeyLen, uint8_t * pSharedSecret, uint16_t * pSharedSecretLen)
{
    /* Satisfy compiler */
    PH_UNUSED_VARIABLE(pDataParams);
    PH_UNUSED_VARIABLE(wOption);
    PH_UNUSED_VARIABLE(pPublicKey);
    PH_UNUSED_VARIABLE(wPublicKeyLen);
    PH_UNUSED_VARIABLE(pSharedSecret);
    PH_UNUSED_VARIABLE(pSharedSecretLen);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}





/* CryptoASym Utility functions -------------------------------------------------------------------------------------------------------- */
phStatus_t phCryptoASym_Stub_InvalidateKey(phCryptoASym_Stub_DataParams_t * pDataParams)
{
    /* Satisfy compiler */
    PH_UNUSED_VARIABLE(pDataParams);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}

phStatus_t phCryptoASym_Stub_GetLastStatus(phCryptoASym_Stub_DataParams_t * pDataParams, uint16_t wStatusMsgLen, int8_t * pStatusMsg,
	int32_t * pStatusCode)
{
	/* Satisfy compiler */
	PH_UNUSED_VARIABLE(pDataParams);
	PH_UNUSED_VARIABLE(wStatusMsgLen);
	PH_UNUSED_VARIABLE(pStatusMsg);
	PH_UNUSED_VARIABLE(pStatusCode);

	return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_CRYPTOASYM);
}

#endif /* NXPBUILD__PH_CRYPTOASYM_STUB */
