/*
 * Copyright 2013, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example source for CryptoLibFootPrint that demonstrates Random number generation,
 * Symmetric Crypto and ASymmetric Crypto operation.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $s
 */

#ifndef PH_EXAMPLE_CRYPTOLIBFOOTPRINT_H
#define PH_EXAMPLE_CRYPTOLIBFOOTPRINT_H

/* Standard Headers */
#include <crtdbg.h>
#include <memory.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

/* ReaderLibrary headers, DataStructures and local variables */
#include <ph_Status.h>

#undef NXPBUILD__PH_LOG         /* Disabling Log. To enable comment this line. */

#ifdef NXPBUILD__PH_KEYSTORE
#include <phKeyStore.h>

#define KEY_ENTRIES             4U
#define KEY_VERSION_PAIRS       2U * KEY_ENTRIES
#define KEY_USAGE_COUNTER       1U

#ifdef NXPBUILD__PH_KEYSTORE_SW
phKeyStore_Sw_DataParams_t stKeyStore_Sw;
phKeyStore_Sw_KeyEntry_t aKeyEntry[KEY_ENTRIES];
phKeyStore_Sw_KeyVersionPair_t aKeyVersion[KEY_VERSION_PAIRS];
phKeyStore_Sw_KUCEntry_t aKeyUsageCounter[KEY_USAGE_COUNTER];
#endif /* NXPBUILD__PH_KEYSTORE_SW */
#endif /* NXPBUILD__PH_KEYSTORE */

#ifdef NXPBUILD__PH_CRYPTOSYM
#include <phCryptoSym.h>
#endif /* NXPBUILD__PH_CRYPTOSYM */

#define TRUE PH_ON
#define FALSE PH_OFF


#define PAD_LEN                 200
#define PAD_CHAR                '-'

#define CHECK_SUCCESS(Status, PrintMsg)                             \
    if ( (Status) != PH_ERR_SUCCESS )                               \
    {                                                               \
        if ( (PrintMsg) )                                           \
        {                                                           \
            printf ( "\n\n" );                                      \
            printf ( "An error occurred: (0x%04X)\n", (Status) );   \
            printf ( "Pressing any key will exit the demo.\n" );    \
            _getch ();                                              \
        }                                                           \
        return 0;                                                   \
    }

#define ToInt(Data, Output)                                         \
    if(((Data[0] >= 'A') && (Data[0] <= 'Z')) ||                    \
       ((Data[0] >= 'a') && (Data[0] <= 'z')))                      \
        Output = (uint32_t) Data[0];                                \
    else                                                            \
        Output = (uint32_t) atoi(Data)

#define EXIT_IF_REQUESTED(Option) if ( ( Option == 'x' ) || ( Option == 'X' ) )  exit ( 0 );
#define RETURN_IF_REQUESTED(Option) if ( ( Option == 'r' ) || ( Option == 'R' ) ) return PH_ERR_SUCCESS;
#define END_LOOP(Option) (dwChoice != 'x') && (dwChoice != 'X') && (dwChoice != 'r') && (dwChoice != 'R')

enum Feature
{
    FEATURE_TEMPORARY = 0,

#ifdef  NXPBUILD__PH_CRYPTORNG
    RANDOM_NUMBER,
#endif /*  NXPBUILD__PH_CRYPTORNG */

#ifdef  NXPBUILD__PH_CRYPTOSYM
    SYMMETRIC_CRYPTO,
#endif /*  NXPBUILD__PH_CRYPTOSYM */

#ifdef  NXPBUILD__PH_CRYPTOASYM
    ASYMMETRIC_CRYPTO,
#endif /*  NXPBUILD__PH_CRYPTOASYM */

#if !defined (NXPBUILD__PH_CRYPTORNG) && !defined (NXPBUILD__PH_CRYPTOSYM) && !defined (NXPBUILD__PH_CRYPTOASYM)
#error Please enable any one (CryptoSym, CryptoASym or CryptoRng) of the feature to proceed
#endif /* NXPBUILD__PH_CRYPTORNG */

    FEATURE_MAX
};

extern void * pKeyStore;

#ifdef NXPBUILD__PH_LOG
phLog_RegisterEntry_t aLogRegisterEntries[16];
phLog_LogEntry_t aLogEntries[48];
#endif /* NXPBUILD__PH_LOG */

#ifdef NXPBUILD__PH_LOG
void CryptoLibFootPrint_Log(void* pDataParams, uint8_t bOption, phLog_LogEntry_t* pEntries, uint16_t wEntryCount);
#endif /* NXPBUILD__PH_LOG */

void PrintASCII(uint8_t * pBuffer, uint16_t wBuffLen, uint8_t bRemoveNullChar);
void PrintHEX(uint8_t * pBuffer, uint16_t wBuffLen);
void PrintData(uint8_t* pBuffer, uint32_t dwLength, char* pFormat, char* pSpecialChar);

phStatus_t DispalyAddStatus(void * pDataParams, phStatus_t wStatus);

#endif /* PH_EXAMPLE_CRYPTOLIBFOOTPRINT_H */
