/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions of Software implementation of MIFARE (R) protocol layer.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALMIFARE_SAMAV2_X_INT_H
#define PHPALMIFARE_SAMAV2_X_INT_H

#include <ph_Status.h>
#include <phpalMifare.h>

/** \addtogroup ph_Private
* @{
*/

/**
* \brief Convert HAL Nak codes into palMifare NAK codes.
* \return Status code
* \retval #PHPAL_MIFARE_ERR_NAK0 NAK 0.
* \retval #PHPAL_MIFARE_ERR_NAK1 NAK 1.
* \retval #PHPAL_MIFARE_ERR_NAK4 NAK 4.
* \retval #PHPAL_MIFARE_ERR_NAK5 NAK 5.
* \retval Other Depending on implementation and underlying component.
*/
phStatus_t phpalMifare_SamAV2_X_ConvertNak(
    phStatus_t status   /**< [In] HAL NAK Code. */
    );

/** @}
* end of ph_Private group
*/

#endif /* PHPALMIFARE_SAMAV2_X_INT_H */
