/*
 * Copyright 2013, 2019 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Software ISO14443-3A Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI14443P3A_SW_INT_H
#define PHPALI14443P3A_SW_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
 * @{
 */

#define PHPAL_I14443P3A_REQUEST_CMD			0x26U			/**< ReqA Command code */
#define PHPAL_I14443P3A_WAKEUP_CMD			0x52U			/**< WupA Command code */
#ifdef NXPBUILD__PHPAL_I14443P3A_NDA
#define PHPAL_I14443P3A_REQUEST_S_CMD		0x7AU			/**< ReqS Command code */
#define PHPAL_I14443P3A_WAKEUP_S_CMD		0x7DU			/**< WupS Command code */
#endif /* NXPBUILD__PHPAL_I14443P3A_NDA */
#define PHPAL_I14443P3A_HALT_CMD			0x50U			/**< HltA Command code */
#define PHPAL_I14443P3A_CASCADE_TAG			0x88U			/**< Cascade Tag (CT) value */
#define PHPAL_I14443P3A_ATQA_LENGTH			2U				/**< Length of AtqA */
#define PHPAL_I14443P3A_SELECTION_TIME_US	85U				/**< Wait time for selection command in microseconds */
#define PHPAL_I14443P3A_HALT_TIME_US		1100U			/**< Wait time for halt command in microseconds */
#define PHPAL_I14443P3A_EXT_TIME_US			60				/**< Time extension in microseconds for all commands.  */

/**
 * \brief Perform a ISO14443-3A Request or Wakeup command.
 *
 * Request Codes:\n
 * REQUEST: bReqCode = 0x52\n
 * WAKEUP:  bReqCode = 0x26
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval #PH_ERR_PROTOCOL_ERROR Invalid response received.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phpalI14443p3a_Sw_RequestAEx(
		phpalI14443p3a_Sw_DataParams_t * pDataParams,	/**< [In] Pointer to this layer's parameter structure. */
		uint8_t bReqCode,								/**< [In] request code according to ISO14443-3A. */
		uint8_t * pAtqa									/**< [Out] AtqA; uint8_t[2]. */
	);

/** @}
 * end of ph_Private
 */

#endif /* PHPALI14443P3A_SW_INT_H */
