/*
 * Copyright 2013, 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Configuration for SamAV2 (Rc663-specific) HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_SAMAV2_RC663_CONFIG_H
#define PHHALHW_SAMAV2_RC663_CONFIG_H

#include <ph_Status.h>
#include <phhalHw.h>

/** \defgroup phhalHw_SamAV2_Rc663_Config Rc663 User Configuration
* \brief Custom Configuration of hardware related settings.
* @{
*/

/** \name RxThreshold values
*/
/** @{ */
#define PHHAL_HW_SAMAV2_RC663_RXTHRESHOLD_I14443A_106   0x32U   /**< RxThreshold for ISO14443A @ 106kbit/s. */
#define PHHAL_HW_SAMAV2_RC663_RXTHRESHOLD_I14443A_212   0x32U   /**< RxThreshold for ISO14443A @ 212kbit/s. */
#define PHHAL_HW_SAMAV2_RC663_RXTHRESHOLD_I14443A_424   0x32U   /**< RxThreshold for ISO14443A @ 424kbit/s. */
#define PHHAL_HW_SAMAV2_RC663_RXTHRESHOLD_I14443A_848   0x32U   /**< RxThreshold for ISO14443A @ 848kbit/s. */
/** @} */

/**
* end of phhalHw_Rc663_Config group
* @}
*/

#endif /* PHHALHW_SAMAV2_RC663_CONFIG_H */
