/*
 * Copyright 2013, 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Generic Tools Component of phHostComm component.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_SAMAV2_HCUTILS_H
#define PHHALHW_SAMAV2_HCUTILS_H

#include <ph_Status.h>
#include <ph_TypeDefs.h>

/** \defgroup phhalHw_SamAV2_HcUtils Utils
 * @{
 */

#ifdef NXPBUILD__PHHAL_HW_RFIDLITE
/*
 *
 * \brief  This is only a wrapper layer to abstract the different Host Communication implementations.
 * With this wrapper it is possible to support more than one Host Communication
 * in parallel, by adapting this wrapper.
 * @{
 */
phStatus_t phhalHw_SamAV2_HcUtils_GetCheckLcLe(
	uint8_t * pCmd,			/**< [In]: address of buffer that contains the command. */
	uint16_t wCmdLength,	/**< [In]: length of the command. */
	uint8_t * isLcPresent,	/**< [Out]: LC byte presence indicator . */
	uint8_t * LcLength,		/**< [Out]: length of the payload of the command . */
	uint8_t * isLePresent	/**< [Out]: LE byte presence indicator . */
);

/**
 * \brief Truncate a 16-Bytes MAC buffer into a 8-Bytes Buffer
 *
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 * \retval Other Depending on implementation and underlaying component.
 */
phStatus_t phhalHw_SamAV2_HcUtils_TruncateMacBuffer(
    uint8_t * pIoBuffer,	/**< [In]: The 16 bytes MAC input which should be truncated. */
    uint8_t * MacLength		/**< [Out]: Truncated MAC which is 8 bytes. */
    );
#endif /* NXPBUILD__PHHAL_HW_RFIDLITE */

/**
 * \brief Parse Status Word Sw1Sw2 from the SAM.
 * \return Status code
 * \retval #PH_ERR_SUCCESS Operation successful.
 */
phStatus_t phhalHw_SamAV2_HcUtils_Cmd_ResolveErrorCode(
	uint8_t * pSw1Sw2,		/**< [In] Pointer to the status code sent by the SAM. */
	uint16_t wComponentID	/**< [In] ID of the component to be added. */
);

/**
 * @}
 * end of phhalHw_SamAV2_HcUtils
 */

#endif /* PHHALHW_SAMAV2_HCUTILS_H */
