/*
 * Copyright 2013, 2015, 2017, 2019, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/*
 * Pipe specific HAL-Component of Reader Library Framework.
 * $RCSfile $
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_RDCARDSIM_INT_H
#define PHHALHW_RDCARDSIM_INT_H

#include <stdio.h>  /* PRQA S 5124 */
#ifdef _WIN32
#pragma warning(push)           /* PRQA S 3116 */
#pragma warning(disable:4001)   /* PRQA S 3116 */
#include <stdlib.h>
#pragma warning(pop)            /* PRQA S 3116 */
#else
#include <stdlib.h>
#endif

#define FRAME_HEADER_NCHAR    3
#define FRAME_STATUS_NCHAR    3
#define FRAME_NBYTES_NCHAR    4
#define FRAME_NBITS_NCHAR     2
#define FRAME_TIME_NCHAR      8
#define FRAME_PRMADDR_NCHAR   2
#define FRAME_PRMDATA_NCHAR   8
#define FRAME_FIELD_MAX_NCHAR 10

#define FNULL             (FILE *) NULL

#define CRC_OFF            0
#define CRC_ON             1

#define TBD_PIPE_TX_TIMEOUT_VAL 1000

/* Parameters located in NCSIM reader model */
#define PHHAL_HW_RDCARDSIM_CONFIG_PARITY            0x80U   /**< Controls the enable/disable of PARITY. */
#define PHHAL_HW_RDCARDSIM_CONFIG_DIS_MFCRYTO1      0x81U   /**< Controls the enable/disable of MFCRYPTO1 */
#define PHHAL_HW_RDCARDSIM_CONFIG_TX_CRC            0x82U   /**< Controls the enable/disable of transmit CRC */
#define PHHAL_HW_RDCARDSIM_CONFIG_RX_CRC            0x83U   /**< Controls the enable/disable of receive CRC */
#define PHHAL_HW_RDCARDSIM_CONFIG_RX_US_TIMEOUT_LO  0x84U   /**< Time (in microseconds) the receiver timeout */
#define PHHAL_HW_RDCARDSIM_CONFIG_RX_US_TIMEOUT_HI  0x85U   /**< Time (in microseconds) the receiver timeout */
#define PHHAL_HW_RDCARDSIM_CONFIG_FDT_US_TIME       0x86U   /**< FDT time (in microseconds) of the last transmit-receive transaction */
#define PHHAL_HW_RDCARDSIM_CONFIG_RX_MS_TIMEOUT_LO  0x74U   /**< Time (in miliseconds) the receiver timeout */
#define PHHAL_HW_RDCARDSIM_CONFIG_RX_MS_TIMEOUT_HI  0x75U   /**< Time (in miliseconds) the receiver timeout */
#define PHHAL_HW_RDCARDSIM_CONFIG_FDT_MS_TIME       0x76U   /**< FDT time (in miliseconds) of the last transmit-receive transaction */
#define PHHAL_HW_RDCARDSIM_CONFIG_RX_OFFSET         0x77U   /**< RX bit offset in the rx buffer */
#define PHHAL_HW_RDCARDSIM_CONFIG_RX_BAUDRATE       0x87U   /**< RX-BAUDRATE */
#define PHHAL_HW_RDCARDSIM_CONFIG_TX_BAUDRATE       0x88U   /**< TX-BAUDRATE */
#define PHHAL_HW_RDCARDSIM_CONFIG_COMMUNICATION_INT 0x89U   /**< defines wether it is a wireless comm or via TP */
#define PHHAL_HW_RDCARDSIM_CONFIG_RF_RESET_ON_TIMEOUT 0x90U /**< Defines RF reset on timeout */
#define PHHAL_HW_RDCARDSIM_CONFIG_COMMUNICATION     0xE000U   /**< defines wether it is a wireless comm or via TP */
#define PHHAL_HW_RDCARDSIM_CONFIG_TIME_T1           0xE001U   /**< Additional timeout value T1 for test pad communication */
#define PHHAL_HW_RDCARDSIM_CONFIG_TIME_T2           0xE002U   /**< Additional timeout value T2 for test pad communication */
#define PHHAL_HW_RDCARDSIM_CONFIG_TIME_T3           0xE003U   /**< Additional timeout value T3 for test pad communication */
#define PHHAL_HW_RDCARDSIM_CONFIG_TIME_T4           0xE004U   /**< Additional timeout value T4 for test pad communication */
#define PHHAL_HW_RDCARDSIM_CONFIG_SYNC_OPTION       0xE005U   /**< Optional Sync option for test pad communication */
#define PHHAL_HW_RDCARDSIM_CONFIG_ENV_ENABLE        0xE006U   /**< Enable a direct communication to the ncsim */
#define PHHAL_HW_RDCARDSIM_CONFIG_RX2TXWAIT         0xE01EU   /**< Gets or Set the timing between the Rx and Tx frame. This configuration will be used by RdCardSim component. */
#define PHHAL_HW_RDCARDSIM_CONFIG_ENV_C40_MODE      0xE01FU   /**< Enables the C40 mode communication */

/* Defines for UART*/
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_FI             0xE007U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_DI             0xE008U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_ETU_CLK        0xE009U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_STOPBITS       0xE00AU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_CWI            0xE00BU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_BWI            0xE00CU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_FWI            0xE00DU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_WI             0xE00EU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_T0             0xE00FU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_T1             0xE010U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_RSTTYPE        0xE011U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_CRC_LRC        0xE012U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_N              0xE013U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_PARITY         0xE014U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_INV            0xE015U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_PAROFF         0xE016U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_PARERRCNT      0xE017U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_PARERR         0xE018U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_SFRAME         0xE019U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_CLKSTOP        0xE01AU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_CLASS          0xE01BU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_TB_CLK         0xE01CU
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_RBSYNC         0xE01DU

/* Defines for UART*/
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_FI_INT             0x60U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_DI_INT             0x59U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_ETU_CLK_INT        0x58U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_STOPBITS_INT       0x57U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_CWI_INT            0x56U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_BWI_INT            0x55U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_FWI_INT            0x54U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_WI_INT             0x53U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_T0_INT             0x52U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_T1_INT             0x51U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_RSTTYPE_INT        0x50U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_CRC_LRC_INT        0x49U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_N_INT              0x48U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_PARITY_INT         0x47U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_INV_INT            0x46U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_PAROFF_INT         0x45U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_PARERRCNT_INT      0x44U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_PARERR_INT         0x43U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_SFRAME_INT         0x42U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_CLKSTOP_INT        0x41U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_CLASS_INT          0x40U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_TB_CLK_INT         0x39U
#define PHHAL_HW_RDCARDSIM_CONFIG_UT_RBSYNC_INT         0x38U

enum FrameHeader
{
    CMD_ENV         = 1,            /**< NCSIM testbench environment command header string of the PIPE frame */
    CMD_PIC         = CMD_ENV + 1,  /**< Reader model and PICC exchange header string of the PIPE frame */
    CMD_TUS         = CMD_ENV + 2,  /**< Time unit measurement header string of the PIPE frame */
    CMD_PMW         = CMD_ENV + 3,  /**< Write operation to the testbench registers header string of the PIPE frame */
    CMD_PMR         = CMD_ENV + 4,  /**< Read operation to the testbench registers header string of the PIPE frame */
    CMD_MEM         = CMD_ENV + 5,  /**< Memory operations to the simulator header string of the PIPE frame */
	  CMD_WAF         = CMD_ENV + 6,  /**< Wafer Test Communication */
    CMD_PCC         = CMD_ENV + 7,  /**< UART Communication */
    END_HEADER_LIST = CMD_ENV + 8,
};

enum FrameStatusCodes
{
    STAT_ACK         = 1,               /**< Acknowledge code string of the PIPE frame */
    STAT_NAK         = STAT_ACK + 1,    /**< Command is uncessfull */
    STAT_ERP         = STAT_ACK + 2,    /**< PIPE Protocol error code string of the PIPE frame */
    STAT_ERS         = STAT_ACK + 3,    /**< Error in the transmited string in the frame (unrecognised header) */
    STAT_ETO         = STAT_ACK + 4,    /**< Error, caused by Timeout */
    STAT_ECR         = STAT_ACK + 5,    /**< Error, caused by CRC Error */
    STAT_EPR         = STAT_ACK + 6,    /**< Error, caused by Parity Error */
    STAT_EFR         = STAT_ACK + 7,    /**< Error, caused by Frame Error */
    END_STATUS_LIST  = STAT_ACK + 8
};

enum RxStatusCodes
{
    RXSTAT_ACK             = STAT_ACK,
    RXSTAT_NAK             = STAT_NAK,
    RXSTAT_ERP             = STAT_ERP,
    RXSTAT_ERS             = STAT_ERS,
    RXSTAT_ETO             = STAT_ETO,
    RXSTAT_ECR             = STAT_ECR,    /**< Error, caused by CRC Error */
    RXSTAT_EPR             = STAT_EPR,    /**< Error, caused by Parity Error */
    RXSTAT_EFR             = STAT_EFR,    /**< Error, caused by Frame Error */
    RXSTAT_ERROR           = STAT_ACK + 100,
    RXSTAT_NO_HDR          = RXSTAT_ERROR + 1,
    RXSTAT_INVALID_HDR     = RXSTAT_ERROR + 2,
    RXSTAT_INVALID_STATUS  = RXSTAT_ERROR + 3,
    RXSTAT_INVALID_NBYTES  = RXSTAT_ERROR + 4,
    RXSTAT_INVALID_NBITS   = RXSTAT_ERROR + 5,
    RXSTAT_INVALID_NPAYLD  = RXSTAT_ERROR + 6,
    RXSTAT_NO_EOT          = RXSTAT_ERROR + 7,
    END_RXSTATUS_LIST      = RXSTAT_ERROR + 8
};

/* Defines used for the CMD_MEM command*/
#define FRAME_MEM_NBYTES                13U   /**< Minimum return string from an upload command*/
#define CMDMEM_MAX_XFER_SIZE       64U   /**< Largest datablock to transfer in a single command */

const uint8_t * phhalHw_RdCardSim_BaudRateStr(
    uint8_t bBaud   /**< [In] Baud rate */
    );

const uint8_t * phhalHw_RdCardSim_ParityStr(
    uint8_t bParity /**< [In] Parity control */
    );

const uint8_t * phhalHw_RdCardSim_SchemeStr(
    uint8_t bBaud
    );

uint16_t phhalHw_RdCardSim_StrFind(
                                   char  *pStr,        /**< [In] String to process */
                                   const char  *pKey   /**< [In] String to find */
                                   );

uint8_t phhalHw_RdCardSim_NumBufferAlloc(
    phhalHw_RdCardSim_DataParams_t * pDataParams
    );

phStatus_t phhalHw_RdCardSim_Init_Buffer(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t * pBuffer
    );

phStatus_t phhalHw_RdCardSim_BufferAlloc(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t ** ppBuffer
    );

phStatus_t phhalHw_RdCardSim_BufferDeAlloc(
    phhalHw_RdCardSim_DataParams_t * pDataParams,
    uint8_t * pBuffer
    );

phStatus_t  phhalHw_RdCardSim_TxFrame(
                                      phhalHw_RdCardSim_DataParams_t * pDataParams,
                                      uint8_t bHeader,      /**< [In] PIPE protocol header */
                                      uint16_t wNBytes,     /**< [In] Number of bytes to transmit (only applicable to PIC frame) */
                                      uint16_t wNBits,      /**< [In] Number of bits to transmit (only applicable to PIC frame) */
                                      uint8_t * pPayld,     /**< [In] Payload of the TxFrame */
                                      uint8_t * pTxFrame        /**< [Out] TxFrame to send throught to the PIPE */
                                      );

phStatus_t  phhalHw_RdCardSim_RxFrame(
                                      uint8_t * pRxFrame,   /**< [In] RxFrame received from the PIPE */
                                      uint8_t bHeader,      /**< [In] Expectd PIPE protocol header */
                                      uint16_t * pNBytes,   /**< [Out] Number of bytes received (only applicable to PIC frame) */
                                      uint8_t * pNBits,     /**< [Out] Number of bits received (only applicable to PIC frame)  */
                                      uint8_t * pPayld,     /**< [Out] Received payload */
                                      uint8_t bC40ModeEnabled /**< [In] decoding mode for C40 used */
                                      );

phStatus_t phhalHw_RdCardSim_GetSimTime(
                                        phhalHw_RdCardSim_DataParams_t * pDataParams,
                                        uint8_t * pSimTime
                                        );

#endif /* PHHALHW_RDCARDSIM_INT_H */
