/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Rc523 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_MFCCRYPTO_INT_H
#define PHHALHW_MFCCRYPTO_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
*  @{
*/
#define PHHAL_HW_MFCCRYPTO_STATE_ENCRYPT_OFF    0x00    /**< Send/receive msg in clear */
#define PHHAL_HW_MFCCRYPTO_STATE_SIM_FEED       0x01    /**<Simple feedback mode */
#define PHHAL_HW_MFCCRYPTO_STATE_SP_FEED        0x02    /**< Special feedback mode */
#define PHHAL_HW_MFCCRYPTO_STATE_SP_FEED1_INIT  0x03    /**< Special feedback mode (at initial authentication) */
#define PHHAL_HW_MFCCRYPTO_STATE_SP_FEED2       0x04    /**< Special feedback mode 2 */

#define MF_KEYSIZE_BITS     48                      /**< The Crypto1 key size */
#define MF_KEYSIZE_BYTES    (MF_KEYSIZE_BITS >> 3)  /**< The Crypto1 key size (in nr of bytes) */
#define MF_RANDREGSIZE_BITS 16                      /**< The RA and RB register size */
#define MF_RANDSIZE_BITS    32                      /**< The RA and RB size */
#define MF_RANDSIZE_BYTES   (MF_RANDSIZE_BITS >> 3) /**< The RA and RB size (in nr of bytes) */
#define MF_UIDSIZE_BITS     32                      /**< The UID size */
#define MF_UIDSIZE_BYTES    (MF_UIDSIZE_BITS >> 3)  /**< The UID size (in nr of bytes) */
#define MF_CRCSIZE_BYTES    2                       /**< The CRC size */

uint8_t phhalHw_MfcCrypto_ComputeF(uint8_t * reg);

void phhalHw_MfcCrypto_SeedRandReg(uint8_t * reg, uint8_t in);
void phhalHw_MfcCrypto_SeedRandRegWithBuffer(uint8_t * reg, uint8_t * in, uint16_t size);

uint8_t phhalHw_MfcCrypto_ClockRandReg(uint8_t * reg);
void phhalHw_MfcCrypto_ClockRandRegWithBuffer(uint8_t * reg, uint8_t * out, uint16_t size);

void phhalHw_MfcCrypto_LoadCryptoReg(uint8_t * reg, uint8_t in);
void phhalHw_MfcCrypto_LoadCryptoRegWithBuffer(uint8_t * reg, uint8_t * in, uint16_t size);

uint8_t phhalHw_MfcCrypto_SimFeedCryptoReg(uint8_t * reg);

uint8_t phhalHw_MfcCrypto_Feed1CryptoReg(uint8_t * reg, uint8_t in);

uint8_t phhalHw_MfcCrypto_Feed2CryptoReg(uint8_t * reg, uint8_t in);

void phhalHw_MfcCrypto_SwapByteArray(uint8_t * pByteArray, uint16_t wArrayLen);

void phhalHw_MfcCrypto_InsertBits(
                                  uint8_t * pBitArray,
                                  uint32_t * pdwBitArrayLen,
                                  uint32_t dwBitPosition,
                                  uint8_t * pBits,
                                  uint32_t dwBitCount,
                                  uint8_t bReversed,
                                  uint8_t bReplace);

void phhalHw_MfcCrypto_GetBits(
                               uint8_t * pBitArray,
                               uint32_t dwBitArrayLen,
                               uint32_t dwBitPosition,
                               uint8_t * pBits,
                               uint32_t dwBitCount,
                               uint8_t bReversed);

void  phhalHw_MfcCrypto_ResetCrypto(phhalHw_MfcCrypto_DataParams_t * pDataParams);

/** @}
* end of ph_Private group
*/

#endif /* PHHALHW_MFCCRYPTO_INT_H */
