/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * SAM (Secure Access Module) internal implementation for Reader Library
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 *
 * History:
 *  Rajendran Kumar: Generated 03. Jan 2024
 *
 */

#ifndef PHBALREG_SAM_INT_H
#define PHBALREG_SAM_INT_H

#include <ph_Status.h>

#define PHBAL_SAM_INVALID                       0xFFU

#define PHBAL_SAM_MAX_FRAME_LEN                 256U    /**< Maximum Length of SAM Frame. */
#define PHBAL_SAM_FRAME_HEADER_LEN                  6U  /**< Length of a command header. */
#define PHBAL_SAM_FRAME_CLA_POS                     0U  /**< Position of the CLA code. */
#define PHBAL_SAM_FRAME_INS_POS                     1U  /**< Position of the INS code. */
#define PHBAL_SAM_FRAME_STATUS_POS                  2U  /**< Position of the status . */
#define PHBAL_SAM_FRAME_LEN_POS                     4U  /**< Position of the length. */
#define PHBAL_SAM_FRAME_PAYLOAD_POS                 6U  /**< Position of the payload. */

phStatus_t phbalReg_Sam_Int_CheckResponse(uint16_t wCmd, uint8_t * pRxBuffer, uint16_t wRxBuffLen, uint8_t ** ppData,
    uint16_t * pDataLen);

phStatus_t phbalReg_Sam_Int_ParseAtr(uint8_t * pAtr, uint16_t wAtrLen, uint8_t * pTa1, uint8_t * pSpecificMode);

#endif /* PHBALREG_SAM_INT_H */
